/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.gvsig.compat.CompatLocator;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;

public class DefaultEditingServiceParameterOptions
implements Iterable<EditingServiceParameterOptions.ParameterOption>,
EditingServiceParameterOptions {
    private final List<EditingServiceParameterOptions.ParameterOption> options = new ArrayList<EditingServiceParameterOptions.ParameterOption>();

    public DefaultEditingServiceParameterOptions add(EditingServiceParameterOptions.ParameterOption option) {
        this.options.add(option);
        return this;
    }

    public DefaultEditingServiceParameterOptions add(String label, Object value, String consoleValue) {
        this.options.add(new DefaultParameterOption(label, value, consoleValue));
        return this;
    }

    @Override
    public Iterator<EditingServiceParameterOptions.ParameterOption> iterator() {
        this.options.sort((o1, o2) -> ((DefaultParameterOption)o1).compareTo((DefaultParameterOption)o2));
        return this.options.iterator();
    }

    public Object getValue(Object key, Object defaultValue) throws InvalidEntryException {
        if (key instanceof String) {
            String s = (String)key;
            for (EditingServiceParameterOptions.ParameterOption option : this.options) {
                if (!StringUtils.equalsIgnoreCase((String)s, (String)option.getConsoleValue())) continue;
                return option.getValue();
            }
            for (EditingServiceParameterOptions.ParameterOption option : this.options) {
                if (!StringUtils.equalsIgnoreCase((String)s, (String)option.getLabel())) continue;
                return option.getValue();
            }
            for (EditingServiceParameterOptions.ParameterOption option : this.options) {
                if (!StringUtils.equalsIgnoreCase((String)s, (String)Objects.toString(option.getValue(), null))) continue;
                return option.getValue();
            }
            if (StringUtils.isNotBlank((String)s)) {
                for (EditingServiceParameterOptions.ParameterOption option : this.options) {
                    if (!StringUtils.startsWithIgnoreCase((String)option.getConsoleValue(), (String)s)) continue;
                    return option.getValue();
                }
            }
            if (this.isValidValue(defaultValue)) {
                return defaultValue;
            }
            throw new InvalidEntryException(null);
        }
        if (this.isValidValue(key)) {
            return key;
        }
        if (this.isValidValue(defaultValue)) {
            return defaultValue;
        }
        throw new InvalidEntryException(null);
    }

    public boolean isValidValue(Object value) {
        for (EditingServiceParameterOptions.ParameterOption option : this.options) {
            if (!ObjectUtils.equals((Object)option.getValue(), (Object)value)) continue;
            return true;
        }
        return false;
    }

    public String getLabel(Object value) {
        for (EditingServiceParameterOptions.ParameterOption option : this.options) {
            if (!ObjectUtils.equals((Object)option.getValue(), (Object)value)) continue;
            return option.getLabel();
        }
        return null;
    }

    public String getConsoleValue(Object value) {
        for (EditingServiceParameterOptions.ParameterOption option : this.options) {
            if (!ObjectUtils.equals((Object)option.getValue(), (Object)value)) continue;
            return option.getConsoleValue();
        }
        return "";
    }

    public static class DefaultParameterOption<T>
    implements EditingServiceParameterOptions.ParameterOption,
    Comparable {
        String consoleValue;
        String label;
        Object value;

        public DefaultParameterOption(String label, Object value, String consoleValue) {
            this.label = label;
            this.value = value;
            this.consoleValue = consoleValue;
        }

        public String getLabel() {
            return this.label;
        }

        public Object getValue() {
            return this.value;
        }

        public String getConsoleValue() {
            return this.consoleValue;
        }

        public String toString() {
            return this.label;
        }

        public int compareTo(Object o) {
            return CompatLocator.getStringUtils().compare(this.getLabel(), ((DefaultParameterOption)o).getLabel(), true);
        }
    }
}

