/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class ANSIBuffer {
    private boolean ansiEnabled = true;
    private final StringBuffer ansiBuffer = new StringBuffer();
    private final StringBuffer plainBuffer = new StringBuffer();

    public ANSIBuffer() {
    }

    public ANSIBuffer(String string) {
        this.append(string);
    }

    public void setAnsiEnabled(boolean bl) {
        this.ansiEnabled = bl;
    }

    public boolean getAnsiEnabled() {
        return this.ansiEnabled;
    }

    public String getAnsiBuffer() {
        return this.ansiBuffer.toString();
    }

    public String getPlainBuffer() {
        return this.plainBuffer.toString();
    }

    public String toString(boolean bl) {
        return bl ? this.getAnsiBuffer() : this.getPlainBuffer();
    }

    public String toString() {
        return this.toString(this.ansiEnabled);
    }

    public ANSIBuffer append(String string) {
        this.ansiBuffer.append(string);
        this.plainBuffer.append(string);
        return this;
    }

    public ANSIBuffer attrib(String string, int n) {
        this.ansiBuffer.append(ANSICodes.attrib(n)).append(string).append(ANSICodes.attrib(0));
        this.plainBuffer.append(string);
        return this;
    }

    public ANSIBuffer red(String string) {
        return this.attrib(string, 31);
    }

    public ANSIBuffer blue(String string) {
        return this.attrib(string, 34);
    }

    public ANSIBuffer green(String string) {
        return this.attrib(string, 32);
    }

    public ANSIBuffer black(String string) {
        return this.attrib(string, 30);
    }

    public ANSIBuffer yellow(String string) {
        return this.attrib(string, 33);
    }

    public ANSIBuffer magenta(String string) {
        return this.attrib(string, 35);
    }

    public ANSIBuffer cyan(String string) {
        return this.attrib(string, 36);
    }

    public ANSIBuffer bold(String string) {
        return this.attrib(string, 1);
    }

    public ANSIBuffer underscore(String string) {
        return this.attrib(string, 4);
    }

    public ANSIBuffer blink(String string) {
        return this.attrib(string, 5);
    }

    public ANSIBuffer reverse(String string) {
        return this.attrib(string, 7);
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(ANSICodes.setkey("97", "97;98;99;13") + ANSICodes.attrib(0));
        System.out.flush();
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println("GOT: " + string);
        }
    }

    public static class ANSICodes {
        static final int OFF = 0;
        static final int BOLD = 1;
        static final int UNDERSCORE = 4;
        static final int BLINK = 5;
        static final int REVERSE = 7;
        static final int CONCEALED = 8;
        static final int FG_BLACK = 30;
        static final int FG_RED = 31;
        static final int FG_GREEN = 32;
        static final int FG_YELLOW = 33;
        static final int FG_BLUE = 34;
        static final int FG_MAGENTA = 35;
        static final int FG_CYAN = 36;
        static final int FG_WHITE = 37;
        static final char ESC = '\u001b';

        private ANSICodes() {
        }

        public static String setmode(int n) {
            return "\u001b[=" + n + "h";
        }

        public static String resetmode(int n) {
            return "\u001b[=" + n + "l";
        }

        public static String clrscr() {
            return "\u001b[2J";
        }

        public static String clreol() {
            return "\u001b[K";
        }

        public static String left(int n) {
            return "\u001b[" + n + "D";
        }

        public static String right(int n) {
            return "\u001b[" + n + "C";
        }

        public static String up(int n) {
            return "\u001b[" + n + "A";
        }

        public static String down(int n) {
            return "\u001b[" + n + "B";
        }

        public static String gotoxy(int n, int n2) {
            return "\u001b[" + n + ";" + n2 + "H";
        }

        public static String save() {
            return "\u001b[s";
        }

        public static String restore() {
            return "\u001b[u";
        }

        public static String attrib(int n) {
            return "\u001b[" + n + "m";
        }

        public static String setkey(String string, String string2) {
            return "\u001b[" + string + ";" + string2 + "p";
        }
    }
}

