/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JFrame;
import jline.SimpleCompletor;

public class ClassNameCompletor
extends SimpleCompletor {
    public ClassNameCompletor() throws IOException {
        this((SimpleCompletor.SimpleCompletorFilter)null);
    }

    public ClassNameCompletor(SimpleCompletor.SimpleCompletorFilter simpleCompletorFilter) throws IOException {
        super(ClassNameCompletor.getClassNames(), simpleCompletorFilter);
        this.setDelimiter(".");
    }

    public static String[] getClassNames() throws IOException {
        Object object;
        Class[] classArray;
        HashSet<URL> hashSet = new HashSet<URL>();
        for (classArray = ClassNameCompletor.class.getClassLoader(); classArray != null; classArray = classArray.getParent()) {
            if (!(classArray instanceof URLClassLoader)) continue;
            hashSet.addAll(Arrays.asList(((URLClassLoader)classArray).getURLs()));
        }
        classArray = new Class[]{String.class, JFrame.class};
        for (int i = 0; i < classArray.length; ++i) {
            URLConnection object2;
            object = classArray[i].getResource("/" + classArray[i].getName().replace('.', '/') + ".class");
            if (object == null || !((object2 = ((URL)object).openConnection()) instanceof JarURLConnection)) continue;
            hashSet.add(((JarURLConnection)object2).getJarFileURL());
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (URL uRL : hashSet) {
            Object object2;
            File file = new File(uRL.getFile());
            if (file.isDirectory()) {
                object2 = ClassNameCompletor.getClassFiles(file.getAbsolutePath(), new HashSet(), file, new int[]{200});
                hashSet2.addAll((Collection<String>)object2);
                continue;
            }
            if (file == null || !file.isFile() || !file.toString().endsWith(".jar")) continue;
            object2 = new JarFile(file);
            Enumeration<JarEntry> enumeration = ((JarFile)object2).entries();
            while (enumeration.hasMoreElements()) {
                String string;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry == null || !(string = jarEntry.getName()).endsWith(".class")) continue;
                hashSet2.add(string);
            }
        }
        object = new TreeSet();
        for (String string : hashSet2) {
            object.add(string.replace('/', '.').substring(0, string.length() - 6));
        }
        return object.toArray(new String[object.size()]);
    }

    private static Set getClassFiles(String string, Set set, File file, int[] nArray) {
        int n = nArray[0];
        nArray[0] = n - 1;
        if (n < 0) {
            return set;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            String string2 = fileArray[i].getAbsolutePath();
            if (!string2.startsWith(string)) continue;
            if (fileArray[i].isDirectory()) {
                ClassNameCompletor.getClassFiles(string, set, fileArray[i], nArray);
                continue;
            }
            if (!fileArray[i].getName().endsWith(".class")) continue;
            set.add(fileArray[i].getAbsolutePath().substring(string.length() + 1));
        }
        return set;
    }
}

