/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.StringTokenizer;
import jline.Terminal;

public class UnixTerminal
extends Terminal {
    public static final short ARROW_START = 27;
    public static final short ARROW_PREFIX = 91;
    public static final short ARROW_LEFT = 68;
    public static final short ARROW_RIGHT = 67;
    public static final short ARROW_UP = 65;
    public static final short ARROW_DOWN = 66;
    public static final short O_PREFIX = 79;
    public static final short HOME_CODE = 72;
    public static final short END_CODE = 70;
    public static final short DEL_THIRD = 51;
    public static final short DEL_SECOND = 126;
    private boolean echoEnabled;
    private String ttyConfig;
    private String ttyProps;
    private long ttyPropsLastFetched;
    private boolean backspaceDeleteSwitched = false;
    private static String sttyCommand = System.getProperty("jline.sttyCommand", "stty");
    String encoding = System.getProperty("input.encoding", "UTF-8");
    ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(this.encoding);
    InputStreamReader replayReader;

    public UnixTerminal() {
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void checkBackspace() {
        String[] stringArray = this.ttyConfig.split(":|=");
        this.backspaceDeleteSwitched = stringArray.length >= 7 && "7f".equals(stringArray[6]);
    }

    @Override
    public void initializeTerminal() throws IOException, InterruptedException {
        this.ttyConfig = UnixTerminal.stty("-g");
        if (this.ttyConfig.length() == 0 || this.ttyConfig.indexOf("=") == -1 && this.ttyConfig.indexOf(":") == -1) {
            throw new IOException("Unrecognized stty code: " + this.ttyConfig);
        }
        this.checkBackspace();
        UnixTerminal.stty("-icanon min 1");
        UnixTerminal.stty("-echo");
        this.echoEnabled = false;
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void start() {
                    try {
                        UnixTerminal.this.restoreTerminal();
                    }
                    catch (Exception exception) {
                        UnixTerminal.this.consumeException(exception);
                    }
                }
            });
        }
        catch (AbstractMethodError abstractMethodError) {
            this.consumeException(abstractMethodError);
        }
    }

    public void restoreTerminal() throws Exception {
        if (this.ttyConfig != null) {
            UnixTerminal.stty(this.ttyConfig);
            this.ttyConfig = null;
        }
        UnixTerminal.resetTerminal();
    }

    @Override
    public int readVirtualKey(InputStream inputStream) throws IOException {
        int n = this.readCharacter(inputStream);
        if (this.backspaceDeleteSwitched) {
            if (n == 127) {
                n = 8;
            } else if (n == 8) {
                n = 127;
            }
        }
        if (n == 27 && inputStream.available() > 0) {
            while (n == 27) {
                n = this.readCharacter(inputStream);
            }
            if (n == 91 || n == 79) {
                n = this.readCharacter(inputStream);
                if (n == 65) {
                    return 16;
                }
                if (n == 66) {
                    return 14;
                }
                if (n == 68) {
                    return 2;
                }
                if (n == 67) {
                    return 6;
                }
                if (n == 72) {
                    return 1;
                }
                if (n == 70) {
                    return 5;
                }
                if (n == 51) {
                    n = this.readCharacter(inputStream);
                    return 127;
                }
            }
        }
        if (n > 128) {
            this.replayStream.setInput(n, inputStream);
            n = this.replayReader.read();
        }
        return n;
    }

    private void consumeException(Throwable throwable) {
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public boolean getEcho() {
        return false;
    }

    @Override
    public int getTerminalWidth() {
        int n = -1;
        try {
            n = this.getTerminalProperty("columns");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == -1) {
            n = 80;
        }
        return n;
    }

    @Override
    public int getTerminalHeight() {
        int n = -1;
        try {
            n = this.getTerminalProperty("rows");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == -1) {
            n = 24;
        }
        return n;
    }

    private int getTerminalProperty(String string) throws IOException, InterruptedException {
        if (this.ttyProps == null || System.currentTimeMillis() - this.ttyPropsLastFetched > 1000L) {
            this.ttyProps = UnixTerminal.stty("-a");
            this.ttyPropsLastFetched = System.currentTimeMillis();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.ttyProps, ";\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.startsWith(string)) {
                int n = string2.lastIndexOf(" ");
                return Integer.parseInt(string2.substring(n).trim());
            }
            if (!string2.endsWith(string)) continue;
            int n = string2.indexOf(" ");
            return Integer.parseInt(string2.substring(0, n).trim());
        }
        return -1;
    }

    protected static String stty(String string) throws IOException, InterruptedException {
        return UnixTerminal.exec("stty " + string + " < /dev/tty").trim();
    }

    private static String exec(String string) throws IOException, InterruptedException {
        return UnixTerminal.exec(new String[]{"sh", "-c", string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String exec(String[] stringArray) throws IOException, InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Process process = Runtime.getRuntime().exec(stringArray);
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = process.getInputStream();
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream2 = process.getErrorStream();
            while ((n = inputStream2.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            outputStream = process.getOutputStream();
            process.waitFor();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            try {
                inputStream2.close();
            }
            catch (Exception exception) {}
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        String string = new String(byteArrayOutputStream.toByteArray());
        return string;
    }

    public static void setSttyCommand(String string) {
        sttyCommand = string;
    }

    public static String getSttyCommand() {
        return sttyCommand;
    }

    @Override
    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    @Override
    public synchronized void enableEcho() {
        try {
            UnixTerminal.stty("echo");
            this.echoEnabled = true;
        }
        catch (Exception exception) {
            this.consumeException(exception);
        }
    }

    @Override
    public synchronized void disableEcho() {
        try {
            UnixTerminal.stty("-echo");
            this.echoEnabled = false;
        }
        catch (Exception exception) {
            this.consumeException(exception);
        }
    }

    static class ReplayPrefixOneCharInputStream
    extends InputStream {
        byte firstByte;
        int byteLength;
        InputStream wrappedStream;
        int byteRead;
        final String encoding;

        public ReplayPrefixOneCharInputStream(String string) {
            this.encoding = string;
        }

        public void setInput(int n, InputStream inputStream) throws IOException {
            this.byteRead = 0;
            this.firstByte = (byte)n;
            this.wrappedStream = inputStream;
            this.byteLength = 1;
            if (this.encoding.equalsIgnoreCase("UTF-8")) {
                this.setInputUTF8(n, inputStream);
            } else if (this.encoding.equalsIgnoreCase("UTF-16")) {
                this.byteLength = 2;
            } else if (this.encoding.equalsIgnoreCase("UTF-32")) {
                this.byteLength = 4;
            }
        }

        public void setInputUTF8(int n, InputStream inputStream) throws IOException {
            if ((this.firstByte & 0xFFFFFFE0) == -64) {
                this.byteLength = 2;
            } else if ((this.firstByte & 0xFFFFFFF0) == -32) {
                this.byteLength = 3;
            } else if ((this.firstByte & 0xFFFFFFF8) == -16) {
                this.byteLength = 4;
            } else {
                throw new IOException("invalid UTF-8 first byte: " + this.firstByte);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            ++this.byteRead;
            if (this.byteRead == 1) {
                return this.firstByte;
            }
            return this.wrappedStream.read();
        }

        @Override
        public int available() {
            return this.byteLength - this.byteRead;
        }
    }
}

