/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.Arrays;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.contextanalysis.EUCJPContextAnalysis;
import org.mozilla.universalchardet.prober.distributionanalysis.EUCJPDistributionAnalysis;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.EUCJPSMModel;
import org.mozilla.universalchardet.prober.statemachine.SMModel;

public class EUCJPProber
extends CharsetProber {
    private CodingStateMachine codingSM = new CodingStateMachine(smModel);
    private CharsetProber.ProbingState state;
    private EUCJPContextAnalysis contextAnalyzer = new EUCJPContextAnalysis();
    private EUCJPDistributionAnalysis distributionAnalyzer = new EUCJPDistributionAnalysis();
    private byte[] lastChar = new byte[2];
    private static final SMModel smModel = new EUCJPSMModel();

    public EUCJPProber() {
        this.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_EUC_JP;
    }

    @Override
    public float getConfidence() {
        float f = this.contextAnalyzer.getConfidence();
        float f2 = this.distributionAnalyzer.getConfidence();
        return Math.max(f, f2);
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            int n4 = this.codingSM.nextState(byArray[i]);
            if (n4 == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (n4 == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (n4 != 0) continue;
            int n5 = this.codingSM.getCurrentCharLen();
            if (i == n) {
                this.lastChar[1] = byArray[n];
                this.contextAnalyzer.handleOneChar(this.lastChar, 0, n5);
                this.distributionAnalyzer.handleOneChar(this.lastChar, 0, n5);
                continue;
            }
            this.contextAnalyzer.handleOneChar(byArray, i - 1, n5);
            this.distributionAnalyzer.handleOneChar(byArray, i - 1, n5);
        }
        this.lastChar[0] = byArray[n3 - 1];
        if (this.state == CharsetProber.ProbingState.DETECTING && this.contextAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    @Override
    public void reset() {
        this.codingSM.reset();
        this.state = CharsetProber.ProbingState.DETECTING;
        this.contextAnalyzer.reset();
        this.distributionAnalyzer.reset();
        Arrays.fill(this.lastChar, (byte)0);
    }

    @Override
    public void setOption() {
    }
}

