/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.sql.SQLException;
import workbench.console.WbConsoleFactory;
import workbench.interfaces.ExecutionController;
import workbench.interfaces.ParameterPrompter;
import workbench.interfaces.StatementParameterPrompter;
import workbench.resource.ResourceMgr;
import workbench.sql.VariablePool;
import workbench.sql.preparedstatement.StatementParameters;
import workbench.storage.DataStore;
import workbench.util.HtmlUtil;
import workbench.util.SqlParsingUtil;
import workbench.util.StringUtil;

public class ConsolePrompter
implements ParameterPrompter,
ExecutionController,
StatementParameterPrompter {
    private boolean executeAll = false;

    public void resetExecuteAll() {
        this.executeAll = false;
    }

    @Override
    public boolean processParameterPrompts(String string) {
        String string2 = SqlParsingUtil.getInstance(null).getSqlVerb(string);
        if (string2.equalsIgnoreCase("WbVarDef")) {
            return true;
        }
        VariablePool variablePool = VariablePool.getInstance();
        DataStore dataStore = variablePool.getParametersToBePrompted(string);
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return true;
        }
        System.out.println(ResourceMgr.getString("TxtVariableInputText"));
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string3 = dataStore.getValueAsString(i, 0);
            String string4 = dataStore.getValueAsString(i, 1);
            String string5 = StringUtil.isBlank(string4) ? string3 + ": " : string3 + " [" + string4 + "]: ";
            String string6 = this.getInput(string5);
            if (StringUtil.isEmptyString(string6) && StringUtil.isNonEmpty(string4)) {
                string6 = string4;
            }
            dataStore.setValue(i, 1, (Object)string6);
        }
        try {
            dataStore.updateDb(null, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public String getInput(String string) {
        return WbConsoleFactory.getConsole().readLine(string);
    }

    @Override
    public String getPassword(String string, String string2) {
        return WbConsoleFactory.getConsole().readPassword(string2 + " ");
    }

    @Override
    public boolean confirmExecution(String string, String string2, String string3) {
        String string4 = string2 == null ? ResourceMgr.getString("MsgConfirmYes") : string2;
        String string5 = string3 == null ? ResourceMgr.getString("MsgConfirmNo") : string3;
        String string6 = string4 + "/" + string5;
        String string7 = HtmlUtil.cleanHTML(string) + " (" + string6 + ")";
        String string8 = this.getInput(string7 + " ");
        if (StringUtil.isBlank(string8)) {
            return false;
        }
        string8 = string8.trim().toLowerCase();
        return string4.toLowerCase().startsWith(string8) || "yes".equalsIgnoreCase(string8);
    }

    @Override
    public boolean confirmStatementExecution(String string) {
        String string2;
        String string3;
        String string4;
        if (this.executeAll) {
            return true;
        }
        String string5 = SqlParsingUtil.getInstance(null).getSqlVerb(string);
        String string6 = ResourceMgr.getString("MsgConfirmYes");
        String string7 = ResourceMgr.getString("MsgConfirmConsoleAll");
        if (string7.equalsIgnoreCase(string4 = this.getInput((string3 = ResourceMgr.getFormattedString("MsgConfirmConsoleExec", string5, string2 = string6 + "/" + ResourceMgr.getString("MsgConfirmNo") + "/" + string7)) + " "))) {
            this.executeAll = true;
            return true;
        }
        return string6.equalsIgnoreCase(string4) || "yes".equalsIgnoreCase(string4);
    }

    @Override
    public boolean showParameterDialog(StatementParameters statementParameters, boolean bl) {
        System.out.println(ResourceMgr.getString("TxtVariableInputText"));
        for (int i = 0; i < statementParameters.getParameterCount(); ++i) {
            String string = statementParameters.getParameterName(i);
            Object object = statementParameters.getParameterValue(i);
            String string2 = object == null ? "" : object.toString();
            String string3 = StringUtil.isBlank(string2) ? string : string + " [" + string2 + "]";
            String string4 = this.getInput(string3 + ": ");
            statementParameters.setParameterValue(i, string4);
        }
        return true;
    }
}

