/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.misc.Signal;
import sun.misc.SignalHandler;
import workbench.AppArguments;
import workbench.RunMode;
import workbench.WbManager;
import workbench.console.ConsolePrompter;
import workbench.console.ConsoleRefresh;
import workbench.console.ConsoleSettings;
import workbench.console.HandlerState;
import workbench.console.InputBuffer;
import workbench.console.ResultSetPrinter;
import workbench.console.RowDisplay;
import workbench.console.WbConsole;
import workbench.console.WbConsoleFactory;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.gui.WindowTitleBuilder;
import workbench.gui.profiles.ProfileKey;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.BatchRunner;
import workbench.sql.CommandRegistry;
import workbench.sql.OutputPrinter;
import workbench.sql.StatementHistory;
import workbench.sql.macros.MacroManager;
import workbench.sql.wbcommands.CommandTester;
import workbench.sql.wbcommands.WbHistory;
import workbench.util.ExceptionUtil;
import workbench.util.PlatformHelper;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.WbThread;

public class SQLConsole
implements OutputPrinter,
Runnable,
SignalHandler {
    private static final String HISTORY_FILENAME = "sqlworkbench_history.txt";
    private final ConsolePrompter prompter;
    private static final String DEFAULT_PROMPT = "SQL> ";
    private static final String CONTINUE_PROMPT = "..> ";
    private static final String PROMPT_END = "> ";
    private final WbThread shutdownHook = new WbThread(this, "ShutdownHook");
    private final Map<String, String> abbreviations = new HashMap<String, String>();
    private final StatementHistory history;
    private BatchRunner runner;
    private WbThread cancelThread;
    private ConsoleRefresh refreshHandler = new ConsoleRefresh();
    private final boolean changeTerminalTitle;
    private final String titlePrefix = "\u001b]0;";
    private final String titleSuffix = "\u0007";
    private WindowTitleBuilder titleBuilder = new WindowTitleBuilder();

    public SQLConsole() {
        this.prompter = new ConsolePrompter();
        this.history = new StatementHistory(Settings.getInstance().getConsoleHistorySize());
        this.history.doAppend(true);
        this.installSignalHandler();
        this.changeTerminalTitle = !PlatformHelper.isWindows() && ConsoleSettings.changeTerminalTitle();
        this.titleBuilder.setShowWorkspace(false);
        this.titleBuilder.setShowProductNameAtEnd(ConsoleSettings.termTitleAppNameAtEnd());
        this.titleBuilder.setShowProfileGroup(false);
        this.titleBuilder.setShowURL(ConsoleSettings.termTitleIncludeUrl());
        this.titleBuilder.setShowNotConnected(false);
        CommandRegistry.getInstance().scanForExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConsole() {
        AppArguments appArguments = WbManager.getInstance().getCommandLine();
        if (appArguments.isArgPresent("help")) {
            System.out.println(appArguments.getHelp());
            WbManager.getInstance().doShutdown(0);
        }
        boolean bl = appArguments.getBoolean("optimizeColWidth", true);
        this.runner = this.initBatchRunner(appArguments, bl);
        String string = DEFAULT_PROMPT;
        try {
            this.showStartupMessage(appArguments);
            string = this.connectRunner(this.runner, string);
            ResultSetPrinter resultSetPrinter = this.createPrinter(appArguments, bl);
            this.runner.setResultSetConsumer(resultSetPrinter);
            this.loadHistory();
            this.initAbbreviations();
            String string2 = null;
            boolean bl2 = true;
            InputBuffer inputBuffer = new InputBuffer();
            inputBuffer.setConnection(this.runner == null ? null : this.runner.getConnection());
            while (true) {
                String string3;
                if ((string3 = WbConsoleFactory.getConsole().readLine(string)) == null || inputBuffer.getLength() == 0 && StringUtil.isEmptyString(string3)) {
                    continue;
                }
                boolean bl3 = inputBuffer.addLine(string3);
                String string4 = inputBuffer.getScript().trim();
                if (bl2) {
                    if ("exit".equalsIgnoreCase(string4)) break;
                    if ("\\q".equals(string4)) {
                        break;
                    }
                }
                String string5 = this.getFirstWord(string3);
                String string6 = this.getMacroText(string4);
                if (StringUtil.isNonEmpty(string6)) {
                    bl3 = true;
                    string4 = string6;
                } else if (bl2 && this.abbreviations.containsKey(string5)) {
                    string4 = this.replaceShortcuts(string4);
                    bl3 = true;
                }
                boolean bl4 = false;
                boolean bl5 = true;
                WbFile wbFile = this.getHistoryFile();
                if (bl3) {
                    string4 = this.replaceShortcuts(string4);
                    String string7 = this.getFirstWord(string4);
                    try {
                        this.runner.setMaxColumnDisplayLength(ConsoleSettings.getMaxColumnDataWidth());
                        this.prompter.resetExecuteAll();
                        if (string7.equalsIgnoreCase("WbHistory")) {
                            string4 = this.handleHistory(this.runner, string4);
                            string7 = this.getFirstWord(string4);
                            bl5 = false;
                        } else if (string7.equalsIgnoreCase("WbRefresh")) {
                            bl5 = false;
                        }
                        if (StringUtil.isNonEmpty(string4)) {
                            if (bl5) {
                                this.history.add(string4);
                            }
                            boolean bl6 = bl4 = string7.equalsIgnoreCase("WbConnect") && ConsoleSettings.useHistoryPerProfile();
                            if (bl4) {
                                this.saveHistory();
                            }
                            this.setTerminalTitle(this.runner.getConnection(), true);
                            HandlerState handlerState = this.refreshHandler.handleRefresh(this.runner, string4, this.history);
                            if (handlerState == HandlerState.notHandled) {
                                this.runner.runScript(string4);
                                if (ConsoleSettings.showScriptFinishTime()) {
                                    this.printMessage("(" + StringUtil.getCurrentTimestamp() + ")");
                                }
                            }
                        }
                        inputBuffer.clear();
                        string = this.checkConnection(this.runner, string2 == null ? string : string2);
                        string2 = null;
                        bl2 = true;
                    }
                    catch (Throwable throwable) {
                        try {
                            System.err.println(ExceptionUtil.getDisplay(throwable));
                            LogMgr.logError(new CallerInfo(){}, "Error running statement", throwable);
                            inputBuffer.clear();
                            string = this.checkConnection(this.runner, string2 == null ? string : string2);
                            string2 = null;
                            bl2 = true;
                        }
                        catch (Throwable throwable2) {
                            inputBuffer.clear();
                            string = this.checkConnection(this.runner, string2 == null ? string : string2);
                            string2 = null;
                            bl2 = true;
                            throw throwable2;
                        }
                    }
                    inputBuffer.setConnection(this.runner.getConnection());
                    if (bl4 && !wbFile.equals(this.getHistoryFile())) {
                        this.loadHistory();
                    }
                    if (resultSetPrinter == null || this.runner.getResultSetConsumer() != null) continue;
                    this.runner.setResultSetConsumer(resultSetPrinter);
                    continue;
                }
                bl2 = false;
                if (string2 == null) {
                    string2 = string;
                }
                string = CONTINUE_PROMPT;
            }
        }
        catch (Throwable throwable) {
            System.err.println(ExceptionUtil.getDisplay(throwable));
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.saveHistory();
            if (Settings.getInstance().isModified()) {
                Settings.getInstance().saveSettings(false);
            }
            WbConsoleFactory.getConsole().shutdown();
            ConnectionMgr.getInstance().disconnectAll();
        }
        try {
            WbManager.getInstance().doShutdown(0);
        }
        catch (Throwable throwable) {
            System.err.println(ExceptionUtil.getDisplay(throwable));
            System.exit(1);
        }
    }

    private String replaceShortcuts(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        string = string.trim();
        for (Map.Entry<String, String> entry : this.abbreviations.entrySet()) {
            if (!string.startsWith(entry.getKey())) continue;
            return entry.getValue() + string.substring(entry.getKey().length());
        }
        return string;
    }

    private ResultSetPrinter createPrinter(AppArguments appArguments, boolean bl) throws SQLException {
        boolean bl2 = appArguments.getBoolean("bufferResults", true);
        ResultSetPrinter resultSetPrinter = null;
        if (!bl2) {
            resultSetPrinter = new ResultSetPrinter(System.out);
            resultSetPrinter.setFormatColumns(bl);
            resultSetPrinter.setPrintRowCount(true);
            ConsoleSettings.getInstance().addChangeListener(resultSetPrinter);
        }
        return resultSetPrinter;
    }

    private void showStartupMessage(AppArguments appArguments) {
        Object object;
        LogMgr.logInfo(new CallerInfo(){}, "SQL Workbench/J Console interface started");
        System.out.println(ResourceMgr.getFormattedString("MsgConsoleStarted", ResourceMgr.getBuildNumber().toString()));
        WbFile wbFile = new WbFile(Settings.getInstance().getConfigDir());
        System.out.println(ResourceMgr.getFormattedString("MsgConfigDir", wbFile.getFullPath()));
        System.out.println("");
        String string = appArguments.getValue("profile");
        String string2 = appArguments.getValue("profilegroup");
        if (StringUtil.isNonBlank(string)) {
            object = new ProfileKey(StringUtil.trimQuotes(string), StringUtil.trimQuotes(string2));
            ConnectionProfile connectionProfile = ConnectionMgr.getInstance().getProfile((ProfileKey)object);
            if (connectionProfile == null) {
                String string3 = ResourceMgr.getFormattedString("ErrProfileNotFound", object);
                System.err.println();
                System.err.println(string3);
            }
        }
        if (appArguments.hasUnknownArguments()) {
            object = new StringBuilder(ResourceMgr.getString("ErrUnknownParameter"));
            ((StringBuilder)object).append(' ');
            ((StringBuilder)object).append(appArguments.getUnknownArguments());
            System.err.println(((StringBuilder)object).toString());
            System.err.println();
        }
    }

    private String connectRunner(BatchRunner batchRunner, String string) {
        if (batchRunner.hasProfile()) {
            try {
                batchRunner.connect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (batchRunner.isConnected() && !batchRunner.getVerboseLogging()) {
                WbConnection wbConnection = batchRunner.getConnection();
                System.out.println(ResourceMgr.getFormattedString("MsgBatchConnectOk", wbConnection.getDisplayString()));
                String string2 = wbConnection.getWarnings();
                if (StringUtil.isNonBlank(string2)) {
                    System.out.println(string2);
                }
            }
            string = this.checkConnection(batchRunner, null);
        }
        return string;
    }

    private BatchRunner initBatchRunner(AppArguments appArguments, boolean bl) {
        BatchRunner batchRunner = BatchRunner.createBatchRunner(appArguments, false);
        batchRunner.showResultSets(true);
        batchRunner.setMaxColumnDisplayLength(ConsoleSettings.getMaxColumnDataWidth());
        batchRunner.setShowStatementWithResult(false);
        batchRunner.setShowStatementSummary(false);
        batchRunner.setOptimizeColWidths(bl);
        batchRunner.setShowDataLoading(false);
        batchRunner.setConnectionId("Console");
        batchRunner.setTraceOutput(this);
        int n = Settings.getInstance().getIntProperty("workbench.console.default.maxrows", 5000);
        batchRunner.setMaxRows(n);
        if (appArguments.isArgNotPresent("showProgress")) {
            batchRunner.setShowProgress(true);
        }
        WbFile wbFile = new WbFile(System.getProperty("user.dir"));
        batchRunner.setBaseDir(wbFile.getFullPath());
        boolean bl2 = appArguments.getBoolean("showTiming", false);
        batchRunner.setShowTiming(bl2);
        batchRunner.setShowStatementTiming(!bl2);
        batchRunner.setHistoryProvider(this.history);
        batchRunner.setPersistentConnect(true);
        batchRunner.setExecutionController(this.prompter);
        batchRunner.setParameterPrompter(this.prompter);
        batchRunner.setShowRowCounts(true);
        batchRunner.setShowProgress(false);
        return batchRunner;
    }

    private void initAbbreviations() {
        CommandTester commandTester = new CommandTester();
        String string = commandTester.formatVerb("WbHistory") + " last";
        this.abbreviations.put("\\x", commandTester.formatVerb("WbToggleDisplay"));
        this.abbreviations.put("\\?", commandTester.formatVerb("WbHelp"));
        this.abbreviations.put("\\h", commandTester.formatVerb("WbHelp"));
        this.abbreviations.put("\\i", commandTester.formatVerb("WbRun"));
        this.abbreviations.put("\\d", commandTester.formatVerb("WbList"));
        this.abbreviations.put("\\g", string);
        this.abbreviations.put("\\s", commandTester.formatVerb("WbHistory"));
        this.abbreviations.put("\\!", commandTester.formatVerb("WbSysExec"));
        this.abbreviations.put("\\dt", commandTester.formatVerb("WbDescribe"));
        this.abbreviations.put("\\ds", commandTester.formatVerb("WbList") + " -types=sequence");
        this.abbreviations.put("\\sf", commandTester.formatVerb("WbProcSource"));
        this.abbreviations.put("\\l", commandTester.formatVerb("WbListDB"));
        this.abbreviations.put("\\df", commandTester.formatVerb("WbListProcs"));
        this.abbreviations.put("\\dn", commandTester.formatVerb("WbListSchemas"));
        this.abbreviations.put("\\conninfo", commandTester.formatVerb("WbConnInfo"));
        this.abbreviations.put("\\connect", commandTester.formatVerb("WbConnect"));
        this.abbreviations.put("\\c", commandTester.formatVerb("WbConnect"));
        this.abbreviations.put("\\watch", "WbRefresh");
        this.abbreviations.put("/", string);
    }

    @Override
    public void printMessage(String string) {
        System.out.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleHistory(BatchRunner batchRunner, String string) throws IOException {
        this.adjustHistoryDisplay(batchRunner);
        String string2 = SqlUtil.stripVerb(SqlUtil.makeCleanSql(string, false, false));
        int n = -1;
        if (StringUtil.isBlank(string2)) {
            RowDisplay rowDisplay = ConsoleSettings.getInstance().getRowDisplay();
            try {
                ConsoleSettings.getInstance().setRowDisplay(RowDisplay.SingleLine);
                batchRunner.runScript(string);
                System.out.println("");
                String string3 = WbConsoleFactory.getConsole().readLineWithoutHistory(">>> " + ResourceMgr.getString("TxtEnterStmtIndex") + " >>> ");
                n = StringUtil.getIntValue(string3, -1);
            }
            finally {
                ConsoleSettings.getInstance().setRowDisplay(rowDisplay);
            }
        } else {
            n = string2.equalsIgnoreCase("last") ? this.history.size() : StringUtil.getIntValue(string2, -1);
        }
        if (n > 0 && n <= this.history.size()) {
            return (String)this.history.get(n - 1);
        }
        return null;
    }

    private String getMacroText(String string) {
        return MacroManager.getInstance().getMacroText(Integer.MIN_VALUE, SqlUtil.trimSemicolon(string));
    }

    private void saveHistory() {
        this.history.saveTo(this.getHistoryFile());
    }

    private void loadHistory() {
        this.history.clear();
        WbFile wbFile = this.getHistoryFile();
        LogMgr.logDebug(new CallerInfo(){}, "Loading history file: " + wbFile.getFullPath());
        this.history.readFrom(wbFile);
        WbConsole wbConsole = WbConsoleFactory.getConsole();
        wbConsole.clearHistory();
        wbConsole.addToHistory(this.history.getHistoryEntries());
    }

    private WbFile getHistoryFile() {
        String string = null;
        if (ConsoleSettings.useHistoryPerProfile() && this.runner != null && this.runner.getConnection() != null) {
            string = this.runner.getConnection().createFilename() + "_history.txt";
        }
        if (string == null) {
            string = Settings.getInstance().getProperty("workbench.console.history.file", HISTORY_FILENAME);
        }
        WbFile wbFile = new WbFile(Settings.getInstance().getConfigDir(), string);
        return wbFile;
    }

    private void adjustHistoryDisplay(BatchRunner batchRunner) {
        int n = WbConsoleFactory.getConsole().getColumns();
        LogMgr.logDebug(new CallerInfo(){}, "Console width: " + n);
        if (n < 0) {
            n = Settings.getInstance().getIntProperty("workbench.console.history.displaylength", 100);
        }
        WbHistory wbHistory = (WbHistory)batchRunner.getCommand("WbHistory");
        wbHistory.setMaxDisplayLength(n);
    }

    private String getFirstWord(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        int n = StringUtil.findFirstWhiteSpace(string = string.trim());
        if (n <= 0) {
            return SqlUtil.trimSemicolon(string);
        }
        return SqlUtil.trimSemicolon(string.substring(0, n));
    }

    private String appendSuffix(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith(PROMPT_END)) {
            return string;
        }
        return string + PROMPT_END;
    }

    private String checkConnection(BatchRunner batchRunner, String string) {
        String string2 = string;
        WbConnection wbConnection = batchRunner.getConnection();
        if (wbConnection != null && ConsoleSettings.showProfileInPrompt()) {
            string2 = wbConnection.getProfile().getName();
        } else if (wbConnection != null && !batchRunner.hasPendingActions()) {
            String string3;
            String string4 = wbConnection.getCurrentUser();
            String string5 = wbConnection.getDisplayCatalog();
            if (string5 == null) {
                string5 = wbConnection.getCurrentCatalog();
            }
            if ((string3 = wbConnection.getDisplaySchema()) == null) {
                wbConnection.getCurrentSchema();
            }
            if (StringUtil.isBlank(string5) && StringUtil.isNonBlank(string3)) {
                string2 = string3.equalsIgnoreCase(string4) ? string4 : string4 + "@" + string3;
            } else if (StringUtil.isNonBlank(string5) && StringUtil.isBlank(string3)) {
                string2 = string4 + "@" + string5;
            } else if (StringUtil.isNonBlank(string5) && StringUtil.isNonBlank(string3)) {
                string2 = string4 + "@" + string5 + "/" + string3;
            }
        }
        this.setTerminalTitle(wbConnection, false);
        return string2 == null ? DEFAULT_PROMPT : this.appendSuffix(string2);
    }

    private void setTerminalTitle(WbConnection wbConnection, boolean bl) {
        if (!this.changeTerminalTitle) {
            return;
        }
        String string = bl ? PROMPT_END : "";
        String string2 = "\u001b]0;" + string + this.titleBuilder.getWindowTitle(wbConnection) + "\u0007";
        System.out.println(string2);
    }

    public static void main(String[] stringArray) {
        AppArguments appArguments = new AppArguments();
        appArguments.parse(stringArray);
        if (appArguments.isArgPresent("script") || appArguments.isArgPresent("command")) {
            WbManager.main(stringArray);
        } else {
            WbManager.initConsoleMode();
            WbManager.getInstance().readParameters(stringArray, RunMode.Console);
            SQLConsole.runConsole();
        }
    }

    public static void runConsole() {
        SQLConsole sQLConsole = new SQLConsole();
        sQLConsole.setTerminalTitle(null, false);
        sQLConsole.startConsole();
    }

    public void abortStatement() {
        if (this.cancelThread != null) {
            try {
                LogMgr.logInfo(new CallerInfo(){}, "Trying to forcefully abort current statement");
                this.printMessage(ResourceMgr.getString("MsgAbortStmt"));
                this.cancelThread.interrupt();
                this.cancelThread.stop();
                if (this.runner != null) {
                    this.runner.abort();
                }
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not cancel statement", exception);
            }
            finally {
                this.cancelThread = null;
            }
        }
    }

    public void cancelStatement() {
        if (this.cancelThread != null) {
            this.abortStatement();
        } else if (this.runner != null && this.runner.isBusy() && this.cancelThread == null) {
            this.cancelThread = new WbThread("ConsoleStatementCancel"){

                @Override
                public void run() {
                    LogMgr.logInfo(new CallerInfo(){}, "Trying to cancel the current statement");
                    SQLConsole.this.printMessage(ResourceMgr.getString("MsgCancellingStmt"));
                    SQLConsole.this.runner.cancel();
                }
            };
            try {
                this.cancelThread.start();
                this.cancelThread.join(Settings.getInstance().getIntProperty("workbench.sql.cancel.timeout", 5000));
            }
            catch (Exception exception) {
                this.printMessage(ResourceMgr.getString("MsgAbortStmt"));
                LogMgr.logWarning(new CallerInfo(){}, "Could not cancel statement. Trying to forcefully abort the statemnt", exception);
                this.abortStatement();
            }
            this.cancelThread = null;
        }
    }

    public void exit() {
        LogMgr.logWarning(new CallerInfo(){}, "SQL Workbench/J process has been interrupted.");
        this.cancelStatement();
        boolean bl = Settings.getInstance().getBoolProperty("workbench.exitonbreak", true);
        if (bl) {
            LogMgr.logWarning(new CallerInfo(){}, "Aborting process...");
            LogMgr.shutdown();
            Runtime.getRuntime().halt(15);
        } else {
            ConnectionMgr.getInstance().abortAll(Collections.singletonList(this.runner.getConnection()));
            LogMgr.shutdown();
        }
    }

    @Override
    public void run() {
        this.exit();
    }

    private void installSignalHandler() {
        List<String> list = Settings.getInstance().getListProperty("workbench.console.signal", false, "INT,QUIT");
        for (String string : list) {
            try {
                Signal signal = new Signal(string.toUpperCase());
                Signal.handle(signal, this);
                LogMgr.logInfo(new CallerInfo(){}, "Installed signal handler for " + string);
            }
            catch (Throwable throwable) {
                LogMgr.logInfo(new CallerInfo(){}, "could not register signal handler for: " + string, throwable);
            }
        }
    }

    @Override
    public void handle(Signal signal) {
        LogMgr.logDebug(new CallerInfo(){}, "Received signal: " + signal.getName());
        if (signal.getName().equals("INT")) {
            this.cancelStatement();
        }
        if (signal.getName().equals("QUIT")) {
            this.exit();
        }
    }
}

