/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import workbench.console.WbConsole;

public class SystemConsole
implements WbConsole {
    @Override
    public void clearScreen() {
    }

    @Override
    public char readCharacter() {
        if (System.console() == null) {
            return '\u0000';
        }
        try {
            int n = System.console().reader().read();
            return (char)n;
        }
        catch (IOException iOException) {
            return '\u0000';
        }
    }

    @Override
    public void reset() {
        if (System.console() == null) {
            return;
        }
        try {
            System.console().reader().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String readPassword(String string) {
        if (System.console() != null) {
            char[] cArray = System.console().readPassword(string + " ", new Object[0]);
            if (cArray == null) {
                return null;
            }
            String string2 = new String(cArray);
            Arrays.fill(cArray, 'x');
            return string2;
        }
        return this.readLine(string);
    }

    @Override
    public String readLine(String string) {
        if (System.console() != null) {
            return System.console().readLine(string, new Object[0]);
        }
        System.out.print(string);
        Scanner scanner = new Scanner(System.in);
        String string2 = scanner.nextLine();
        return string2;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public int getColumns() {
        return -1;
    }

    @Override
    public String readLineWithoutHistory(String string) {
        return this.readLine(string);
    }

    @Override
    public void clearHistory() {
    }

    @Override
    public void addToHistory(List<String> list) {
    }
}

