/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.resource.Settings;
import workbench.sql.formatter.WbSqlFormatter;

public class DummySelect
implements DbObject {
    private TableIdentifier table;
    private List<ColumnIdentifier> columns;

    public DummySelect(TableIdentifier tableIdentifier) {
        this.table = tableIdentifier;
    }

    public DummySelect(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        this.table = tableIdentifier;
        this.columns = new ArrayList<ColumnIdentifier>(list);
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public void setComment(String string) {
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.getObjectExpression(wbConnection);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return null;
    }

    @Override
    public String getObjectName() {
        return null;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return null;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return null;
    }

    @Override
    public String getObjectType() {
        return "SELECT";
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        DbMetadata dbMetadata = wbConnection.getMetadata();
        String string = Settings.getInstance().getInternalEditorLineEnding();
        List<ColumnIdentifier> list = this.columns;
        if (list == null) {
            list = dbMetadata.getTableColumns(this.table, false);
        }
        if (list.isEmpty()) {
            return "";
        }
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder(n * 80);
        stringBuilder.append("SELECT ");
        for (int i = 0; i < n; ++i) {
            String string2 = list.get(i).getColumnName();
            if (i > 0) {
                stringBuilder.append(',');
                stringBuilder.append(string);
                stringBuilder.append("       ");
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append(string);
        stringBuilder.append("FROM ");
        stringBuilder.append(this.table.getTableExpression(wbConnection));
        stringBuilder.append(';');
        stringBuilder.append(string);
        WbSqlFormatter wbSqlFormatter = new WbSqlFormatter((CharSequence)stringBuilder, wbConnection.getDbId());
        try {
            return wbSqlFormatter.getFormattedSql();
        }
        catch (Exception exception) {
            return stringBuilder.toString();
        }
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

