/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.Statement;
import workbench.db.CatalogInformationReader;
import workbench.db.DbSettings;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;

public class GenericCatalogInformationReader
implements CatalogInformationReader,
PropertyChangeListener {
    private static final String NO_CATALOG = "$wb$-no-catalog";
    private final WbConnection dbConnection;
    private final DbSettings dbSettings;
    private boolean supportsGetCatalog = true;
    private boolean isCacheable = false;
    private String cachedCatalog = "$wb$-no-catalog";

    public GenericCatalogInformationReader(WbConnection wbConnection, DbSettings dbSettings) {
        this.dbConnection = wbConnection;
        this.dbSettings = dbSettings;
        this.isCacheable = this.dbSettings.getBoolProperty("currentcatalog.cacheable", false);
        if (this.isCacheable) {
            this.dbConnection.addChangeListener(this);
        }
        LogMgr.logDebug(new CallerInfo(){}, this.dbConnection.getId() + ": Cache current schema: " + this.isCacheable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentCatalog() {
        if (!this.dbSettings.supportsCatalogs()) {
            return null;
        }
        if (this.isCacheable && this.cachedCatalog != NO_CATALOG) {
            return this.cachedCatalog;
        }
        String string = null;
        String string2 = this.dbSettings.getQueryForCurrentCatalog();
        if (string2 != null) {
            ResultSet resultSet;
            Statement statement;
            block12: {
                statement = null;
                resultSet = null;
                if (Settings.getInstance().getDebugMetadataSql()) {
                    LogMgr.logDebug(new CallerInfo(){}, this.dbConnection.getId() + ": Retrieving current catalog using: " + string2);
                }
                try {
                    statement = this.dbConnection.createStatementForQuery();
                    resultSet = statement.executeQuery(string2);
                    if (!resultSet.next()) break block12;
                    string = resultSet.getString(1);
                }
                catch (Exception exception) {
                    try {
                        LogMgr.logWarning(new CallerInfo(){}, "Error retrieving current catalog using query: " + string2, exception);
                        string = null;
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeAll(resultSet, statement);
                        throw throwable;
                    }
                    JdbcUtils.closeAll(resultSet, statement);
                }
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        if (string == null && this.supportsGetCatalog) {
            try {
                string = this.dbConnection.getSqlConnection().getCatalog();
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve catalog using getCatalog()", exception);
                string = null;
                this.supportsGetCatalog = false;
            }
        }
        if (this.isCacheable) {
            this.cachedCatalog = string;
        }
        return string;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("catalog")) {
            this.clearCache();
        }
    }

    @Override
    public void clearCache() {
        this.cachedCatalog = NO_CATALOG;
    }
}

