/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.interfaces.ObjectDropper;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.ObjectUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class GenericObjectDropper
implements ObjectDropper {
    private List<? extends DbObject> objects;
    private WbConnection connection;
    private Statement currentStatement;
    private boolean cascadeConstraints;
    private TableIdentifier objectTable;
    private RowActionMonitor monitor;
    private boolean cancel;
    private boolean transactional = true;

    public void setUseTransaction(boolean bl) {
        this.transactional = bl;
    }

    @Override
    public List<? extends DbObject> getObjects() {
        return this.objects;
    }

    @Override
    public void setRowActionMonitor(RowActionMonitor rowActionMonitor) {
        this.monitor = rowActionMonitor;
    }

    @Override
    public boolean supportsFKSorting() {
        if (this.objects == null) {
            return false;
        }
        int n = this.objects.size();
        for (int i = 0; i < n; ++i) {
            DbObject dbObject = this.objects.get(i);
            if (dbObject instanceof TableIdentifier) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsCascade() {
        boolean bl = false;
        if (this.objects != null && this.connection != null) {
            int n = this.objects.size();
            for (int i = 0; i < n; ++i) {
                String string = this.objects.get(i).getObjectType();
                String string2 = this.connection.getDbSettings().getCascadeConstraintsVerb(string);
                if (!StringUtil.isNonBlank(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public void setObjects(List<? extends DbObject> list) {
        this.objects = list == null ? null : new ArrayList<DbObject>(list);
    }

    @Override
    public void setObjectTable(TableIdentifier tableIdentifier) {
        this.objectTable = tableIdentifier;
    }

    @Override
    public WbConnection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    @Override
    public CharSequence getScript() {
        if (this.connection == null) {
            throw new NullPointerException("No connection!");
        }
        if (this.objects == null || this.objects.isEmpty()) {
            return null;
        }
        boolean bl = this.transactional && this.connection.generateCommitForDDL();
        int n = this.objects.size();
        StringBuffer stringBuffer = new StringBuffer(n * 40);
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence = this.getDropStatement(i);
            stringBuffer.append(charSequence);
            stringBuffer.append("\n\n");
        }
        if (bl) {
            stringBuffer.append("COMMIT;\n");
        }
        return stringBuffer;
    }

    private CharSequence getDropStatement(int n) {
        DbObject dbObject = this.objects.get(n);
        return this.getDropForObject(dbObject, this.cascadeConstraints);
    }

    @Override
    public CharSequence getDropForObject(DbObject dbObject) {
        return this.getDropForObject(dbObject, this.cascadeConstraints);
    }

    @Override
    public CharSequence getDropForObject(DbObject dbObject, boolean bl) {
        String string = dbObject.getDropStatement(this.connection, bl);
        if (string != null) {
            return string;
        }
        String string2 = dbObject.getObjectType();
        StringBuilder stringBuilder = new StringBuilder(120);
        String string3 = this.connection.getDbSettings().getDropDDL(string2, bl);
        DbObject dbObject2 = ObjectUtil.coalesce(this.objectTable, dbObject.getOwnerObject());
        if ((string3 = TemplateHandler.replaceTablePlaceholder(string3, dbObject2, this.connection, true)).contains("%name%")) {
            string3 = string3.replace("%name%", dbObject.getObjectNameForDrop(this.connection));
        }
        if (string3.contains("%fq_name%")) {
            string3 = string3.replace("%fq_name%", dbObject.getFullyQualifiedName(this.connection));
        }
        string3 = TemplateHandler.replaceTablePlaceholder(string3, dbObject, this.connection, true);
        stringBuilder.append(string3);
        if (!StringUtil.endsWith((CharSequence)stringBuilder, ';')) {
            stringBuilder.append(';');
        }
        return stringBuilder;
    }

    @Override
    public void dropObjects() throws SQLException {
        if (this.connection == null) {
            throw new NullPointerException("No connection!");
        }
        if (this.objects == null || this.objects.isEmpty()) {
            return;
        }
        this.cancel = false;
        try {
            int n = this.objects.size();
            this.currentStatement = this.connection.createStatement();
            for (int i = 0; i < n; ++i) {
                DbObject dbObject = this.objects.get(i);
                String string = SqlUtil.trimSemicolon(this.getDropStatement(i).toString());
                LogMgr.logDebug(new CallerInfo(){}, "Dropping object using: " + string);
                if (this.monitor != null) {
                    String string2 = dbObject.getObjectName();
                    this.monitor.setCurrentObject(string2, i + 1, n);
                }
                this.currentStatement.execute(string);
                this.connection.getObjectCache().removeEntry(dbObject);
                if (this.cancel) break;
            }
            if (this.connection.shouldCommitDDL()) {
                this.connection.commit();
            }
        }
        catch (SQLException sQLException) {
            if (this.connection.shouldCommitDDL()) {
                this.connection.rollbackSilently();
            }
            throw sQLException;
        }
        finally {
            JdbcUtils.closeStatement(this.currentStatement);
            this.currentStatement = null;
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.currentStatement == null) {
            return;
        }
        this.cancel = true;
        try {
            this.currentStatement.cancel();
        }
        finally {
            if (this.connection.shouldCommitDDL()) {
                this.connection.rollbackSilently();
            }
        }
    }

    @Override
    public void setCascade(boolean bl) {
        if (this.supportsCascade()) {
            this.cascadeConstraints = bl;
        }
    }

    @Override
    public boolean supportsObject(DbObject dbObject) {
        return !(dbObject instanceof ColumnIdentifier);
    }
}

