/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.util.Comparator;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class IndexColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String column;
    private String direction;
    private int sequence;

    public IndexColumn(String string, int n) {
        this.column = string;
        this.sequence = n;
    }

    public IndexColumn(String string, String string2) {
        this.column = StringUtil.trim(string);
        this.direction = string2;
    }

    public void setColumn(String string) {
        this.column = StringUtil.trim(string);
    }

    public String getColumn() {
        return this.column;
    }

    public void setDirection(String string) {
        this.direction = string;
    }

    public String getDirection() {
        if (this.direction == null) {
            return null;
        }
        if (this.direction.equalsIgnoreCase("a")) {
            return "ASC";
        }
        if (this.direction.equalsIgnoreCase("d")) {
            return "DESC";
        }
        return this.direction;
    }

    public String getExpression() {
        if (StringUtil.isEmptyString(this.direction)) {
            return this.column;
        }
        return this.column + " " + this.getDirection();
    }

    public boolean equals(Object object) {
        if (object instanceof IndexColumn) {
            IndexColumn indexColumn = (IndexColumn)object;
            return SqlUtil.objectNamesAreEqual(this.column, indexColumn.column) && StringUtil.equalStringIgnoreCase(this.getDirection(), indexColumn.getDirection());
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 73 * n + (this.column != null ? this.column.hashCode() : 0);
        n = 73 * n + (this.direction != null ? this.direction.hashCode() : 0);
        return n;
    }

    public static Comparator<IndexColumn> getSequenceSorter() {
        return (indexColumn, indexColumn2) -> indexColumn.sequence - indexColumn2.sequence;
    }

    public String toString() {
        return this.column;
    }
}

