/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.DBID;
import workbench.db.DataTypeResolver;
import workbench.db.DbMetadata;
import workbench.db.DbSettings;
import workbench.db.JdbcUtils;
import workbench.db.PkDefinition;
import workbench.db.TableDefinition;
import workbench.db.TableDefinitionReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.derby.DerbyColumnEnhancer;
import workbench.db.firebird.FirebirdColumnEnhancer;
import workbench.db.h2database.H2ColumnEnhancer;
import workbench.db.hana.HanaColumnEnhancer;
import workbench.db.hsqldb.HsqlColumnEnhancer;
import workbench.db.ibm.Db2ColumnEnhancer;
import workbench.db.ibm.Db2iColumnEnhancer;
import workbench.db.ibm.InformixColumnEnhancer;
import workbench.db.mssql.SqlServerColumnEnhancer;
import workbench.db.mssql.SqlServerUtil;
import workbench.db.mysql.MySQLColumnEnhancer;
import workbench.db.nuodb.NuoDbColumnEnhancer;
import workbench.db.postgres.PostgresColumnEnhancer;
import workbench.db.progress.OpenEdgeColumnEnhancer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class JdbcTableDefinitionReader
implements TableDefinitionReader {
    protected final WbConnection dbConnection;

    public JdbcTableDefinitionReader(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ColumnIdentifier> getTableColumns(TableIdentifier tableIdentifier, DataTypeResolver dataTypeResolver) throws SQLException {
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        boolean bl = dbSettings.useColumnNameForMetadata();
        String string = SqlUtil.removeObjectQuotes(tableIdentifier.getTableName());
        String string2 = SqlUtil.removeObjectQuotes(tableIdentifier.getSchema());
        String string3 = SqlUtil.removeObjectQuotes(tableIdentifier.getCatalog());
        if (this.dbConnection.getDbSettings().supportsMetaDataWildcards()) {
            string = SqlUtil.escapeUnderscore(string, this.dbConnection);
        }
        if (this.dbConnection.getDbSettings().supportsMetaDataSchemaWildcards()) {
            string2 = SqlUtil.escapeUnderscore(string2, this.dbConnection);
        }
        if (this.dbConnection.getDbSettings().supportsMetaDataCatalogWildcards()) {
            string3 = SqlUtil.escapeUnderscore(string3, this.dbConnection);
        }
        ResultSet resultSet = null;
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        PkDefinition pkDefinition = tableIdentifier.getPrimaryKey();
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        if (pkDefinition != null) {
            for (String string4 : pkDefinition.getColumns()) {
                set.add(dbMetadata.removeQuotes(string4));
            }
        }
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            String string5;
            if (Settings.getInstance().getDebugMetadataSql()) {
                LogMgr.logDebug(callerInfo, "Calling getColumns() using: catalog=" + string3 + ", schema=" + string2 + ", table=" + string);
            }
            long l = System.currentTimeMillis();
            resultSet = this.getColumns(string3, string2, string, "%", tableIdentifier.getType());
            long l2 = System.currentTimeMillis() - l;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (Settings.getInstance().getDebugMetadataSql()) {
                LogMgr.logDebug(callerInfo, "Calling getColumns() took: " + l2 + "ms");
                String string6 = SqlUtil.fullyQualifiedName(this.dbConnection, tableIdentifier);
                SqlUtil.dumpResultSetInfo("JdbcTableDefinitionReader.getColumns() for " + string6, resultSetMetaData);
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (resultSetMetaData.getColumnCount() > 22) {
                string5 = resultSetMetaData.getColumnName(23);
                bl2 = string5.equals("IS_AUTOINCREMENT");
            }
            if (resultSetMetaData.getColumnCount() > 23) {
                string5 = resultSetMetaData.getColumnName(24);
                bl3 = string5.equals("IS_GENERATEDCOLUMN");
            }
            while (resultSet.next()) {
                string5 = StringUtil.trim(bl ? resultSet.getString("COLUMN_NAME") : resultSet.getString(4));
                int n = bl ? resultSet.getInt("DATA_TYPE") : resultSet.getInt(5);
                String string7 = StringUtil.trim(bl ? resultSet.getString("TYPE_NAME") : resultSet.getString(6));
                n = dataTypeResolver.fixColumnType(n, string7);
                ColumnIdentifier columnIdentifier = new ColumnIdentifier(dbMetadata.quoteObjectname(string5), n);
                int n2 = bl ? resultSet.getInt("COLUMN_SIZE") : resultSet.getInt(7);
                int n3 = -1;
                try {
                    n3 = bl ? resultSet.getInt("DECIMAL_DIGITS") : resultSet.getInt(9);
                }
                catch (Exception exception) {
                    n3 = -1;
                }
                if (resultSet.wasNull()) {
                    n3 = -1;
                }
                String string8 = this.getString(resultSet, "REMARKS", 12, bl);
                String string9 = this.getString(resultSet, "COLUMN_DEF", 13, bl);
                if (string9 != null && dbSettings.trimDefaults()) {
                    string9 = string9.trim();
                }
                int n4 = -1;
                try {
                    n4 = bl ? resultSet.getInt("ORDINAL_POSITION") : resultSet.getInt(17);
                }
                catch (Exception exception) {
                    LogMgr.logWarning(callerInfo, "JDBC driver does not suport ORDINAL_POSITION column for getColumns()", exception);
                    n4 = -1;
                }
                String string10 = this.getString(resultSet, "IS_NULLABLE", 18, bl);
                String string11 = "NO";
                if (bl2) {
                    string11 = bl ? resultSet.getString("IS_AUTOINCREMENT") : resultSet.getString(23);
                }
                boolean bl4 = StringUtil.stringToBool(string11);
                String string12 = dataTypeResolver.getSqlTypeDisplay(string7, n, n2, n3);
                if (this.dbConnection.getMetadata().isSqlServer() && dbSettings.fixSqlServerAutoincrement()) {
                    bl4 = string12.contains("identity");
                }
                boolean bl5 = false;
                if (bl3) {
                    String string13 = bl ? resultSet.getString("IS_GENERATEDCOLUMN") : resultSet.getString(24);
                    bl5 = StringUtil.stringToBool(string13);
                    columnIdentifier.setIsGenerated(bl5);
                }
                columnIdentifier.setDbmsType(string12);
                columnIdentifier.setIsAutoincrement(bl4);
                columnIdentifier.setIsPkColumn(set.contains(string5));
                columnIdentifier.setIsNullable("YES".equalsIgnoreCase(string10));
                columnIdentifier.setDefaultValue(string9);
                columnIdentifier.setComment(string8);
                columnIdentifier.setColumnSize(n2);
                columnIdentifier.setDecimalDigits(n3);
                columnIdentifier.setPosition(n4);
                arrayList.add(columnIdentifier);
                this.processColumnsResultRow(resultSet, columnIdentifier);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logError(callerInfo, "Could not retrieve table columns", sQLException);
                throw sQLException;
                catch (Exception exception) {
                    LogMgr.logError(callerInfo, "Could not retrieve table columns", exception);
                    throw new SQLException(exception);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResult(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.closeResult(resultSet);
        ColumnIdentifier.sortByPosition(arrayList);
        return arrayList;
    }

    protected void processColumnsResultRow(ResultSet resultSet, ColumnIdentifier columnIdentifier) throws SQLException {
    }

    protected ResultSet getColumns(String string, String string2, String string3, String string4, String string5) throws SQLException {
        return this.dbConnection.getSqlConnection().getMetaData().getColumns(string, string2, string3, string4);
    }

    private String getString(ResultSet resultSet, String string, int n, boolean bl) {
        try {
            return bl ? resultSet.getString(string) : resultSet.getString(n);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read column " + string, exception);
            return null;
        }
    }

    @Override
    public String getSchemaToUse(TableIdentifier tableIdentifier) {
        return this.dbConnection.getMetadata().getCurrentSchema();
    }

    @Override
    public String getCatalogToUse(TableIdentifier tableIdentifier) {
        return this.dbConnection.getMetadata().getCurrentCatalog();
    }

    @Override
    public TableDefinition getTableDefinition(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        Object object;
        if (tableIdentifier == null) {
            return null;
        }
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        tableIdentifier2.adjustCase(this.dbConnection);
        String string = SqlUtil.removeObjectQuotes(tableIdentifier2.getCatalog());
        String string2 = SqlUtil.removeObjectQuotes(tableIdentifier2.getSchema());
        String string3 = SqlUtil.removeObjectQuotes(tableIdentifier2.getTableName());
        if (string2 == null) {
            string2 = this.getSchemaToUse(tableIdentifier);
            tableIdentifier2.setSchema(string2);
        }
        if (string == null) {
            string = this.getCatalogToUse(tableIdentifier);
            tableIdentifier2.setCatalog(string);
        }
        TableIdentifier tableIdentifier3 = tableIdentifier2;
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        if (this.dbConnection.getDbSettings().isSynonymType(tableIdentifier2.getType())) {
            object = tableIdentifier2.getRealTable();
            if (object == null) {
                object = dbMetadata.getSynonymTable(string, string2, string3);
            }
            if (object != null) {
                string2 = ((TableIdentifier)object).getSchema();
                string3 = ((TableIdentifier)object).getTableName();
                string = null;
                tableIdentifier3 = tableIdentifier2.createCopy();
                tableIdentifier3.setSchema(string2);
                tableIdentifier3.parseTableIdentifier(string3);
                tableIdentifier3.setCatalog(null);
            }
        }
        if (bl) {
            object = dbMetadata.getIndexReader().getPrimaryKey(tableIdentifier3);
            tableIdentifier3.setPrimaryKey((PkDefinition)object);
        }
        object = this.getTableColumns(tableIdentifier3, dbMetadata.getDataTypeResolver());
        tableIdentifier3.setNewTable(false);
        TableDefinition tableDefinition = new TableDefinition(tableIdentifier3, (List<ColumnIdentifier>)object);
        ColumnDefinitionEnhancer columnDefinitionEnhancer = this.getColumnEnhancer(this.dbConnection);
        if (columnDefinitionEnhancer != null) {
            columnDefinitionEnhancer.updateColumnDefinition(tableDefinition, this.dbConnection);
        }
        return tableDefinition;
    }

    private ColumnDefinitionEnhancer getColumnEnhancer(WbConnection wbConnection) {
        if (wbConnection == null) {
            return null;
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata == null) {
            return null;
        }
        if (dbMetadata.isPostgres()) {
            return new PostgresColumnEnhancer();
        }
        if (dbMetadata.isH2()) {
            return new H2ColumnEnhancer();
        }
        if (dbMetadata.isApacheDerby()) {
            return new DerbyColumnEnhancer();
        }
        if (dbMetadata.isMySql()) {
            return new MySQLColumnEnhancer();
        }
        if (DBID.DB2_LUW.isDB(wbConnection)) {
            return new Db2ColumnEnhancer();
        }
        if (DBID.DB2_ISERIES.isDB(wbConnection)) {
            return new Db2iColumnEnhancer();
        }
        if (DBID.Informix.isDB(wbConnection)) {
            return new InformixColumnEnhancer();
        }
        if (dbMetadata.isSqlServer() && SqlServerUtil.isSqlServer2000(wbConnection)) {
            return new SqlServerColumnEnhancer();
        }
        if (dbMetadata.isFirebird()) {
            return new FirebirdColumnEnhancer();
        }
        if (wbConnection.getDbId().equals("nuodb")) {
            return new NuoDbColumnEnhancer();
        }
        if (dbMetadata.isHsql() && JdbcUtils.hasMinimumServerVersion(wbConnection, "2.0")) {
            return new HsqlColumnEnhancer();
        }
        if (DBID.OPENEDGE.isDB(wbConnection)) {
            return new OpenEdgeColumnEnhancer();
        }
        if (DBID.HANA.isDB(wbConnection)) {
            return new HanaColumnEnhancer();
        }
        return null;
    }
}

