/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.Comparator;
import workbench.db.DbObject;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ObjectNameSorter
implements Comparator<DbObject> {
    private boolean useExpression = false;
    private boolean useNaturalSort;

    public ObjectNameSorter() {
    }

    public ObjectNameSorter(boolean bl) {
        this.useExpression = bl;
    }

    public void setUseNaturalSort(boolean bl) {
        this.useNaturalSort = bl;
    }

    @Override
    public int compare(DbObject dbObject, DbObject dbObject2) {
        if (this.useExpression) {
            return StringUtil.compareStrings(this.buildCleanExpression(dbObject), this.buildCleanExpression(dbObject2), true);
        }
        if (this.useNaturalSort) {
            return StringUtil.naturalCompare(SqlUtil.removeObjectQuotes(dbObject.getObjectName()), SqlUtil.removeObjectQuotes(dbObject2.getObjectName()), true);
        }
        return StringUtil.compareStrings(SqlUtil.removeObjectQuotes(dbObject.getObjectName()), SqlUtil.removeObjectQuotes(dbObject2.getObjectName()), true);
    }

    private String buildCleanExpression(DbObject dbObject) {
        String string = SqlUtil.removeObjectQuotes(dbObject.getCatalog());
        String string2 = SqlUtil.removeObjectQuotes(dbObject.getSchema());
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append('.');
        }
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append('.');
        }
        stringBuilder.append(SqlUtil.removeObjectQuotes(dbObject.getObjectName()));
        return stringBuilder.toString();
    }
}

