/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.List;
import workbench.db.DBID;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TablePartition;
import workbench.db.WbConnection;
import workbench.db.oracle.OraclePartitionLister;
import workbench.db.oracle.OracleUtils;
import workbench.db.postgres.PostgresPartitionLister;

public interface PartitionLister {
    public static final String PARTITION_TYPE_NAME = "PARTITION";

    public List<? extends TablePartition> getPartitions(TableIdentifier var1);

    public List<? extends TablePartition> getSubPartitions(TableIdentifier var1, TablePartition var2);

    public boolean supportsSubPartitions();

    public static class Factory {
        public static PartitionLister createReader(WbConnection wbConnection) {
            if (wbConnection == null) {
                return null;
            }
            DBID dBID = DBID.fromConnection(wbConnection);
            switch (dBID) {
                case Postgres: {
                    if (JdbcUtils.hasMinimumServerVersion(wbConnection, "10")) {
                        return new PostgresPartitionLister(wbConnection);
                    }
                }
                case Oracle: {
                    if (!OracleUtils.supportsPartitioning(wbConnection)) break;
                    return new OraclePartitionLister(wbConnection);
                }
            }
            return null;
        }
    }
}

