/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.ConnectionProfile;
import workbench.db.ProfileStorage;
import workbench.gui.profiles.ProfileKey;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.WbFile;

public class ProfileManager {
    private boolean loaded = false;
    private boolean profilesDeleted = false;
    private final List<ConnectionProfile> profiles = new ArrayList<ConnectionProfile>();
    private final List<WbFile> profileFiles = new ArrayList<WbFile>(1);
    private final Map<Integer, WbFile> profileSources = new HashMap<Integer, WbFile>();

    public ProfileManager(File file) {
        this.addProfileSource(file);
        this.sortFiles();
    }

    public ProfileManager(List<WbFile> list) {
        if (CollectionUtil.isEmpty(list)) {
            this.setProfileSource(Collections.singletonList(Settings.getInstance().getDefaultProfileStorage()));
        } else {
            this.setProfileSource(list);
        }
    }

    public ConnectionProfile getProfile(ProfileKey profileKey) {
        if (profileKey == null) {
            return null;
        }
        return ProfileManager.findProfile(this.profiles, profileKey);
    }

    public List<String> getProfileKeys() {
        ArrayList<String> arrayList = new ArrayList<String>(this.profiles.size());
        for (ConnectionProfile connectionProfile : this.profiles) {
            arrayList.add(connectionProfile.getKey().toString());
        }
        arrayList.sort(CaseInsensitiveComparator.INSTANCE);
        return arrayList;
    }

    public List<ConnectionProfile> getProfiles() {
        return Collections.unmodifiableList(this.profiles);
    }

    public void ensureLoaded() {
        if (!this.loaded) {
            this.readProfiles();
        }
    }

    public void load() {
        this.readProfiles();
    }

    public void save() {
        for (WbFile wbFile : this.profileFiles) {
            if (Settings.getInstance().getCreateProfileBackup()) {
                FileUtil.createBackup(wbFile);
            }
            ProfileStorage profileStorage = ProfileStorage.Factory.getStorageHandler(wbFile);
            List<ConnectionProfile> list = this.getProfilesForFile(wbFile);
            profileStorage.saveProfiles(list, wbFile);
        }
        this.resetChangedFlags();
    }

    private List<ConnectionProfile> getProfilesForFile(WbFile wbFile) {
        ArrayList<ConnectionProfile> arrayList = new ArrayList<ConnectionProfile>();
        for (ConnectionProfile connectionProfile : this.profiles) {
            WbFile wbFile2 = this.profileSources.get(connectionProfile.internalId());
            if (wbFile2 == null || !wbFile2.equals(wbFile)) continue;
            arrayList.add(connectionProfile);
        }
        return arrayList;
    }

    private void sortFiles() {
        Comparator comparator = (wbFile, wbFile2) -> wbFile.getName().compareToIgnoreCase(wbFile2.getName());
        this.profileFiles.sort(comparator);
    }

    private void setProfileSource(List<WbFile> list) {
        this.profileFiles.clear();
        this.profileSources.clear();
        this.profilesDeleted = false;
        for (File file : list) {
            this.addProfileSource(file);
        }
        this.sortFiles();
    }

    private void addProfileSource(File file) {
        if (file.isDirectory()) {
            this.profileFiles.addAll(this.listFiles(file));
        } else {
            this.profileFiles.add(new WbFile(file));
        }
    }

    private List<WbFile> listFiles(File file) {
        ArrayList<WbFile> arrayList = new ArrayList<WbFile>(5);
        try {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(file.toPath(), "*.{xml,properties}");
            for (Path path : directoryStream) {
                arrayList.add(new WbFile(path.toFile()));
            }
            LogMgr.logDebug(new CallerInfo(){}, "Found " + arrayList.size() + " potential profile files");
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Error listing files in " + file, iOException);
        }
        return arrayList;
    }

    private void readProfiles() {
        CallerInfo callerInfo = new CallerInfo(){};
        long l = System.currentTimeMillis();
        LogMgr.logTrace(callerInfo, "readProfiles() called at " + l + " from " + Thread.currentThread().getName());
        this.profiles.clear();
        this.profileSources.clear();
        this.profilesDeleted = false;
        for (WbFile wbFile : this.profileFiles) {
            if (!wbFile.exists()) {
                LogMgr.logWarning(callerInfo, "Profile storage file " + wbFile.getFullPath() + " not found!");
                continue;
            }
            List<ConnectionProfile> list = this.readFile(wbFile);
            if (list == null) {
                LogMgr.logWarning(callerInfo, "Ignoring profile file \"" + wbFile + "\" because it does not seem to be a valid profile storage");
                continue;
            }
            if (list.isEmpty()) {
                LogMgr.logWarning(callerInfo, "No profiles found in \"" + wbFile + "\" file will be ignored");
                continue;
            }
            this.profiles.addAll(list);
            for (ConnectionProfile connectionProfile : list) {
                this.profileSources.put(connectionProfile.internalId(), wbFile);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logInfo(callerInfo, this.profiles.size() + " profiles loaded in " + l2 + "ms from " + this.profileFiles.size() + " files");
        this.resetChangedFlags();
        this.loaded = true;
    }

    private List<ConnectionProfile> readFile(WbFile wbFile) {
        ProfileStorage profileStorage = ProfileStorage.Factory.getStorageHandler(wbFile);
        List<ConnectionProfile> list = null;
        if (wbFile.exists()) {
            long l = System.currentTimeMillis();
            list = profileStorage.readProfiles(wbFile);
            long l2 = System.currentTimeMillis() - l;
            if (list != null) {
                LogMgr.logDebug(new CallerInfo(){}, list.size() + " profiles loaded from " + wbFile.getFullPath() + " in " + l2 + "ms");
            }
        }
        return list;
    }

    private void resetChangedFlags() {
        for (ConnectionProfile connectionProfile : this.profiles) {
            connectionProfile.resetChangedFlags();
        }
        this.profilesDeleted = false;
    }

    public void reset() {
        this.loaded = false;
        this.profilesDeleted = false;
        this.profiles.clear();
        this.profileSources.clear();
    }

    public String getProfilesPath() {
        return this.getFile().getFullPath();
    }

    public WbFile getFile() {
        return this.getDefaultStorage();
    }

    public List<WbFile> getSourceFiles() {
        return Collections.unmodifiableList(this.profileFiles);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean profilesAreModified() {
        if (this.profiles == null) {
            return false;
        }
        if (this.profilesDeleted) {
            return true;
        }
        for (ConnectionProfile connectionProfile : this.profiles) {
            if (!connectionProfile.isChanged()) continue;
            return true;
        }
        return false;
    }

    public void setSourceFile(ConnectionProfile connectionProfile, WbFile wbFile) {
        if (connectionProfile != null && wbFile != null) {
            this.profileSources.put(connectionProfile.internalId(), wbFile);
        }
    }

    public void applyProfiles(List<ConnectionProfile> list) {
        if (list == null) {
            return;
        }
        for (ConnectionProfile object : this.profiles) {
            if (list.contains(object)) continue;
            this.profilesDeleted = true;
            break;
        }
        this.profiles.clear();
        WbFile wbFile = this.getDefaultStorage();
        for (ConnectionProfile connectionProfile : list) {
            this.profiles.add(connectionProfile.createStatefulCopy());
            if (this.profileSources.get(connectionProfile.internalId()) != null) continue;
            this.profileSources.put(connectionProfile.internalId(), wbFile);
        }
    }

    public void addProfile(ConnectionProfile connectionProfile) {
        this.addProfile(connectionProfile, null);
    }

    public void addProfile(ConnectionProfile connectionProfile, WbFile wbFile) {
        this.profiles.remove(connectionProfile);
        this.profiles.add(connectionProfile);
        if (wbFile == null) {
            wbFile = this.getDefaultStorage();
        }
        this.profileSources.put(connectionProfile.internalId(), wbFile);
    }

    private WbFile getDefaultStorage() {
        for (WbFile wbFile : this.profileFiles) {
            String string = wbFile.getName();
            if (string.equalsIgnoreCase("wb-profiles.properties")) {
                return wbFile;
            }
            if (!string.equalsIgnoreCase("WbProfiles.xml")) continue;
            return wbFile;
        }
        return this.profileFiles.get(0);
    }

    public void removeProfile(ConnectionProfile connectionProfile) {
        this.profiles.remove(connectionProfile);
        this.profileSources.remove(connectionProfile.internalId());
        if (!connectionProfile.isNew()) {
            this.profilesDeleted = true;
        }
    }

    public static ConnectionProfile findProfile(List<ConnectionProfile> list, ProfileKey profileKey) {
        if (profileKey == null) {
            return null;
        }
        if (list == null) {
            return null;
        }
        String string = profileKey.getName();
        String string2 = profileKey.getGroup();
        ConnectionProfile connectionProfile = null;
        for (ConnectionProfile connectionProfile2 : list) {
            if (!string.equalsIgnoreCase(connectionProfile2.getName().trim())) continue;
            if (connectionProfile == null) {
                connectionProfile = connectionProfile2;
            }
            if (string2 == null) {
                return connectionProfile2;
            }
            if (!string2.equalsIgnoreCase(connectionProfile2.getGroup().trim())) continue;
            return connectionProfile2;
        }
        return connectionProfile;
    }
}

