/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import workbench.db.ErrorPositionReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.ErrorDescriptor;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class RegexErrorPositionReader
implements ErrorPositionReader {
    private final Pattern positionPattern;
    private final Pattern lineInfoPattern;
    private final Pattern columnInfoPattern;
    private final Pattern noNumbers = Pattern.compile("[^0-9]");
    private boolean oneBasedNumbers = true;

    public RegexErrorPositionReader(String string) throws PatternSyntaxException {
        this.positionPattern = Pattern.compile(string);
        this.lineInfoPattern = null;
        this.columnInfoPattern = null;
        LogMgr.logDebug(new CallerInfo(){}, "Using regex for position: " + string);
    }

    public RegexErrorPositionReader(String string, String string2) throws PatternSyntaxException {
        this.lineInfoPattern = string == null ? null : Pattern.compile(string);
        this.columnInfoPattern = string2 == null ? null : Pattern.compile(string2);
        this.positionPattern = null;
        LogMgr.logDebug(new CallerInfo(){}, "Using regex for line#: " + string + ", regex for column#: " + string2);
    }

    public void setNumbersAreOneBased(boolean bl) {
        this.oneBasedNumbers = bl;
    }

    @Override
    public ErrorDescriptor getErrorPosition(WbConnection wbConnection, String string, Exception exception) {
        if (exception == null) {
            return null;
        }
        String string2 = exception.getMessage();
        ErrorDescriptor errorDescriptor = this.getErrorPosition(string, string2);
        if (errorDescriptor.getErrorPosition() > -1 && !wbConnection.getDbSettings().getErrorPosIncludesLeadingComments()) {
            int n = SqlUtil.getRealStart(string);
            int n2 = errorDescriptor.getErrorPosition();
            errorDescriptor.setErrorOffset(n2 + n);
        }
        return errorDescriptor;
    }

    public ErrorDescriptor getErrorPosition(String string, String string2) {
        if (this.positionPattern != null) {
            ErrorDescriptor errorDescriptor = new ErrorDescriptor();
            errorDescriptor.setErrorOffset(this.getValueFromRegex(string2, this.positionPattern));
            errorDescriptor.setErrorMessage(string2);
            return errorDescriptor;
        }
        if (this.lineInfoPattern != null || this.columnInfoPattern != null) {
            return this.getPositionFromLineAndColumn(string2, string);
        }
        return null;
    }

    private int getValueFromRegex(String string, Pattern pattern) {
        if (pattern == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        int n = -1;
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = string.substring(matcher.start(), matcher.end());
            LogMgr.logDebug(new CallerInfo(){}, "Using " + string2 + " from message: " + string);
            String string3 = this.noNumbers.matcher(string2).replaceAll("");
            n = StringUtil.getIntValue(string3, -1);
        } else {
            LogMgr.logDebug(new CallerInfo(){}, "No match found for RegEx: \"" + pattern.pattern() + "\" in message: " + string);
        }
        if (n > 0 && this.oneBasedNumbers) {
            --n;
        }
        return n;
    }

    private ErrorDescriptor getPositionFromLineAndColumn(String string, String string2) {
        ErrorDescriptor errorDescriptor = new ErrorDescriptor();
        errorDescriptor.setErrorMessage(string);
        int n = this.getValueFromRegex(string, this.lineInfoPattern);
        int n2 = this.getValueFromRegex(string, this.columnInfoPattern);
        errorDescriptor.setErrorPosition(n, n2);
        int n3 = SqlUtil.getErrorOffset(string2, errorDescriptor);
        if (n3 > -1) {
            errorDescriptor.setErrorOffset(n3);
        }
        return errorDescriptor;
    }

    @Override
    public String enhanceErrorMessage(String string, String string2, ErrorDescriptor errorDescriptor) {
        String string3 = SqlUtil.getErrorIndicator(string, errorDescriptor);
        if (string3 != null) {
            if (string2 == null) {
                string2 = "";
            }
            if (StringUtil.isNonEmpty(string2)) {
                string2 = string2 + "\n\n";
            }
            string2 = string2 + string3;
        }
        return string2;
    }
}

