/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.Objects;
import workbench.db.DbObject;
import workbench.db.WbConnection;

public class SchemaIdentifier
implements DbObject {
    private String catalog;
    private String schemaName;

    public SchemaIdentifier(String string) {
        this.schemaName = string;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return this.getObjectName();
    }

    @Override
    public String getObjectType() {
        return "SCHEMA";
    }

    @Override
    public String getObjectName() {
        return this.schemaName;
    }

    @Override
    public void setName(String string) {
        this.schemaName = string;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return wbConnection.getMetadata().quoteObjectname(this.schemaName);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.getObjectName(wbConnection);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.getObjectName(wbConnection);
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getObjectName(wbConnection);
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public void setComment(String string) {
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        if (wbConnection == null) {
            return null;
        }
        if (wbConnection.getMetadata().isSqlServer() && this.catalog != null) {
            return "use " + wbConnection.getMetadata().quoteObjectname(this.catalog) + ";\ndrop schema " + wbConnection.getMetadata().quoteObjectname(this.schemaName) + ";";
        }
        return null;
    }

    public int hashCode() {
        int n = 3;
        n = 53 * n + Objects.hashCode(this.catalog);
        n = 53 * n + Objects.hashCode(this.schemaName);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SchemaIdentifier schemaIdentifier = (SchemaIdentifier)object;
        if (this.catalog != null && schemaIdentifier.catalog != null && !Objects.equals(this.catalog, schemaIdentifier.catalog)) {
            return false;
        }
        return Objects.equals(this.schemaName, schemaIdentifier.schemaName);
    }

    public String toString() {
        if (this.catalog == null) {
            return this.schemaName;
        }
        return this.catalog + "." + this.schemaName;
    }

    @Override
    public boolean supportsGetSource() {
        return false;
    }
}

