/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class TableColumnsDatastore
extends DataStore {
    public static final int COLUMN_IDX_TABLE_DEFINITION_COL_NAME = 0;
    public static final int COLUMN_IDX_TABLE_DEFINITION_DATA_TYPE = 1;
    public static final int COLUMN_IDX_TABLE_DEFINITION_PK_FLAG = 2;
    public static final int COLUMN_IDX_TABLE_DEFINITION_NULLABLE = 3;
    public static final int COLUMN_IDX_TABLE_DEFINITION_DEFAULT = 4;
    public static final int COLUMN_IDX_TABLE_DEFINITION_AUTO_INC = 5;
    public static final int COLUMN_IDX_TABLE_DEFINITION_COMPUTED = 6;
    public static final int COLUMN_IDX_TABLE_DEFINITION_REMARKS = 7;
    public static final int COLUMN_IDX_TABLE_DEFINITION_JAVA_SQL_TYPE = 8;
    public static final int COLUMN_IDX_TABLE_DEFINITION_SIZE = 9;
    public static final int COLUMN_IDX_TABLE_DEFINITION_DIGITS = 10;
    public static final int COLUMN_IDX_TABLE_DEFINITION_POSITION = 11;
    public static final String JAVA_SQL_TYPE_COL_NAME = "JDBC Type";
    public static final String SCALE_COL_NAME = "SCALE/SIZE";
    public static final String PRECISION_COL_NAME = "PRECISION";
    public static final String[] TABLE_DEFINITION_COLS = new String[]{"COLUMN_NAME", "DATA_TYPE", "PK", "NULLABLE", "DEFAULT", "AUTOINCREMENT", "COMPUTED", "REMARKS", "JDBC Type", "SCALE/SIZE", "PRECISION", "POSITION"};
    private static final int[] TYPES = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 4, 4, 4, 4};
    private static final int[] SIZES = new int[]{20, 18, 5, 8, 10, 10, 25, 18, 2, 2, 2, 2};
    private TableIdentifier sourceTable;

    public TableColumnsDatastore(TableDefinition tableDefinition) {
        super(TABLE_DEFINITION_COLS, TYPES, SIZES);
        this.sourceTable = tableDefinition.getTable();
        List<ColumnIdentifier> list = tableDefinition.getColumns();
        if (list != null) {
            for (ColumnIdentifier columnIdentifier : list) {
                int n = this.addRow();
                this.setValue(n, 0, (Object)columnIdentifier.getColumnName());
                this.setValue(n, 8, (Object)columnIdentifier.getDataType());
                this.setValue(n, 2, (Object)(columnIdentifier.isPkColumn() ? "YES" : "NO"));
                this.setValue(n, 9, (Object)columnIdentifier.getColumnSize());
                this.setValue(n, 10, (Object)columnIdentifier.getDecimalDigits());
                this.setValue(n, 3, (Object)(columnIdentifier.isNullable() ? "YES" : "NO"));
                this.setValue(n, 5, (Object)(columnIdentifier.isAutoincrement() ? "YES" : "NO"));
                boolean bl = !columnIdentifier.isAutoGenerated() && StringUtil.isNonEmpty(columnIdentifier.getComputedColumnExpression());
                this.setValue(n, 6, (Object)(bl ? "YES" : "NO"));
                this.setValue(n, 11, (Object)columnIdentifier.getPosition());
                this.setValue(n, 1, (Object)columnIdentifier.getDbmsType());
                this.setValue(n, 4, (Object)columnIdentifier.getDefaultValue());
                this.setValue(n, 7, (Object)columnIdentifier.getComment());
                this.getRow(n).setUserObject(columnIdentifier);
            }
        }
        this.resetStatus();
    }

    public TableIdentifier getSourceTable() {
        return this.sourceTable;
    }

    public static List<ColumnIdentifier> createColumnIdentifiers(DbMetadata dbMetadata, DataStore dataStore) {
        int n = dataStore.getRowCount();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(n);
        for (int i = 0; i < n; ++i) {
            ColumnIdentifier columnIdentifier = (ColumnIdentifier)dataStore.getRow(i).getUserObject();
            if (columnIdentifier == null) {
                String string = dataStore.getValueAsString(i, 0);
                int n2 = dataStore.getValueAsInt(i, 8, 1111);
                String string2 = dataStore.getValueAsString(i, 1);
                boolean bl = "YES".equals(dataStore.getValueAsString(i, 2));
                columnIdentifier = new ColumnIdentifier(dbMetadata.quoteObjectname(string), dbMetadata.getDataTypeResolver().fixColumnType(n2, string2), bl);
                int n3 = dataStore.getValueAsInt(i, 9, 0);
                int n4 = dataStore.getValueAsInt(i, 10, -1);
                String string3 = dataStore.getValueAsString(i, 3);
                int n5 = dataStore.getValueAsInt(i, 11, 0);
                String string4 = dataStore.getValueAsString(i, 7);
                String string5 = dataStore.getValueAsString(i, 4);
                columnIdentifier.setColumnSize(n3);
                columnIdentifier.setDecimalDigits(n4);
                columnIdentifier.setIsNullable(StringUtil.stringToBool(string3));
                columnIdentifier.setDbmsType(string2);
                columnIdentifier.setComment(string4);
                columnIdentifier.setDefaultValue(string5);
                columnIdentifier.setPosition(n5);
            }
            arrayList.add(columnIdentifier);
        }
        return arrayList;
    }
}

