/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import workbench.db.CatalogInformationReader;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DBID;
import workbench.db.DbDriver;
import workbench.db.DbMetadata;
import workbench.db.DbSettings;
import workbench.db.GenerateDDLCommit;
import workbench.db.JdbcUtils;
import workbench.db.KeepAliveDaemon;
import workbench.db.ObjectNameFilter;
import workbench.db.TransactionChecker;
import workbench.db.greenplum.GreenplumUtil;
import workbench.db.mssql.SqlServerUtil;
import workbench.db.objectcache.DbObjectCache;
import workbench.db.objectcache.DbObjectCacheFactory;
import workbench.db.oracle.OracleUtils;
import workbench.db.oracle.OracleWarningsClearer;
import workbench.interfaces.DbExecutionListener;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.sql.EndReadOnlyTrans;
import workbench.sql.ErrorDescriptor;
import workbench.sql.ErrorReportLevel;
import workbench.sql.StatementRunner;
import workbench.sql.StatementRunnerResult;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptParser;
import workbench.sql.preparedstatement.PreparedStatementPool;
import workbench.ssh.SshException;
import workbench.util.DdlObjectInfo;
import workbench.util.ExceptionUtil;
import workbench.util.SqlParsingUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.VersionNumber;
import workbench.util.WbThread;

public class WbConnection
implements DbExecutionListener {
    public static final String PROP_CATALOG = "catalog";
    public static final String PROP_CATALOG_LIST = "catalog-list";
    public static final String PROP_SCHEMA = "schema";
    public static final String PROP_AUTOCOMMIT = "autocommit";
    public static final String PROP_CONNECTION_STATE = "state";
    public static final String CONNECTION_CLOSED = "closed";
    public static final String CONNECTION_OPEN = "open";
    public static final String PROP_READONLY = "readonly";
    public static final String PROP_BUSY = "busy";
    private VersionNumber dbVersion;
    private String dbProductVersion;
    private String dbProductName;
    private String driverVersion;
    private final String id;
    private StringBuilder scriptError;
    private Connection sqlConnection;
    private DbMetadata metaData;
    private ConnectionProfile profile;
    private PreparedStatementPool preparedStatementPool;
    private final List<PropertyChangeListener> listeners = Collections.synchronizedList(new ArrayList(1));
    private OracleWarningsClearer oracleWarningsClearer;
    private boolean hasOracleContainers;
    private boolean busy;
    private boolean lastAutocommitState;
    private KeepAliveDaemon keepAlive;
    private String currentCatalog;
    private String currentSchema;
    private boolean removeComments;
    private boolean removeNewLines;
    private Integer fetchSize;
    private boolean supportsGetWarnings = true;
    private Boolean sessionReadOnly;
    private Boolean sessionConfirmUpdates;
    private final Map<String, String> sessionProps = new HashMap<String, String>();
    private DdlObjectInfo lastDdlObject;
    private SqlParsingUtil keywordUtil;
    private boolean pingAvailable = true;
    private boolean supportsSavepoints = true;
    private boolean shared = false;
    private String switchedUrl;
    private boolean logSavepoints;
    private final Set<Integer> usedSavepoints = new HashSet<Integer>(2);
    private final List<PropertyChangeEvent> pendingEvents = new ArrayList<PropertyChangeEvent>();

    public WbConnection(String string, Connection connection, ConnectionProfile connectionProfile) throws SQLException {
        this.id = string;
        this.profile = connectionProfile;
        this.setSqlConnection(connection);
        this.supportsSavepoints = this.supportsSavepoints();
        this.initKeepAlive();
        if (this.profile != null) {
            this.removeComments = this.profile.getRemoveComments();
        }
        if (this.metaData != null) {
            DbSettings dbSettings = this.metaData.getDbSettings();
            this.removeNewLines = dbSettings.removeNewLinesInSQL();
            this.logSavepoints = dbSettings.getBoolProperty("savepoints.debug", true);
        }
        if (this.profile != null) {
            this.lastAutocommitState = this.profile.getAutocommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchURL(String string, CatalogInformationReader catalogInformationReader) throws SQLException {
        boolean bl = this.isBusy();
        try {
            this.setBusy(false);
            String string2 = catalogInformationReader == null ? this.getCurrentCatalog() : catalogInformationReader.getCurrentCatalog();
            Connection connection = ConnectionMgr.getInstance().switchURL(this, string);
            this.setSqlConnection(connection);
            if (this.profile != null) {
                this.lastAutocommitState = this.profile.getAutocommit();
            }
            this.switchedUrl = string;
            String string3 = catalogInformationReader == null ? this.getCurrentCatalog() : catalogInformationReader.getCurrentCatalog();
            this.getObjectCache().clear();
            this.fireConnectionStateChanged(PROP_CATALOG, string2, string3);
        }
        catch (SshException sshException) {
            LogMgr.logError(new CallerInfo(){}, "Could not initialize SSH session when switching URLs", sshException);
        }
        finally {
            this.setBusy(bl);
        }
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    public synchronized SqlParsingUtil getParsingUtil() {
        if (this.keywordUtil == null) {
            this.keywordUtil = new SqlParsingUtil(this);
        }
        return this.keywordUtil;
    }

    public void setLastDDLObject(DdlObjectInfo ddlObjectInfo) {
        this.lastDdlObject = ddlObjectInfo;
    }

    public DdlObjectInfo getLastDdlObjectInfo() {
        return this.lastDdlObject;
    }

    public void setSessionProperty(String string, String string2) {
        this.sessionProps.put(string, string2);
    }

    public String getSessionProperty(String string) {
        return this.sessionProps.get(string);
    }

    public boolean hasMultipleOracleContainers() {
        return this.hasOracleContainers;
    }

    public DelimiterDefinition getAlternateDelimiter() {
        return Settings.getInstance().getAlternateDelimiter(this, null);
    }

    public TransactionChecker getTransactionChecker() {
        if (this.getProfile().getDetectOpenTransaction()) {
            return TransactionChecker.Factory.createChecker(this);
        }
        return TransactionChecker.NO_CHECK;
    }

    public ObjectNameFilter getCatalogFilter() {
        return this.profile == null ? null : this.profile.getCatalogFilter();
    }

    public ObjectNameFilter getSchemaFilter() {
        return this.profile == null ? null : this.profile.getSchemaFilter();
    }

    public boolean getRemoveComments() {
        return this.removeComments;
    }

    public boolean getRemoveNewLines() {
        return this.removeNewLines;
    }

    public String getId() {
        return this.id;
    }

    public String getDbId() {
        if (this.getDbSettings() == null) {
            return null;
        }
        return this.getDbSettings().getDbId();
    }

    public void resetSessionReadOnly() {
        if (this.sessionReadOnly != null) {
            this.sessionReadOnly = null;
            this.fireConnectionStateChanged(PROP_READONLY, null, null);
            this.syncReadOnlyState();
        }
    }

    public void resetSessionFlags() {
        boolean bl = this.sessionReadOnly != null;
        this.sessionReadOnly = null;
        this.sessionConfirmUpdates = null;
        if (bl) {
            this.fireConnectionStateChanged(PROP_READONLY, null, null);
            this.syncReadOnlyState();
        }
    }

    public void setSessionReadOnly(boolean bl) {
        boolean bl2 = this.sessionReadOnly == null ? false : this.sessionReadOnly;
        boolean bl3 = this.sessionReadOnly != null;
        this.sessionReadOnly = bl;
        if (bl) {
            this.sessionConfirmUpdates = !bl;
        }
        if (!bl3 || bl2 != bl) {
            this.fireConnectionStateChanged(PROP_READONLY, Boolean.toString(bl2), Boolean.toString(bl));
            this.syncReadOnlyState();
        }
    }

    public void syncReadOnlyState() {
        if (!this.getDbSettings().syncConnectionReadOnlyState()) {
            return;
        }
        try {
            if (this.sqlConnection.isReadOnly() == this.isSessionReadOnly()) {
                return;
            }
            this.rollbackSilently();
            String string = this.getDbSettings().getSetReadOnlySQL();
            boolean bl = false;
            if (StringUtil.isNonBlank(string)) {
                LogMgr.logInfo(new CallerInfo(){}, "Setting connection to read only using: " + string);
                bl = JdbcUtils.runStatement(this, string);
            }
            if (!bl) {
                this.sqlConnection.setReadOnly(this.isSessionReadOnly());
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not change read only flag", throwable);
        }
    }

    public boolean isSessionReadOnly() {
        if (this.sessionReadOnly != null) {
            return this.sessionReadOnly;
        }
        return this.getProfile().isReadOnly();
    }

    public void setSessionConfirmUpdate(boolean bl) {
        this.sessionConfirmUpdates = bl;
        if (bl) {
            this.sessionReadOnly = !bl;
            this.syncReadOnlyState();
        }
    }

    public boolean confirmUpdatesInSession() {
        if (this.sessionConfirmUpdates != null) {
            return this.sessionConfirmUpdates;
        }
        return this.getProfile().getConfirmUpdates();
    }

    public int getIsolationLevel() {
        if (this.sqlConnection == null) {
            return 0;
        }
        try {
            return this.sqlConnection.getTransactionIsolation();
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve isolation level", throwable);
            return 0;
        }
    }

    public void setIsolationLevel(int n) {
        if (this.sqlConnection == null) {
            return;
        }
        if (n == 0) {
            return;
        }
        try {
            this.sqlConnection.setTransactionIsolation(n);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not set isolation level", throwable);
        }
    }

    public String getIsolationLevelName() {
        if (this.sqlConnection == null) {
            return "";
        }
        try {
            return SqlUtil.getIsolationLevelName(this.sqlConnection.getTransactionIsolation());
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving isolation level", throwable);
            return "n/a";
        }
    }

    public PreparedStatementPool getPreparedStatementPool() {
        if (this.preparedStatementPool == null) {
            this.preparedStatementPool = new PreparedStatementPool(this);
        }
        return this.preparedStatementPool;
    }

    public DbObjectCache getObjectCache() {
        return DbObjectCacheFactory.getInstance().getCache(this);
    }

    public String getDisplaySchema() {
        return this.currentSchema;
    }

    public String getCurrentSchema() {
        if (this.metaData == null) {
            return null;
        }
        return this.metaData.getCurrentSchema();
    }

    public String getCurrentUser() {
        if (this.profile != null && !this.profile.getPromptForUsername()) {
            return this.profile.getLoginUser();
        }
        try {
            return this.sqlConnection.getMetaData().getUserName();
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Could not retrieve current database user", throwable);
            return "";
        }
    }

    private String getWindowsUser() {
        String string = this.getUrl();
        if (StringUtil.isEmptyString(string)) {
            return "";
        }
        if (string.startsWith("jdbc:sqlserver:") && string.contains("integratedSecurity=true")) {
            String string2 = System.getProperty("user.name");
            String string3 = System.getenv("userdomain");
            if (string3 != null) {
                return string3 + "\\" + string2;
            }
            return string2;
        }
        return "";
    }

    public boolean supportsQueryTimeout() {
        if (this.metaData == null) {
            return false;
        }
        return this.metaData.getDbSettings().supportsQueryTimeout();
    }

    public ConnectionProfile getProfile() {
        return this.profile;
    }

    public boolean trimCharData() {
        if (this.profile == null) {
            return false;
        }
        return this.profile.getTrimCharData();
    }

    void runPreDisconnectScript() {
        if (this.keepAlive != null) {
            this.keepAlive.shutdown();
        }
        if (this.profile == null) {
            return;
        }
        if (this.sqlConnection == null) {
            return;
        }
        String string = this.profile.getPreDisconnectScript();
        this.runConnectScript(string, "disconnect");
    }

    void runPostConnectScript() {
        if (this.profile == null) {
            return;
        }
        if (this.sqlConnection == null) {
            return;
        }
        String string = this.profile.getPostConnectScript();
        this.runConnectScript(string, "connect");
        this.applyFilterReplacements(this.getSchemaFilter());
        this.applyFilterReplacements(this.getCatalogFilter());
    }

    private void applyFilterReplacements(ObjectNameFilter objectNameFilter) {
        if (objectNameFilter == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("${current_user}", this.getCurrentUser());
        hashMap.put("${current_schema}", this.getCurrentSchema());
        hashMap.put("${current_catalog}", this.getCurrentCatalog());
        objectNameFilter.setReplacements(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void runConnectScript(String string, String string2) {
        if (StringUtil.isBlank(string)) {
            return;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        LogMgr.logInfo(callerInfo, "Executing " + string2 + " script for connection [" + this.getDbId() + "]: " + this.getDisplayString(true) + " ...");
        StatementRunner statementRunner = new StatementRunner();
        statementRunner.setConnection(this);
        statementRunner.setErrorReportLevel(ErrorReportLevel.none);
        ScriptParser scriptParser = new ScriptParser(string);
        scriptParser.setParserType(ParserType.getTypeFromConnection(this));
        StringBuilder stringBuilder = new StringBuilder(150);
        String string3 = "MsgConnScript" + string2;
        String string4 = null;
        try {
            int n = scriptParser.getSize();
            for (int i = 0; i < n; ++i) {
                string4 = scriptParser.getCommand(i);
                String string5 = StringUtil.getMaxSubstring(SqlUtil.makeCleanSql(string4, false, false, true, this), 250);
                try {
                    StatementRunnerResult statementRunnerResult = statementRunner.runStatement(string4);
                    String string6 = ResourceMgr.getString(string3) + " " + string5;
                    stringBuilder.append(string6);
                    LogMgr.logDebug(callerInfo, "  (" + this.getId() + ") Executed statement: " + string5);
                    if (!statementRunnerResult.isSuccess()) {
                        stringBuilder.append("\n  ");
                        stringBuilder.append(ResourceMgr.getString("TxtError"));
                        stringBuilder.append(": ");
                        ErrorDescriptor errorDescriptor = statementRunnerResult.getErrorDescriptor();
                        if (errorDescriptor != null) {
                            stringBuilder.append(errorDescriptor.getErrorMessage());
                        } else if (statementRunnerResult.hasMessages()) {
                            stringBuilder.append(statementRunnerResult.getMessages());
                        }
                    }
                    stringBuilder.append("\n");
                    continue;
                }
                finally {
                    statementRunner.statementDone();
                }
            }
            stringBuilder.append("\n");
        }
        catch (Throwable throwable) {
            LogMgr.logError(callerInfo, "Error executing " + string2 + " script for connection: " + this.getId(), throwable);
            stringBuilder = new StringBuilder(50);
            stringBuilder.append(ResourceMgr.getString("MsgBatchStatementError"));
            stringBuilder.append(": ");
            stringBuilder.append(string4);
            stringBuilder.append('\n');
            stringBuilder.append(throwable.getMessage());
        }
        finally {
            statementRunner.done();
        }
        this.scriptError = stringBuilder;
    }

    private void setSqlConnection(Connection connection) throws SQLException {
        this.sqlConnection = connection;
        this.metaData = new DbMetadata(this);
        if (this.metaData.isOracle()) {
            if (!JdbcUtils.hasMiniumDriverVersion(this.getSqlConnection(), "10.0")) {
                this.oracleWarningsClearer = new OracleWarningsClearer();
            }
            this.hasOracleContainers = OracleUtils.hasMultipleContainers(this);
        }
        this.currentCatalog = this.metaData.getCurrentCatalog();
    }

    public String getWarnings() {
        if (!this.supportsGetWarnings) {
            return null;
        }
        try {
            SQLWarning sQLWarning = this.getSqlConnection().getWarnings();
            if (sQLWarning == null) {
                if (this.scriptError != null) {
                    String string = this.scriptError.toString();
                    this.scriptError = null;
                    return string;
                }
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder(200);
            if (!StringUtil.isEmptyString(this.scriptError)) {
                stringBuilder.append((CharSequence)this.scriptError);
            }
            while (sQLWarning != null) {
                String string = sQLWarning.getMessage();
                stringBuilder.append('\n');
                stringBuilder.append(string);
                sQLWarning = sQLWarning.getNextWarning();
            }
            this.clearWarnings();
            return stringBuilder.toString();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.supportsGetWarnings = false;
            LogMgr.logWarning(new CallerInfo(){}, "getWarnings() not supported by the driver");
            return null;
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when retrieving SQL Warnings", throwable);
            return null;
        }
    }

    public void clearWarnings() {
        this.scriptError = null;
        if (this.sqlConnection == null) {
            return;
        }
        try {
            this.sqlConnection.clearWarnings();
            if (this.oracleWarningsClearer != null) {
                this.oracleWarningsClearer.clearWarnings(this.sqlConnection);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error resetting warnings!", throwable);
        }
    }

    public Connection getSqlConnection() {
        return this.sqlConnection;
    }

    public void commit() throws SQLException {
        if (this.getAutoCommit()) {
            LogMgr.logTrace(new CallerInfo(){}, "Commit() called on a connection with autocommit enabled", new Exception("Traceback"));
            return;
        }
        this.usedSavepoints.clear();
        if (this.getDbSettings().supportsTransactions()) {
            this.sqlConnection.commit();
        }
    }

    private String debugString(Savepoint savepoint) {
        if (savepoint == null) {
            return "null";
        }
        try {
            return Integer.toString(savepoint.getSavepointId());
        }
        catch (Throwable throwable) {
            return savepoint.toString();
        }
    }

    private void logSavepoint(CallerInfo callerInfo, String string, Savepoint savepoint) {
        if (savepoint == null) {
            return;
        }
        if (this.logSavepoints && LogMgr.isDebugEnabled()) {
            if (callerInfo == null) {
                callerInfo = new CallerInfo(){};
            }
            LogMgr.logDebug(callerInfo, string + " savepoint #" + this.debugString(savepoint) + ", connection: [" + this.id + "]");
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    public synchronized Savepoint setSavepoint(CallerInfo callerInfo) throws SQLException {
        if (this.getAutoCommit()) {
            return null;
        }
        if (!this.supportsSavepoints) {
            return null;
        }
        try {
            Savepoint savepoint = this.sqlConnection.setSavepoint();
            this.usedSavepoints.add(savepoint.getSavepointId());
            this.logSavepoint(callerInfo, "Set", savepoint);
            return savepoint;
        }
        catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Savepoints not supported", throwable);
            this.supportsSavepoints = false;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not set Savepoint", exception);
        }
        return null;
    }

    public void rollback(Savepoint savepoint) {
        this.rollback(savepoint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(Savepoint savepoint, CallerInfo callerInfo) {
        if (savepoint == null) {
            return;
        }
        if (this.sqlConnection == null) {
            return;
        }
        if (this.getAutoCommit()) {
            return;
        }
        int n = -1;
        try {
            n = savepoint.getSavepointId();
            if (!this.usedSavepoints.contains(n)) {
                LogMgr.logWarning(new CallerInfo(){}, "Rollback for non existing savepoint with ID=" + n + " on connection [" + this.id + "] called. Context: " + callerInfo);
            }
            this.logSavepoint(callerInfo, "Rollback", savepoint);
            this.sqlConnection.rollback(savepoint);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error rolling back savepoint (context: " + callerInfo + ") for connection: " + this.id, throwable);
        }
        finally {
            this.usedSavepoints.remove(n);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) {
        this.releaseSavepoint(savepoint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseSavepoint(Savepoint savepoint, CallerInfo callerInfo) {
        if (savepoint == null) {
            return;
        }
        if (this.sqlConnection == null) {
            return;
        }
        if (this.getAutoCommit()) {
            return;
        }
        int n = -1;
        try {
            n = savepoint.getSavepointId();
            if (!this.usedSavepoints.contains(n)) {
                LogMgr.logWarning(new CallerInfo(){}, "Release for non existing savepoint with ID=" + n + " on connection [" + this.id + "] called. Context: " + callerInfo);
            } else {
                this.logSavepoint(callerInfo, "Release", savepoint);
                this.sqlConnection.releaseSavepoint(savepoint);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error releasing savepoint (context: " + callerInfo + ") for connection: " + this.id, throwable);
        }
        finally {
            this.usedSavepoints.remove(n);
        }
    }

    public void rollback() throws SQLException {
        this.rollback((CallerInfo)null);
    }

    public synchronized void rollback(CallerInfo callerInfo) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.getAutoCommit()) {
            return;
        }
        if (!this.getDbSettings().supportsTransactions()) {
            return;
        }
        if (this.logSavepoints) {
            String string = callerInfo == null ? "" : ", context: " + callerInfo;
            LogMgr.logDebug(new CallerInfo(){}, "Rollback all savepoints for connection: " + this.id + string);
            if (!this.usedSavepoints.isEmpty()) {
                LogMgr.logWarning(new CallerInfo(){}, "Rollback called with pending savepoints: " + this.usedSavepoints);
                this.usedSavepoints.clear();
            }
        }
        this.sqlConnection.rollback();
    }

    public void rollbackSilently() {
        this.rollbackSilently(null);
    }

    public void rollbackSilently(CallerInfo callerInfo) {
        try {
            this.rollback(callerInfo);
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not rollback!", exception);
        }
    }

    public boolean getIgnoreDropErrors() {
        if (this.profile != null) {
            return this.profile.getIgnoreDropErrors();
        }
        return false;
    }

    public void toggleAutoCommit() {
        boolean bl = this.getAutoCommit();
        try {
            this.setAutoCommit(!bl);
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when switching autocommit to " + !bl, exception);
        }
    }

    public void changeAutoCommit(boolean bl) {
        try {
            this.setAutoCommit(bl);
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when setting autocommit to " + bl, exception);
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (!this.getDbSettings().supportsTransactions()) {
            return;
        }
        boolean bl2 = this.getAutoCommit();
        if (bl2 != bl) {
            this.usedSavepoints.clear();
            this.sqlConnection.setAutoCommit(bl);
            this.fireConnectionStateChanged(PROP_AUTOCOMMIT, Boolean.toString(bl2), Boolean.toString(bl));
            this.lastAutocommitState = bl;
        }
    }

    public boolean selectStartsTransaction() {
        DbSettings dbSettings = this.getDbSettings();
        if (dbSettings == null) {
            return false;
        }
        return dbSettings.selectStartsTransaction();
    }

    public boolean getAutoCommit() {
        if (this.sqlConnection == null) {
            return false;
        }
        if (!this.getDbSettings().supportsTransactions()) {
            return true;
        }
        if (this.isBusy()) {
            return this.lastAutocommitState;
        }
        try {
            return this.sqlConnection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when retrieving autoCommit attribute", sQLException);
            return false;
        }
    }

    public void disconnect() {
        this.sessionProps.clear();
        ConnectionMgr.getInstance().disconnect(this);
        this.fireConnectionStateChanged(PROP_CONNECTION_STATE, CONNECTION_OPEN, CONNECTION_CLOSED);
        this.pendingEvents.clear();
    }

    public void shutdown() {
        this.sessionProps.clear();
        this.shutdown(true);
    }

    public void shutdownInBackround() {
        WbThread wbThread = new WbThread("DisconnectThread for " + this.getId()){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                WbConnection.this.shutdown(false);
                long l2 = System.currentTimeMillis() - l;
                LogMgr.logInfo(new CallerInfo(){}, "Connection closed after " + l2 + "ms");
            }
        };
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shutdown(boolean bl) {
        if (this.keepAlive != null) {
            this.keepAlive.shutdown();
            this.keepAlive = null;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        if (this.preparedStatementPool != null) {
            this.preparedStatementPool.done();
        }
        if (bl && this.profile != null && this.profile.getRollbackBeforeDisconnect()) {
            try {
                this.rollback();
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(callerInfo, "Error when calling rollback before disconnect", throwable);
            }
        }
        try {
            if (this.metaData != null) {
                this.metaData.close();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Error when releasing metadata", throwable);
        }
        try {
            if (this.sqlConnection != null) {
                this.sqlConnection.close();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Error when closing connection", throwable);
        }
        finally {
            this.sqlConnection = null;
            this.metaData = null;
        }
        this.pendingEvents.clear();
        LogMgr.logDebug(callerInfo, "Connection " + this.getId() + " closed.");
    }

    public boolean isClosed() {
        return this.sqlConnection == null;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n <= 0 ? null : Integer.valueOf(n);
    }

    public int getFetchSize() {
        if (this.fetchSize != null) {
            return this.fetchSize;
        }
        if (this.getProfile() != null) {
            return this.getProfile().getFetchSize();
        }
        return -1;
    }

    public Statement createStatementForQuery() throws SQLException {
        Statement statement = null;
        if (this.getDbSettings().allowsExtendedCreateStatement() && (statement = this.sqlConnection.createStatement(1003, 1007)) == null) {
            LogMgr.logError(new CallerInfo(){}, "Connection.createStatement(int, int) did not create a statement!", new Exception("Backtrace"));
            this.getDbSettings().setUseExtendedCreateStatement(false);
        }
        if (statement == null) {
            statement = this.sqlConnection.createStatement();
        }
        try {
            int n = this.getFetchSize();
            if (n > -1) {
                statement.setFetchSize(n);
            }
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when setting the fetchSize: " + ExceptionUtil.getDisplay(exception));
        }
        return statement;
    }

    public Statement createStatement() throws SQLException {
        Statement statement = this.sqlConnection.createStatement();
        if (Settings.getInstance().getBoolProperty("workbench.sql.fetchsize.always", true)) {
            try {
                int n = this.getFetchSize();
                if (n > -1) {
                    statement.setFetchSize(n);
                }
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Error when setting the fetchSize: " + ExceptionUtil.getDisplay(exception));
            }
        }
        return statement;
    }

    public boolean supportsSavepoints() {
        if (this.sqlConnection == null) {
            return false;
        }
        try {
            return this.sqlConnection.getMetaData().supportsSavepoints();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean useJdbcCommit() {
        return this.metaData.getDbSettings().useJdbcCommit();
    }

    public DbSettings getDbSettings() {
        if (this.metaData == null) {
            return null;
        }
        return this.metaData.getDbSettings();
    }

    public DbMetadata getMetadata() {
        return this.metaData;
    }

    public String getSearchStringEscape() {
        if (this.metaData == null) {
            return "\\";
        }
        return this.metaData.getSearchStringEscape();
    }

    public String getUrl() {
        if (this.switchedUrl != null) {
            return this.switchedUrl;
        }
        if (this.profile != null) {
            return this.profile.getActiveUrl();
        }
        try {
            return this.sqlConnection.getMetaData().getURL();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String toString() {
        return this.getId() + ", " + DbDriver.getUsernameForLogging(this.getDisplayUser()) + "@" + DbDriver.getURLForLogging(this.getUrl());
    }

    public String getDisplayUser() {
        if (this.profile == null) {
            return this.getCurrentUser();
        }
        String string = this.profile.getLoginUser();
        if (StringUtil.isEmptyString(string) && this.isSQLServer()) {
            string = this.getWindowsUser();
        }
        return string;
    }

    private boolean isSQLServer() {
        if (this.metaData != null) {
            return this.metaData.isSqlServer();
        }
        String string = this.getUrl();
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        return string.startsWith("jdbc:sqlserver:");
    }

    public String getDisplayString() {
        return this.getDisplayString(false);
    }

    public String getDisplayString(boolean bl) {
        String string;
        boolean bl2 = this.isBusy();
        if (this.metaData == null) {
            return "";
        }
        try {
            String string2;
            StringBuilder stringBuilder = new StringBuilder(100);
            String string3 = this.getDisplayUser();
            boolean bl3 = false;
            boolean bl4 = false;
            if (StringUtil.isNonBlank(string3)) {
                stringBuilder.append(ResourceMgr.getString("TxtUser"));
                stringBuilder.append('=');
                stringBuilder.append(string3);
                bl3 = true;
            }
            bl4 = this.appendCatalog(stringBuilder, bl3, bl2);
            String string4 = string2 = bl ? this.getDisplaySchema() : null;
            if (string2 == null && !bl2) {
                string2 = this.metaData.getCurrentSchema();
            }
            if (string2 != null) {
                this.currentSchema = string2;
            }
            if (string2 != null && !string2.equalsIgnoreCase(string3) && !this.metaData.ignoreSchema(string2, "<% INVALID %>")) {
                String string5 = this.metaData.getSchemaTerm();
                if (bl3 || bl4) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string5 == null ? "Schema" : StringUtil.capitalize(string5));
                stringBuilder.append('=');
                stringBuilder.append(string2);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("URL=");
            stringBuilder.append(this.getUrl());
            string = stringBuilder.toString();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve connection information", exception);
            string = this.toString();
        }
        return string;
    }

    private boolean appendCatalog(StringBuilder stringBuilder, boolean bl, boolean bl2) {
        String string;
        if (this.metaData.isOracle()) {
            return this.appendOracleContainer(stringBuilder, bl, bl2);
        }
        String string2 = string = bl2 ? this.currentCatalog : this.metaData.getCurrentCatalog();
        if (StringUtil.isBlank(string)) {
            return false;
        }
        String string3 = this.metaData.getCatalogTerm();
        if (bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string3 == null ? "Catalog" : StringUtil.capitalize(string3));
        stringBuilder.append('=');
        stringBuilder.append(string);
        return true;
    }

    private boolean appendOracleContainer(StringBuilder stringBuilder, boolean bl, boolean bl2) {
        if (!OracleUtils.showContainerInfo()) {
            return false;
        }
        if (!this.hasOracleContainers) {
            return false;
        }
        if (bl2) {
            return false;
        }
        if (!JdbcUtils.hasMinimumServerVersion(this, "12.1")) {
            return false;
        }
        String string = OracleUtils.getCurrentContainer(this);
        if (StringUtil.isBlank(string)) {
            return false;
        }
        if (bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("Container=");
        stringBuilder.append(string);
        return true;
    }

    public String getJDBCVersion() {
        try {
            DatabaseMetaData databaseMetaData = this.getSqlConnection().getMetaData();
            int n = databaseMetaData.getJDBCMajorVersion();
            int n2 = databaseMetaData.getJDBCMinorVersion();
            return n + "." + n2;
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error retrieving DB version (" + ExceptionUtil.getDisplay(throwable) + ")");
            return "n/a";
        }
    }

    public String getDatabaseProductVersion() {
        if (this.dbProductVersion == null && !this.isBusy()) {
            try {
                if (this.metaData != null && this.metaData.isSqlServer() && this.getDbSettings().getBoolProperty("useversionfunction", true)) {
                    this.dbProductVersion = SqlServerUtil.getVersion(this);
                } else if (DBID.Greenplum.isDB(this)) {
                    this.dbProductVersion = GreenplumUtil.getDatabaseVersionString(this);
                } else {
                    DatabaseMetaData databaseMetaData = this.getSqlConnection().getMetaData();
                    this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                    if (this.dbProductVersion != null) {
                        Matcher matcher = StringUtil.PATTERN_CRLF.matcher(this.dbProductVersion);
                        this.dbProductVersion = matcher.replaceAll(" ");
                    }
                }
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Error retrieving DB product ersion (" + ExceptionUtil.getDisplay(throwable) + ")");
                this.dbProductVersion = "N/A";
            }
        }
        return this.dbProductVersion;
    }

    private boolean useDatabaseProductVersion(String string) {
        String string2 = this.getUrl();
        if (StringUtil.isEmptyString(string2)) {
            return false;
        }
        if (string == null) {
            string = JdbcUtils.getDbIdFromUrl(string2);
        }
        if (DBID.Greenplum.isDB(string)) {
            return true;
        }
        if (DBID.MySQL.isDB(string)) {
            return true;
        }
        return string2.startsWith("jdbc:postgresql") || string2.startsWith("jdbc:hsqldb");
    }

    public VersionNumber getDatabaseVersion() {
        return this.getDatabaseVersion(this.getDbId());
    }

    protected VersionNumber getDatabaseVersion(String string) {
        if (this.dbVersion == null && !this.isBusy()) {
            try {
                if (this.useDatabaseProductVersion(string)) {
                    String string2 = this.getDatabaseProductVersion();
                    this.dbVersion = new VersionNumber(string2);
                } else {
                    DatabaseMetaData databaseMetaData = this.getSqlConnection().getMetaData();
                    int n = databaseMetaData.getDatabaseMajorVersion();
                    int n2 = databaseMetaData.getDatabaseMinorVersion();
                    this.dbVersion = new VersionNumber(n, n2);
                }
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Error retrieving DB version (" + ExceptionUtil.getDisplay(throwable) + ")");
                this.dbVersion = new VersionNumber(0, 0);
            }
        }
        return this.dbVersion;
    }

    public String getDatabaseProductName() {
        if (this.dbProductName == null && this.metaData != null) {
            this.dbProductName = this.metaData.getProductName();
        }
        return this.dbProductName;
    }

    public String getOutputMessages() {
        if (this.metaData == null) {
            return "";
        }
        return this.metaData.getOutputMessages();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof WbConnection) {
            return this.id.equals(((WbConnection)object).id);
        }
        return false;
    }

    public String getDriverVersion() {
        if (this.driverVersion == null && !this.isBusy()) {
            try {
                DatabaseMetaData databaseMetaData = this.sqlConnection.getMetaData();
                this.driverVersion = databaseMetaData.getDriverVersion();
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving driver version", throwable);
                this.driverVersion = "n/a";
            }
        }
        return this.driverVersion;
    }

    protected boolean getDDLNeedsCommit() {
        if (this.metaData == null) {
            return false;
        }
        return this.metaData.getDbSettings().ddlNeedsCommit();
    }

    public boolean shouldCommitDDL() {
        if (this.getAutoCommit()) {
            return false;
        }
        return this.getDDLNeedsCommit();
    }

    public boolean generateCommitForDDL() {
        GenerateDDLCommit generateDDLCommit;
        boolean bl = this.getDDLNeedsCommit();
        if (!bl) {
            return false;
        }
        GenerateDDLCommit generateDDLCommit2 = generateDDLCommit = this.getDbSettings() == null ? GenerateDDLCommit.whenNeeded : this.getDbSettings().getDDLScriptCommitType();
        if (generateDDLCommit == GenerateDDLCommit.always) {
            return true;
        }
        if (generateDDLCommit == GenerateDDLCommit.never) {
            return false;
        }
        return !this.getAutoCommit();
    }

    public void addChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.listeners.contains(propertyChangeListener)) {
            this.listeners.add(propertyChangeListener);
        }
    }

    public void removeChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    private void firePendingEvents() {
        if (this.pendingEvents.isEmpty()) {
            return;
        }
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>(this.listeners);
        for (PropertyChangeEvent propertyChangeEvent : this.pendingEvents) {
            this.fireEvent(arrayList, propertyChangeEvent);
        }
        this.pendingEvents.clear();
    }

    private void fireConnectionStateChanged(String string, String string2, String string3) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>(this.listeners);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, string2, string3);
        if (this.busy && !string.equals(PROP_BUSY)) {
            this.pendingEvents.add(propertyChangeEvent);
        } else {
            this.fireEvent(arrayList, propertyChangeEvent);
        }
    }

    private void fireEvent(List<PropertyChangeListener> list, PropertyChangeEvent propertyChangeEvent) {
        for (PropertyChangeListener propertyChangeListener : list) {
            if (propertyChangeListener == null) continue;
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public String getCurrentCatalog() {
        return this.metaData.getCurrentCatalog();
    }

    public String getDisplayCatalog() {
        return this.currentCatalog;
    }

    public void catalogListChanged() {
        this.fireConnectionStateChanged(PROP_CATALOG_LIST, null, null);
    }

    public void catalogChanged(String string, String string2) {
        boolean bl = this.currentCatalog != null && !this.currentCatalog.equals(string2);
        this.currentCatalog = string2;
        this.getObjectCache().clear();
        if (bl) {
            this.fireConnectionStateChanged(PROP_CATALOG, string, string2);
        }
    }

    public void containerChanged(String string, String string2) {
        if (this.metaData.isOracle()) {
            this.fireConnectionStateChanged(PROP_CATALOG, string, string2);
        }
    }

    public void schemaChanged(String string, String string2) {
        boolean bl = this.currentSchema != null && !this.currentSchema.equals(string2) || StringUtil.stringsAreNotEqual(string, string2);
        this.currentSchema = string2;
        if (bl) {
            this.fireConnectionStateChanged(PROP_SCHEMA, string, string2);
        }
    }

    private void initKeepAlive() {
        if (this.keepAlive != null) {
            this.keepAlive.shutdown();
            this.keepAlive = null;
        }
        if (this.profile == null) {
            return;
        }
        String string = this.profile.getIdleScript();
        if (StringUtil.isBlank(string)) {
            return;
        }
        long l = this.profile.getIdleTime();
        if (l <= 0L) {
            return;
        }
        this.keepAlive = new KeepAliveDaemon(l, this, string);
        this.keepAlive.startThread();
    }

    public boolean isBusy() {
        return this.busy;
    }

    public boolean setBusy(boolean bl) {
        if (bl == this.busy) {
            return this.busy;
        }
        boolean bl2 = this.busy;
        String string = Boolean.toString(bl2);
        this.busy = bl;
        if (bl && this.keepAlive != null) {
            this.keepAlive.setLastDbAction(System.currentTimeMillis());
        }
        this.fireConnectionStateChanged(PROP_BUSY, string, Boolean.toString(this.busy));
        if (!this.busy) {
            this.firePendingEvents();
        }
        return bl2;
    }

    @Override
    public void executionStart(WbConnection wbConnection, Object object) {
        if (wbConnection == this) {
            this.setBusy(true);
        }
    }

    @Override
    public void executionEnd(WbConnection wbConnection, Object object) {
        if (wbConnection == this) {
            this.setBusy(false);
        }
    }

    public void oracleCancel() {
        Method method;
        if (this.metaData == null) {
            return;
        }
        if (!this.metaData.isOracle()) {
            return;
        }
        try {
            method = this.sqlConnection.getClass().getMethod("cancel", null);
            method.setAccessible(true);
            LogMgr.logDebug(new CallerInfo(){}, "Using OracleConnection.cancel() to cancel the current statement");
            method.invoke((Object)this.sqlConnection, (Object[])null);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not call OracleConnection.cancel()", throwable);
        }
        if (!this.pingAvailable) {
            return;
        }
        try {
            method = this.sqlConnection.getClass().getMethod("pingDatabase", null);
            method.setAccessible(true);
            LogMgr.logDebug(new CallerInfo(){}, "Calling pingDatabase() to clear the communication");
            method.invoke((Object)this.sqlConnection, (Object[])null);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException exception) {
            LogMgr.logDebug(new CallerInfo(){}, "pingDatabase() not available", exception);
            this.pingAvailable = false;
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Could not call OracleConnection.pingDatabase()", throwable);
        }
    }

    public String createFilename() {
        return ConnectionProfile.makeFilename(this.getUrl(), this.getDisplayUser());
    }

    public boolean endReadOnlyTransaction() {
        return this.endReadOnlyTransaction(null);
    }

    public boolean endReadOnlyTransaction(CallerInfo callerInfo) {
        if (this.getAutoCommit()) {
            return true;
        }
        if (this.getDbSettings() == null) {
            return false;
        }
        EndReadOnlyTrans endReadOnlyTrans = EndReadOnlyTrans.never;
        try {
            endReadOnlyTrans = this.getDbSettings().getAutoCloseReadOnlyTransactions();
            if (endReadOnlyTrans == EndReadOnlyTrans.never) {
                return false;
            }
            TransactionChecker transactionChecker = TransactionChecker.Factory.createChecker(this);
            if (transactionChecker == TransactionChecker.NO_CHECK) {
                LogMgr.logWarning(new CallerInfo(){}, "Ending read-only transactions has been configured, but there is no support for checking pending transactions for the current DBMS: " + this.getDatabaseProductName() + " (" + this.getDbId() + ")");
                return false;
            }
            if (!transactionChecker.hasUncommittedChanges(this)) {
                String string = "Sending a " + endReadOnlyTrans.name() + " to end the current transaction";
                if (callerInfo != null) {
                    string = string + " <" + callerInfo + ">";
                }
                LogMgr.logInfo(new CallerInfo(){}, string);
                if (endReadOnlyTrans == EndReadOnlyTrans.commit) {
                    this.commit();
                } else {
                    this.rollbackSilently();
                }
                return true;
            }
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not end transaction using: " + (Object)((Object)endReadOnlyTrans), exception);
        }
        return false;
    }
}

