/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import workbench.db.ConnectionProfile;
import workbench.db.ProfileStorage;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.WbFile;
import workbench.util.WbPersistence;

public class XmlProfileStorage
implements ProfileStorage {
    public static final String DEFAULT_FILE_NAME = "WbProfiles.xml";

    @Override
    public List<ConnectionProfile> readProfiles(WbFile wbFile) {
        Object object;
        Object object2 = null;
        try {
            LogMgr.logDebug(new CallerInfo(){}, "Loading connection profiles from " + wbFile);
            object = new WbPersistence(wbFile.getFullPath());
            object2 = ((WbPersistence)object).readObject();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when reading connection profiles from " + wbFile, exception);
            object2 = null;
        }
        object = new ArrayList();
        if (object2 instanceof Collection) {
            int n = 0;
            Collection collection = (Collection)object2;
            for (Object e : collection) {
                if (e instanceof ConnectionProfile) {
                    object.add((ConnectionProfile)e);
                    continue;
                }
                ++n;
            }
            if (n == collection.size()) {
                LogMgr.logDebug(new CallerInfo(){}, "No connection profiles found in " + wbFile);
                object = null;
            }
        } else if (object2 instanceof Object[]) {
            Object[] objectArray;
            for (Object object3 : objectArray = (Object[])object2) {
                object.add((ConnectionProfile)object3);
            }
        } else {
            LogMgr.logDebug(new CallerInfo(){}, "Input file " + wbFile + " is not a profile storage XML");
            object = null;
        }
        LogMgr.logInfo(new CallerInfo(){}, "Loaded " + object.size() + " connection profiles from " + wbFile);
        return object;
    }

    @Override
    public void saveProfiles(List<ConnectionProfile> list, WbFile wbFile) {
        long l = System.currentTimeMillis();
        WbPersistence wbPersistence = new WbPersistence(wbFile.getFullPath());
        try {
            wbPersistence.writeObject(list);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Error saving profiles to: " + wbFile, iOException);
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Saved " + list.size() + " profiles to " + wbFile + " in " + l2 + "ms");
    }
}

