/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.diff;

import workbench.db.ColumnIdentifier;
import workbench.db.report.ColumnReference;
import workbench.db.report.ReportColumn;
import workbench.db.report.TagWriter;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ColumnDiff {
    public static final String TAG_MODIFY_COLUMN = "modify-column";
    public static final String TAG_DROP_FK = "drop-reference";
    public static final String TAG_ADD_FK = "add-reference";
    public static final String TAG_RENAME_FK = "rename-reference";
    public static final String TAG_CHANGED_ATTRIBUTES = "new-column-attributes";
    private ReportColumn referenceColumn;
    private ReportColumn targetColumn;
    private StringBuilder indent;
    private final TagWriter writer = new TagWriter();
    private boolean compareFK = true;
    private boolean compareComments = true;
    private boolean compareJdbcTypes = false;

    public ColumnDiff(ReportColumn reportColumn, ReportColumn reportColumn2) {
        if (reportColumn == null) {
            throw new NullPointerException("Reference column may not be null");
        }
        if (reportColumn2 == null) {
            throw new NullPointerException("Target column may not be null");
        }
        this.referenceColumn = reportColumn;
        this.targetColumn = reportColumn2;
    }

    public void setCompareForeignKeys(boolean bl) {
        this.compareFK = bl;
    }

    public void setCompareComments(boolean bl) {
        this.compareComments = bl;
    }

    public void setIndent(StringBuilder stringBuilder) {
        this.indent = stringBuilder == null ? StringUtil.emptyBuilder() : stringBuilder;
    }

    private boolean typesAreEqual() {
        ColumnIdentifier columnIdentifier = this.referenceColumn.getColumn();
        ColumnIdentifier columnIdentifier2 = this.targetColumn.getColumn();
        if (this.getCompareJdbcTypes()) {
            int n = columnIdentifier.getDataType();
            int n2 = columnIdentifier2.getDataType();
            if (SqlUtil.isClobType(columnIdentifier2) && SqlUtil.isClobType(columnIdentifier)) {
                return true;
            }
            if (SqlUtil.isBlobType(n2) && SqlUtil.isBlobType(n)) {
                return true;
            }
            if (SqlUtil.isCharacterType(n) && SqlUtil.isCharacterType(n2)) {
                int n3 = columnIdentifier.getColumnSize();
                int n4 = columnIdentifier2.getColumnSize();
                return n4 == n3;
            }
            if (SqlUtil.isIntegerType(n) && SqlUtil.isIntegerType(n2)) {
                return true;
            }
            if (SqlUtil.isNumberType(n) && SqlUtil.isNumberType(n2)) {
                int n5;
                int n6 = columnIdentifier.getDecimalDigits();
                return n6 == (n5 = columnIdentifier2.getDecimalDigits());
            }
            return n == n2;
        }
        return columnIdentifier.getDbmsType().equalsIgnoreCase(columnIdentifier2.getDbmsType());
    }

    public StringBuilder getMigrateTargetXml() {
        ColumnIdentifier columnIdentifier = this.referenceColumn.getColumn();
        ColumnIdentifier columnIdentifier2 = this.targetColumn.getColumn();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder(this.indent);
        stringBuilder2.append("  ");
        boolean bl = !this.typesAreEqual();
        boolean bl2 = columnIdentifier.isNullable() != columnIdentifier2.isNullable();
        String string = columnIdentifier.getDefaultValue();
        String string2 = columnIdentifier2.getDefaultValue();
        boolean bl3 = StringUtil.stringsAreNotEqual(string, string2);
        boolean bl4 = StringUtil.stringsAreNotEqual(columnIdentifier.getComputedColumnExpression(), columnIdentifier2.getComputedColumnExpression());
        ColumnReference columnReference = this.referenceColumn.getForeignKey();
        ColumnReference columnReference2 = this.targetColumn.getForeignKey();
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = StringUtil.stringsAreNotEqual(columnIdentifier.getCollation(), columnIdentifier2.getCollation());
        if (this.compareFK) {
            if (columnReference != null && columnReference2 != null) {
                columnReference.setCompareFKRule(!this.compareJdbcTypes);
                columnReference2.setCompareFKRule(!this.compareJdbcTypes);
                bl5 = !columnReference.isFkDefinitionEqual(columnReference2);
                bl6 = !columnReference.isFkNameEqual(columnReference2);
            } else {
                bl5 = columnReference != null || columnReference2 != null;
            }
        }
        String string3 = columnIdentifier.getComment();
        String string4 = columnIdentifier2.getComment();
        boolean bl8 = false;
        if (this.compareComments) {
            boolean bl9 = bl8 = !StringUtil.equalString(string3, string4);
        }
        if (bl || bl2 || bl3 || bl8 || bl6 || bl5 || bl4 || bl7) {
            CharSequence charSequence;
            this.writer.appendOpenTag(stringBuilder, this.indent, TAG_MODIFY_COLUMN, "name", SqlUtil.removeObjectQuotes(columnIdentifier2.getColumnName()));
            stringBuilder.append('\n');
            if (bl || bl2 || bl3 || bl8 || bl4) {
                this.referenceColumn.appendXml(stringBuilder, stringBuilder2, false, "reference-column-definition", true);
            }
            StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
            stringBuilder3.append("  ");
            this.writer.appendOpenTag(stringBuilder, stringBuilder2, TAG_CHANGED_ATTRIBUTES);
            stringBuilder.append('\n');
            if (bl) {
                String string5;
                this.writer.appendTag(stringBuilder, stringBuilder3, "dbms-data-type", columnIdentifier.getDbmsType());
                this.writer.appendTag(stringBuilder, stringBuilder3, "dbms-data-size", columnIdentifier.getColumnSize());
                if (SqlUtil.isNumberType(columnIdentifier.getDataType())) {
                    this.writer.appendTag(stringBuilder, stringBuilder3, "dbms-data-digits", columnIdentifier.getDigitsDisplay());
                }
                if (!((String)(charSequence = columnIdentifier.getColumnTypeName())).equals(string5 = columnIdentifier2.getColumnTypeName())) {
                    this.writer.appendTag(stringBuilder, stringBuilder3, "java-sql-type-name", columnIdentifier.getColumnTypeName());
                }
                if (this.compareJdbcTypes) {
                    this.writer.appendTag(stringBuilder, stringBuilder3, "java-sql-type", columnIdentifier.getDataType());
                }
            }
            if (bl2) {
                this.writer.appendTag(stringBuilder, stringBuilder3, "nullable", columnIdentifier.isNullable());
            }
            if (bl3) {
                if (StringUtil.isBlank(string)) {
                    this.writer.appendTag(stringBuilder, stringBuilder3, "default-value", "", "remove", "true");
                } else {
                    this.writer.appendTag(stringBuilder, stringBuilder3, "default-value", string);
                }
            }
            if (bl8) {
                if (StringUtil.isBlank(string3)) {
                    this.writer.appendTag(stringBuilder, stringBuilder3, "comment", "", "remove", "true");
                } else {
                    this.writer.appendTag(stringBuilder, stringBuilder3, "comment", string3);
                }
            }
            if (bl4) {
                this.writer.appendTag(stringBuilder, stringBuilder3, "computed-column-expression", columnIdentifier.getComputedColumnExpression());
            }
            if (bl7) {
                this.writer.appendTag(stringBuilder, stringBuilder3, "collation", columnIdentifier.getCollation());
            }
            this.writer.appendCloseTag(stringBuilder, stringBuilder2, TAG_CHANGED_ATTRIBUTES);
            if (bl5) {
                charSequence = new StringBuilder(stringBuilder2);
                ((StringBuilder)charSequence).append("  ");
                if (columnReference == null) {
                    this.writer.appendOpenTag(stringBuilder, stringBuilder2, TAG_DROP_FK);
                    stringBuilder.append('\n');
                    stringBuilder.append((CharSequence)columnReference2.getInnerXml((StringBuilder)charSequence));
                    this.writer.appendCloseTag(stringBuilder, stringBuilder2, TAG_DROP_FK);
                } else {
                    this.writer.appendOpenTag(stringBuilder, stringBuilder2, TAG_ADD_FK);
                    stringBuilder.append('\n');
                    stringBuilder.append((CharSequence)columnReference.getInnerXml((StringBuilder)charSequence));
                    this.writer.appendCloseTag(stringBuilder, stringBuilder2, TAG_ADD_FK);
                }
            } else if (bl6) {
                charSequence = new StringBuilder(stringBuilder2);
                ((StringBuilder)charSequence).append("  ");
                this.writer.appendOpenTag(stringBuilder, stringBuilder2, TAG_RENAME_FK);
                stringBuilder.append('\n');
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append("  <old-name>");
                stringBuilder.append(columnReference2.getFkName());
                stringBuilder.append("</old-name>\n");
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append("  <new-name>");
                stringBuilder.append(columnReference.getFkName());
                stringBuilder.append("</new-name>\n");
                this.writer.appendCloseTag(stringBuilder, stringBuilder2, TAG_RENAME_FK);
            }
            this.writer.appendCloseTag(stringBuilder, this.indent, TAG_MODIFY_COLUMN);
        }
        return stringBuilder;
    }

    public boolean getCompareJdbcTypes() {
        return this.compareJdbcTypes;
    }

    public void setCompareJdbcTypes(boolean bl) {
        this.compareJdbcTypes = bl;
    }
}

