/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import workbench.db.IndexDefinition;
import workbench.db.report.IndexReporter;
import workbench.db.report.TagAttribute;
import workbench.db.report.TagWriter;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class IndexDiff {
    public static final String TAG_MODIFY_INDEX = "modify-index";
    public static final String TAG_RENAME_INDEX = "rename-index";
    public static final String TAG_ADD_INDEX = "add-index";
    public static final String TAG_DROP_INDEX = "drop-index";
    public static final String TAG_FILTER_EXPRESSION = "filter-expression";
    private Collection<IndexDefinition> reference = Collections.emptyList();
    private Collection<IndexDefinition> target = Collections.emptyList();
    private final TagWriter writer = new TagWriter();
    private StringBuilder indent = StringUtil.emptyBuilder();

    public IndexDiff(Collection<IndexDefinition> collection, Collection<IndexDefinition> collection2) {
        if (collection != null) {
            this.reference = collection;
        }
        if (collection2 != null) {
            this.target = collection2;
        }
    }

    public void setIndent(StringBuilder stringBuilder) {
        this.indent = this.indent == null ? StringUtil.emptyBuilder() : stringBuilder;
    }

    public StringBuilder getMigrateTargetXml() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<IndexDefinition> arrayList = new ArrayList<IndexDefinition>();
        ArrayList<IndexDefinition> arrayList2 = new ArrayList<IndexDefinition>();
        StringBuilder stringBuilder2 = new StringBuilder(this.indent);
        stringBuilder2.append("  ");
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        for (IndexDefinition indexDefinition : this.reference) {
            TagAttribute tagAttribute;
            Object object2;
            boolean bl;
            object = this.findIndexInTarget(indexDefinition);
            if (object == null) {
                arrayList.add(indexDefinition);
                continue;
            }
            boolean bl2 = ((IndexDefinition)object).isUnique() != indexDefinition.isUnique();
            boolean bl3 = ((IndexDefinition)object).isPrimaryKeyIndex() != indexDefinition.isPrimaryKeyIndex();
            boolean bl4 = !((IndexDefinition)object).getIndexType().equals(indexDefinition.getIndexType());
            boolean bl5 = !((IndexDefinition)object).getName().equalsIgnoreCase(indexDefinition.getName());
            boolean bl6 = bl = !StringUtil.equalStringOrEmpty(((IndexDefinition)object).getFilterExpression(), indexDefinition.getFilterExpression(), false);
            if (!bl2 && !bl3 && !bl4 && !bl5 && !bl) continue;
            this.writer.appendOpenTag(stringBuilder, stringBuilder2, TAG_MODIFY_INDEX, "name", ((IndexDefinition)object).getName());
            stringBuilder.append('\n');
            IndexReporter indexReporter = new IndexReporter(indexDefinition);
            indexReporter.setMainTagToUse("reference-index");
            indexReporter.appendXml(stringBuilder, stringBuilder3, null);
            StringBuilder stringBuilder4 = new StringBuilder(stringBuilder3);
            stringBuilder4.append("  ");
            this.writer.appendOpenTag(stringBuilder, stringBuilder3, "modified");
            stringBuilder.append('\n');
            if (bl5) {
                object2 = new TagAttribute("oldvalue", ((IndexDefinition)object).getName());
                tagAttribute = new TagAttribute("newvalue", indexDefinition.getName());
                this.writer.appendOpenTag(stringBuilder, stringBuilder4, "name", false, new TagAttribute[]{object2, tagAttribute});
                stringBuilder.append("/>\n");
            }
            if (bl2) {
                object2 = new TagAttribute("oldvalue", Boolean.toString(((IndexDefinition)object).isUnique()));
                tagAttribute = new TagAttribute("newvalue", Boolean.toString(indexDefinition.isUnique()));
                this.writer.appendOpenTag(stringBuilder, stringBuilder4, "unique", false, new TagAttribute[]{object2, tagAttribute});
                stringBuilder.append("/>\n");
            }
            if (bl3) {
                object2 = new TagAttribute("oldvalue", Boolean.toString(((IndexDefinition)object).isPrimaryKeyIndex()));
                tagAttribute = new TagAttribute("newvalue", Boolean.toString(indexDefinition.isPrimaryKeyIndex()));
                this.writer.appendOpenTag(stringBuilder, stringBuilder4, "primary-key", false, new TagAttribute[]{object2, tagAttribute});
                stringBuilder.append("/>\n");
            }
            if (bl4) {
                object2 = new TagAttribute("oldvalue", ((IndexDefinition)object).getIndexType());
                tagAttribute = new TagAttribute("newvalue", indexDefinition.getIndexType());
                this.writer.appendOpenTag(stringBuilder, stringBuilder4, "type", false, new TagAttribute[]{object2, tagAttribute});
                stringBuilder.append("/>\n");
            }
            if (bl) {
                this.writer.appendOpenTag(stringBuilder, stringBuilder4, TAG_FILTER_EXPRESSION);
                stringBuilder.append('\n');
                object2 = new StringBuilder(stringBuilder4);
                ((StringBuilder)object2).append("  ");
                this.writer.appendTag(stringBuilder, (StringBuilder)object2, "target-expression", ((IndexDefinition)object).getFilterExpression());
                this.writer.appendTag(stringBuilder, (StringBuilder)object2, "reference-expression", indexDefinition.getFilterExpression());
                this.writer.appendCloseTag(stringBuilder, stringBuilder4, TAG_FILTER_EXPRESSION);
            }
            this.writer.appendCloseTag(stringBuilder, stringBuilder3, "modified");
            this.writer.appendCloseTag(stringBuilder, stringBuilder2, TAG_MODIFY_INDEX);
        }
        for (IndexDefinition indexDefinition : this.target) {
            object = this.findIndexInReference(indexDefinition);
            if (object != null) continue;
            arrayList2.add(indexDefinition);
        }
        if (arrayList.size() > 0) {
            this.writer.appendOpenTag(stringBuilder, stringBuilder2, TAG_ADD_INDEX);
            stringBuilder.append('\n');
            for (IndexDefinition indexDefinition : arrayList) {
                object = new IndexReporter(indexDefinition);
                ((IndexReporter)object).appendXml(stringBuilder, stringBuilder3, null);
            }
            this.writer.appendCloseTag(stringBuilder, stringBuilder2, TAG_ADD_INDEX);
        }
        if (arrayList2.size() > 0) {
            for (IndexDefinition indexDefinition : arrayList2) {
                this.writer.appendTag(stringBuilder, stringBuilder2, TAG_DROP_INDEX, indexDefinition.getName());
            }
        }
        return stringBuilder;
    }

    private IndexDefinition findIndexInTarget(IndexDefinition indexDefinition) {
        return this.findIndex(this.target, indexDefinition);
    }

    private IndexDefinition findIndexInReference(IndexDefinition indexDefinition) {
        return this.findIndex(this.reference, indexDefinition);
    }

    private IndexDefinition findIndex(Collection<IndexDefinition> collection, IndexDefinition indexDefinition) {
        for (IndexDefinition indexDefinition2 : collection) {
            if (!SqlUtil.objectNamesAreEqual(indexDefinition.getName(), indexDefinition2.getName())) continue;
            return indexDefinition2;
        }
        for (IndexDefinition indexDefinition2 : collection) {
            if (!indexDefinition2.equals(indexDefinition)) continue;
            return indexDefinition2;
        }
        return null;
    }
}

