/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import workbench.db.exporter.FormatFileWriter;
import workbench.db.exporter.WrongFormatFileException;
import workbench.db.ibm.Db2FormatFileWriter;
import workbench.db.mssql.SqlServerFormatFileWriter;
import workbench.db.mysql.MySQLLoadDataWriter;
import workbench.db.oracle.OracleControlFileWriter;
import workbench.db.postgres.PostgresCopyStatementWriter;
import workbench.util.StringUtil;

public enum ControlFileFormat {
    none,
    oracle,
    sqlserver,
    postgres,
    db2,
    mysql;


    public static Set<ControlFileFormat> parseCommandLine(String string) throws WrongFormatFileException {
        if (StringUtil.isEmptyString(string)) {
            return Collections.emptySet();
        }
        EnumSet<ControlFileFormat> enumSet = EnumSet.noneOf(ControlFileFormat.class);
        List<String> list = StringUtil.stringToList(string);
        for (String string2 : list) {
            try {
                ControlFileFormat controlFileFormat = ControlFileFormat.valueOf(string2);
                enumSet.add(controlFileFormat);
            }
            catch (Exception exception) {
                throw new WrongFormatFileException(string2);
            }
        }
        return enumSet;
    }

    public static FormatFileWriter createFormatWriter(ControlFileFormat controlFileFormat) {
        switch (controlFileFormat) {
            case postgres: {
                return new PostgresCopyStatementWriter();
            }
            case oracle: {
                return new OracleControlFileWriter();
            }
            case sqlserver: {
                return new SqlServerFormatFileWriter();
            }
            case db2: {
                return new Db2FormatFileWriter();
            }
            case mysql: {
                return new MySQLLoadDataWriter();
            }
        }
        return null;
    }
}

