/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

class ExcelDataFormat {
    protected String decimalFormat;
    protected String dateFormat;
    protected String timestampFormat;
    protected String integerFormat;
    protected CellStyle headerCellStyle = null;
    protected CellStyle dateCellStyle = null;
    protected CellStyle tsCellStyle = null;
    protected CellStyle decimalCellStyle = null;
    protected CellStyle integerCellStyle = null;
    protected CellStyle textCellStyle = null;
    protected CellStyle multilineCellStyle = null;
    protected short gridDateFormat;
    protected short gridDecimalFormat;
    protected short gridIntegerFormat;
    protected short gridTsFormat;

    ExcelDataFormat(String string, String string2, String string3, String string4) {
        this.decimalFormat = string;
        this.dateFormat = string2;
        this.integerFormat = string3;
        this.timestampFormat = string4;
    }

    protected void setupWithWorkbook(Workbook workbook) {
        CreationHelper creationHelper = workbook.getCreationHelper();
        DataFormat dataFormat = creationHelper.createDataFormat();
        this.setUpHeader(workbook);
        this.setUpText(workbook);
        this.setUpDate(workbook, dataFormat);
        this.setUpDecimal(workbook, dataFormat);
        this.setUpInteger(workbook, dataFormat);
        this.setUpTs(workbook, dataFormat);
        this.setUpMultiline(workbook);
    }

    protected void setUpMultiline(Workbook workbook) {
        this.multilineCellStyle = workbook.createCellStyle();
        this.multilineCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.multilineCellStyle.setWrapText(true);
    }

    protected void setUpText(Workbook workbook) {
        this.textCellStyle = workbook.createCellStyle();
        this.textCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.textCellStyle.setWrapText(false);
    }

    protected void setUpDate(Workbook workbook, DataFormat dataFormat) {
        this.dateCellStyle = workbook.createCellStyle();
        this.dateCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.gridDateFormat = this.getFormat(dataFormat, this.dateFormat);
        this.dateCellStyle.setDataFormat(this.gridDateFormat);
    }

    protected void setUpDecimal(Workbook workbook, DataFormat dataFormat) {
        this.decimalCellStyle = workbook.createCellStyle();
        this.decimalCellStyle.setAlignment(HorizontalAlignment.RIGHT);
        this.gridDecimalFormat = this.getFormat(dataFormat, this.decimalFormat);
        this.decimalCellStyle.setDataFormat(this.gridDecimalFormat);
    }

    protected void setUpInteger(Workbook workbook, DataFormat dataFormat) {
        this.integerCellStyle = workbook.createCellStyle();
        this.integerCellStyle.setAlignment(HorizontalAlignment.RIGHT);
        this.gridIntegerFormat = this.getFormat(dataFormat, this.integerFormat);
        this.integerCellStyle.setDataFormat(this.gridIntegerFormat);
    }

    protected void setUpHeader(Workbook workbook) {
        this.headerCellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setBold(true);
        this.headerCellStyle.setFont(font);
        this.headerCellStyle.setAlignment(HorizontalAlignment.CENTER);
    }

    protected void setUpTs(Workbook workbook, DataFormat dataFormat) {
        this.tsCellStyle = workbook.createCellStyle();
        this.tsCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.gridTsFormat = this.getFormat(dataFormat, this.timestampFormat);
        this.tsCellStyle.setDataFormat(this.gridTsFormat);
    }

    private short getFormat(DataFormat dataFormat, String string) {
        return dataFormat.getFormat(string);
    }
}

