/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.io.File;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.storage.ResultInfo;
import workbench.util.Alias;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ExportJobEntry {
    private WbFile outputFile;
    private String query;
    private TableIdentifier baseTable;
    private ResultInfo resultInfo;

    public ExportJobEntry(File file, String string, String string2, WbConnection wbConnection) {
        this.outputFile = new WbFile(file);
        this.query = string;
        List<Alias> list = SqlUtil.getTables(this.query, false, wbConnection);
        if (list.size() == 1) {
            this.baseTable = new TableIdentifier(list.get(0).getObjectName(), wbConnection);
        }
        this.appendWhere(string2);
    }

    public ExportJobEntry(File file, TableIdentifier tableIdentifier, String string, WbConnection wbConnection) throws SQLException {
        this.resultInfo = new ResultInfo(tableIdentifier, wbConnection);
        this.outputFile = new WbFile(file);
        this.baseTable = this.resultInfo.getUpdateTable();
        TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(wbConnection, "export");
        this.query = tableSelectBuilder.getSelectForColumns(tableIdentifier, Arrays.asList(this.resultInfo.getColumns()), -1);
        this.resultInfo.setUpdateTable(this.baseTable);
        this.appendWhere(string);
    }

    private void appendWhere(String string) {
        if (StringUtil.isNonBlank(string)) {
            if (!string.trim().toLowerCase().startsWith("where")) {
                this.query = this.query + " WHERE";
            }
            this.query = this.query + " ";
            this.query = this.query + SqlUtil.trimSemicolon(string);
        }
    }

    public WbFile getOutputFile() {
        return this.outputFile;
    }

    public ResultInfo getResultInfo() {
        return this.resultInfo;
    }

    public TableIdentifier getTable() {
        if (this.resultInfo != null) {
            return this.resultInfo.getUpdateTable();
        }
        return this.baseTable;
    }

    public String getQuerySql() {
        return this.query;
    }
}

