/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import workbench.db.exporter.RowDataConverter;
import workbench.storage.RowData;
import workbench.util.HtmlUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class HtmlRowDataConverter
extends RowDataConverter {
    private String pageTitle;
    private boolean createFullPage = true;
    private boolean escapeHtml = false;
    private String heading;
    private String trailer;

    @Override
    public StringBuilder getEnd(long l) {
        StringBuilder stringBuilder = new StringBuilder("</table>\n");
        if (StringUtil.isNonBlank(this.trailer)) {
            stringBuilder.append(this.trailer);
            stringBuilder.append('\n');
        }
        if (this.createFullPage) {
            stringBuilder.append("</body>\n</html>\n");
        }
        return stringBuilder;
    }

    public void setHeading(String string) {
        this.heading = string;
    }

    public void setTrailer(String string) {
        this.trailer = string;
    }

    public void setCreateFullPage(boolean bl) {
        this.createFullPage = bl;
    }

    @Override
    public void setPageTitle(String string) {
        this.pageTitle = string;
    }

    public void setEscapeHtml(boolean bl) {
        this.escapeHtml = bl;
    }

    @Override
    public StringBuilder convertRowData(RowData rowData, long l) {
        int n = this.metaData.getColumnCount();
        StringBuilder stringBuilder = new StringBuilder(n * 30);
        stringBuilder.append("  <tr>\n      ");
        for (int i = 0; i < n; ++i) {
            if (!this.includeColumnInExport(i)) continue;
            String string = this.getValueAsFormattedString(rowData, i);
            if (this.createFullPage) {
                int n2 = this.metaData.getColumnType(i);
                if (SqlUtil.isDateType(n2)) {
                    stringBuilder.append("<td class=\"date-cell\">");
                } else if (SqlUtil.isNumberType(n2) || SqlUtil.isDateType(n2)) {
                    stringBuilder.append("<td class=\"number-cell\">");
                } else {
                    stringBuilder.append("<td class=\"text-cell\">");
                }
            } else {
                stringBuilder.append("<td>");
            }
            if (string == null) {
                String string2 = this.getNullDisplay();
                if (string2 != null) {
                    stringBuilder.append(string2);
                } else {
                    stringBuilder.append("&nbsp;");
                }
            } else {
                if (this.escapeHtml) {
                    string = HtmlUtil.escapeHTML(string);
                }
                stringBuilder.append(string);
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("\n  </tr>\n");
        return stringBuilder;
    }

    @Override
    public StringBuilder getStart() {
        StringBuilder stringBuilder = new StringBuilder(250);
        if (this.createFullPage) {
            stringBuilder.append("<html>\n");
            if (this.pageTitle != null && this.pageTitle.length() > 0) {
                stringBuilder.append("<head>\n<title>");
                stringBuilder.append(this.pageTitle);
                stringBuilder.append("</title>\n");
            }
            stringBuilder.append("<style type=\"text/css\">\n");
            stringBuilder.append("<!--\n");
            stringBuilder.append("  table { border-spacing:0; border-collapse:collapse}\n");
            stringBuilder.append("  td, th { font-weight:normal;padding:2; border-style:solid;border-width:1px; vertical-align:top;}\n");
            stringBuilder.append("  .number-cell { text-align:right; white-space:nowrap; } \n");
            stringBuilder.append("  .text-cell { text-align:left; } \n");
            stringBuilder.append("  .date-cell { text-align:left; white-space:nowrap;} \n");
            stringBuilder.append("-->\n</style>\n");
            stringBuilder.append("</head>\n<body>\n");
        }
        if (StringUtil.isNonBlank(this.heading)) {
            stringBuilder.append(this.heading);
            stringBuilder.append('\n');
        }
        stringBuilder.append("<table>\n");
        stringBuilder.append("  <tr>\n");
        for (int i = 0; i < this.metaData.getColumnCount(); ++i) {
            if (!this.includeColumnInExport(i)) continue;
            stringBuilder.append("      <th>");
            stringBuilder.append("<b>");
            stringBuilder.append(this.metaData.getColumnDisplayName(i));
            stringBuilder.append("</b>");
            String string = this.metaData.getColumn(i).getComment();
            if (this.includeColumnComments && StringUtil.isNonBlank(string)) {
                stringBuilder.append("<br/>(");
                stringBuilder.append(string);
                stringBuilder.append(")");
            }
            stringBuilder.append("      </th>\n");
        }
        stringBuilder.append("\n  </tr>\n");
        return stringBuilder;
    }
}

