/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import workbench.db.ColumnIdentifier;
import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.ExportDataModifier;
import workbench.db.exporter.InfinityLiterals;
import workbench.gui.components.BlobHandler;
import workbench.interfaces.DataFileWriter;
import workbench.interfaces.ErrorReporter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.BlobLiteralFormatter;
import workbench.storage.ColumnData;
import workbench.storage.ResultColumnMetaData;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.util.CollectionUtil;
import workbench.util.DefaultOutputFactory;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.NumberStringCache;
import workbench.util.OutputFactory;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbDateFormatter;
import workbench.util.WbFile;
import workbench.util.WbNumberFormatter;
import workbench.util.ZipOutputFactory;

public abstract class RowDataConverter
implements DataFileWriter {
    public static final String BLOB_ARCHIVE_SUFFIX = "_lobs";
    protected String encoding;
    protected WbConnection originalConnection;
    protected String generatingSql;
    protected ResultInfo metaData;
    protected boolean writeHeader = true;
    protected boolean checkPosition;
    private File outputFile;
    private File baseDirectory;
    private String baseFilename;
    private String pageTitle;
    private boolean[] columnsToExport;
    protected List<ColumnIdentifier> exportColumns;
    protected ErrorReporter errorReporter;
    protected String nullString;
    protected SimpleDateFormat defaultTimeFormatter;
    protected WbDateFormatter defaultDateFormatter;
    protected WbNumberFormatter defaultNumberFormatter;
    protected WbNumberFormatter defaultIntegerFormatter;
    protected WbDateFormatter defaultTimestampFormatter;
    protected boolean needsUpdateTable;
    protected OutputFactory factory;
    private boolean compressExternalFiles;
    protected boolean useRowNumForBlobFile = true;
    protected int[] blobNameCols;
    protected List<String> blobIdColumns;
    protected String filenameColumn;
    protected int filenameColumnIndex = -1;
    protected long currentRow = -1L;
    protected RowData currentRowData;
    protected boolean convertDateToTimestamp;
    protected BlobLiteralFormatter blobFormatter;
    protected ExportDataModifier columnModifier;
    protected boolean includeColumnComments;
    protected InfinityLiterals infinityLiterals = InfinityLiterals.PG_LITERALS;
    protected List<String> keyColumnsToUse;
    private long maxBlobFilesPerDir;
    private long blobsWritten;
    private Locale localeToUse;
    protected DataExporter exporter;
    private Map<Integer, Boolean> multilineInfo;
    protected boolean appendInfoSheet;
    protected boolean enableAutoFilter;
    protected boolean fixedHeader;
    protected boolean returnNulls;
    protected Set<String> typesNeedingQuotes = CollectionUtil.caseInsensitiveSet();

    public RowDataConverter() {
        this.defaultDateFormatter = new WbDateFormatter(Settings.getInstance().getDefaultDateFormat());
        this.defaultTimestampFormatter = new WbDateFormatter(Settings.getInstance().getDefaultTimestampFormat());
        this.defaultTimeFormatter = new SimpleDateFormat(Settings.getInstance().getDefaultTimeFormat());
    }

    public void setLocale(Locale locale) {
        this.localeToUse = locale;
    }

    public void setExporter(DataExporter dataExporter) {
        this.exporter = dataExporter;
    }

    public String getNullDisplay() {
        return this.nullString == null ? "" : this.nullString;
    }

    public void setNullString(String string) {
        this.nullString = string;
    }

    public void setDataModifier(ExportDataModifier exportDataModifier) {
        this.columnModifier = exportDataModifier;
    }

    public boolean getEnableFixedHeader() {
        return this.fixedHeader;
    }

    public void setEnableFixedHeader(boolean bl) {
        this.fixedHeader = bl;
    }

    public boolean getEnableAutoFilter() {
        return this.enableAutoFilter;
    }

    public void setEnableAutoFilter(boolean bl) {
        this.enableAutoFilter = bl;
    }

    public boolean getAppendInfoSheet() {
        return this.appendInfoSheet;
    }

    public void setAppendInfoSheet(boolean bl) {
        this.appendInfoSheet = bl;
    }

    public void setInfinityLiterals(InfinityLiterals infinityLiterals) {
        this.infinityLiterals = infinityLiterals;
        this.syncInfinityLiterals();
    }

    private void syncInfinityLiterals() {
        this.defaultDateFormatter.setInfinityLiterals(this.infinityLiterals);
        this.defaultTimestampFormatter.setInfinityLiterals(this.infinityLiterals);
    }

    public void setWriteHeader(boolean bl) {
        this.writeHeader = bl;
    }

    public void setPageTitle(String string) {
        this.pageTitle = string;
    }

    public void setIncludeColumnComments(boolean bl) {
        this.includeColumnComments = bl;
    }

    public void setMaxLobFilesPerDirectory(int n) {
        this.maxBlobFilesPerDir = n;
    }

    public String getPageTitle(String string) {
        if (StringUtil.isEmptyString(this.pageTitle)) {
            return string;
        }
        return this.pageTitle;
    }

    public String getTargetFileDetails() {
        return null;
    }

    protected boolean isMultiline(int n) {
        Boolean bl = this.multilineInfo.get(n);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setResultInfo(ResultInfo resultInfo) {
        int n;
        int n2;
        int n3;
        this.metaData = resultInfo;
        this.useRowNumForBlobFile = true;
        if (this.blobIdColumns != null) {
            n3 = this.blobIdColumns.size();
            n2 = 0;
            this.blobNameCols = new int[n3];
            n = 0;
            for (String string : this.blobIdColumns) {
                int n4;
                this.blobNameCols[n] = n4 = resultInfo.findColumn(string);
                if (n4 > -1) {
                    ++n2;
                }
                ++n;
            }
            if (n2 == 0) {
                this.blobNameCols = null;
                this.useRowNumForBlobFile = true;
            } else {
                this.useRowNumForBlobFile = false;
            }
        }
        n3 = this.metaData.getColumnCount();
        this.multilineInfo = new HashMap<Integer, Boolean>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            n = SqlUtil.isMultiLineColumn(this.metaData.getColumn(n2));
            this.multilineInfo.put(n2, n != 0);
        }
        if (this.filenameColumn != null) {
            this.filenameColumnIndex = resultInfo.findColumn(this.filenameColumn);
        }
        if (this.includeColumnComments) {
            this.retrieveColumnComments();
        }
    }

    public void setFilenameColumn(String string) {
        this.filenameColumn = StringUtil.isBlank(string) ? null : string.trim();
        this.filenameColumnIndex = -1;
    }

    public void retrieveColumnComments() {
        if (StringUtil.isEmptyString(this.generatingSql)) {
            return;
        }
        ResultColumnMetaData resultColumnMetaData = new ResultColumnMetaData(this.generatingSql, this.originalConnection);
        try {
            resultColumnMetaData.retrieveColumnRemarks(this.getResultInfo());
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving column comments", sQLException);
        }
    }

    public ResultInfo getResultInfo() {
        return this.metaData;
    }

    void setBlobIdColumns(List<String> list) {
        this.blobIdColumns = list == null ? null : new ArrayList<String>(list);
    }

    public void setOutputFile(WbFile wbFile) {
        this.baseDirectory = null;
        this.outputFile = wbFile;
        if (wbFile != null && !wbFile.isDirectory()) {
            this.baseFilename = wbFile.getFileName();
        }
        if (this.outputFile != null) {
            if (this.outputFile.isDirectory()) {
                this.baseDirectory = new File(this.outputFile.getAbsolutePath());
            } else if (this.outputFile != null) {
                this.baseDirectory = this.outputFile.getParentFile();
            }
        }
        this.blobsWritten = 0L;
    }

    public void setCompressExternalFiles(boolean bl) {
        this.compressExternalFiles = bl;
    }

    private void initOutputFactory() {
        if (this.compressExternalFiles) {
            WbFile wbFile = new WbFile(this.getOutputFile());
            String string = wbFile.getFileName() + BLOB_ARCHIVE_SUFFIX + ".zip";
            File file = new File(this.getBaseDir(), string);
            this.factory = new ZipOutputFactory(file);
        } else {
            this.factory = new DefaultOutputFactory();
        }
    }

    public void exportFinished() throws IOException {
        if (this.factory != null) {
            this.factory.done();
            this.factory = null;
        }
    }

    protected OutputStream createOutputStream(File file) throws IOException {
        if (this.factory == null) {
            this.initOutputFactory();
        }
        return this.factory.createOutputStream(file);
    }

    @Override
    public File generateDataFileName(ColumnData columnData) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(80);
        if (this.currentRowData != null && this.currentRow != -1L) {
            int n = this.metaData.findColumn(columnData.getIdentifier().getColumnName());
            String string = columnData.getIdentifier().getSourceTableName();
            if (this.baseFilename == null || string != null && !string.equalsIgnoreCase(this.baseFilename)) {
                this.baseFilename = string;
            }
            return this.createBlobFile(this.currentRowData, n, this.currentRow);
        }
        stringBuilder.append(StringUtil.makeFilename(columnData.getIdentifier().getColumnName()));
        stringBuilder.append('_');
        if (this.currentRow == -1L) {
            stringBuilder.append(columnData.getValue().hashCode());
        } else {
            stringBuilder.append("row_");
            stringBuilder.append(this.currentRow);
        }
        stringBuilder.append(this.getFileExtension());
        File file = new File(this.getBlobDir(), stringBuilder.toString());
        return file;
    }

    protected String getFileExtension() {
        return Settings.getInstance().getProperty("workbench.export.default.blob.extension", ".data");
    }

    protected String createFilename(RowData rowData, int n, long l) {
        Object object;
        String string = null;
        if (this.filenameColumnIndex > -1 && (object = rowData.getValue(this.filenameColumnIndex)) != null) {
            string = object.toString();
        }
        return string;
    }

    protected String getBlobFileValue(File file) {
        if (!this.distributeLobFiles()) {
            return file.getName();
        }
        String string = file.getParentFile().getName();
        String string2 = file.getName();
        return string + "/" + string2;
    }

    public File createBlobFile(RowData rowData, int n, long l) throws IOException {
        String string = this.createFilename(rowData, n, l);
        File file = null;
        if (string == null) {
            int n2 = this.baseFilename != null ? this.baseFilename.length() + 25 : 29;
            StringBuilder stringBuilder = new StringBuilder(n2);
            if (this.factory == null) {
                this.initOutputFactory();
            }
            if (!this.factory.isArchive()) {
                stringBuilder.append(this.baseFilename);
                stringBuilder.append('_');
            }
            if (this.useRowNumForBlobFile || this.blobNameCols == null) {
                stringBuilder.append("r");
                stringBuilder.append(l + 1L);
                stringBuilder.append("_c");
                stringBuilder.append(n + 1);
            } else {
                String string2 = this.metaData.getColumnName(n);
                stringBuilder.append(StringUtil.makeFilename(string2));
                stringBuilder.append("_#");
                for (int i = 0; i < this.blobNameCols.length; ++i) {
                    int n3 = this.blobNameCols[i];
                    if (n3 <= -1) continue;
                    Object object = rowData.getValue(n3);
                    if (i > 0) {
                        stringBuilder.append('_');
                    }
                    if (object == null) {
                        stringBuilder.append("col#");
                        stringBuilder.append(i);
                        stringBuilder.append("NULL");
                        continue;
                    }
                    stringBuilder.append(StringUtil.makeFilename(object.toString()));
                }
            }
            stringBuilder.append(this.getFileExtension());
            string = stringBuilder.toString();
        }
        file = new File(this.getBlobDir(), string);
        return file;
    }

    private boolean distributeLobFiles() {
        return this.maxBlobFilesPerDir > 0L && !this.compressExternalFiles;
    }

    private File getBlobDir() throws IOException {
        boolean bl;
        if (!this.distributeLobFiles()) {
            return this.getBaseDir();
        }
        StringBuilder stringBuilder = new StringBuilder(this.baseFilename.length() + 15);
        stringBuilder.append(this.baseFilename);
        stringBuilder.append("_lobs_");
        int n = (int)(this.blobsWritten / this.maxBlobFilesPerDir) + 1;
        stringBuilder.append(StringUtil.formatInt(n, 6));
        WbFile wbFile = new WbFile(this.getBaseDir(), stringBuilder.toString());
        if (!wbFile.exists() && !(bl = wbFile.mkdirs())) {
            String string = "Could not create directory: " + wbFile.getFullPath();
            LogMgr.logError(new CallerInfo(){}, string, null);
            throw new IOException(string);
        }
        return wbFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeClobFile(String string, File file, String string2) throws IOException {
        if (string == null) {
            return;
        }
        Writer writer = null;
        try {
            OutputStream outputStream = this.createOutputStream(file);
            writer = EncodingUtil.createWriter(outputStream, string2);
            ++this.blobsWritten;
            writer.write(string);
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietely(writer);
            throw throwable;
        }
        FileUtil.closeQuietely(writer);
    }

    @Override
    public long writeBlobFile(Object object, File file) throws IOException {
        if (object == null) {
            return -1L;
        }
        long l = 0L;
        try {
            OutputStream outputStream = this.createOutputStream(file);
            l = BlobHandler.saveBlobToFile(object, outputStream);
            ++this.blobsWritten;
            return l;
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Error writing BLOB file: " + file.getName(), iOException);
            throw iOException;
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error writing BLOB file", sQLException);
            throw new IOException(ExceptionUtil.getDisplay(sQLException));
        }
    }

    @Override
    public File getBaseDir() {
        if (this.outputFile == null) {
            return new File(".");
        }
        return this.baseDirectory;
    }

    protected File getOutputFile() {
        return this.outputFile;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public boolean includeColumnInExport(int n) {
        if (n < 0) {
            return false;
        }
        if (this.columnsToExport == null) {
            return true;
        }
        return this.columnsToExport[n];
    }

    public void setOriginalConnection(WbConnection wbConnection) {
        DbSettings dbSettings;
        this.originalConnection = wbConnection;
        this.typesNeedingQuotes.clear();
        if (this.originalConnection != null && (dbSettings = this.originalConnection.getDbSettings()) != null) {
            this.convertDateToTimestamp = dbSettings.getConvertDateInExport();
            this.typesNeedingQuotes.addAll(dbSettings.getExportTypesNeedingQuotes());
        }
    }

    public void setGeneratingSql(String string) {
        this.generatingSql = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void applyDataModifier(RowData rowData, long l) {
        if (this.columnModifier != null) {
            this.columnModifier.modifyData(this, rowData, l);
        }
    }

    public abstract StringBuilder convertRowData(RowData var1, long var2);

    public abstract StringBuilder getStart();

    public abstract StringBuilder getEnd(long var1);

    public boolean needsUpdateTable() {
        return this.needsUpdateTable;
    }

    public void setBlobFormatter(BlobLiteralFormatter blobLiteralFormatter) {
        this.blobFormatter = blobLiteralFormatter;
    }

    public void setDefaultTimestampFormatter(WbDateFormatter wbDateFormatter) {
        if (wbDateFormatter == null) {
            return;
        }
        this.defaultTimestampFormatter = wbDateFormatter;
        this.syncInfinityLiterals();
    }

    public void setDefaultTimeFormatter(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat == null) {
            return;
        }
        this.defaultTimeFormatter = simpleDateFormat;
    }

    public void setDefaultDateFormatter(WbDateFormatter wbDateFormatter) {
        if (wbDateFormatter == null) {
            return;
        }
        this.defaultDateFormatter = wbDateFormatter;
        this.syncInfinityLiterals();
    }

    public void setDefaultNumberFormatter(WbNumberFormatter wbNumberFormatter) {
        this.defaultNumberFormatter = wbNumberFormatter;
    }

    public void setDefaultIntegerFormatter(WbNumberFormatter wbNumberFormatter) {
        this.defaultIntegerFormatter = wbNumberFormatter;
    }

    public void setDefaultDateFormat(String string) {
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        WbDateFormatter wbDateFormatter = new WbDateFormatter(string, this.localeToUse);
        this.setDefaultDateFormatter(wbDateFormatter);
    }

    public void setDefaultTimestampFormat(String string) {
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        WbDateFormatter wbDateFormatter = new WbDateFormatter(string, this.localeToUse);
        this.setDefaultTimestampFormatter(wbDateFormatter);
    }

    public void setDefaultTimeFormat(String string) {
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        SimpleDateFormat simpleDateFormat = this.localeToUse == null ? new SimpleDateFormat(string) : new SimpleDateFormat(string, this.localeToUse);
        this.setDefaultTimeFormatter(simpleDateFormat);
    }

    public void setColumnsToExport(List<ColumnIdentifier> list) {
        if (list == null) {
            this.columnsToExport = null;
            this.exportColumns = null;
            return;
        }
        this.exportColumns = new ArrayList<ColumnIdentifier>(list);
        if (this.metaData == null) {
            LogMgr.logError(new CallerInfo(){}, "MetaData for result is NULL!", new Exception("TraceBack"));
            this.columnsToExport = new boolean[this.exportColumns.size()];
            for (int i = 0; i < this.columnsToExport.length; ++i) {
                this.columnsToExport[i] = true;
            }
            return;
        }
        int n = this.metaData.getColumnCount();
        this.columnsToExport = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.columnsToExport[i] = ColumnIdentifier.containsColumn(list, this.metaData.getColumn(i));
        }
    }

    protected int getRealColumnCount() {
        int n = 0;
        for (int i = 0; i < this.metaData.getColumnCount(); ++i) {
            if (!this.includeColumnInExport(i)) continue;
            ++n;
        }
        return n;
    }

    public String getValueAsFormattedString(RowData rowData, int n) throws IndexOutOfBoundsException {
        Object object = rowData.getValue(n);
        if (object == null) {
            return null;
        }
        String string = null;
        if (this.convertDateToTimestamp && object instanceof java.util.Date && !(object instanceof Timestamp) && !(object instanceof Date)) {
            string = this.defaultTimestampFormatter == null ? StringUtil.getIsoTimestampFormatter().format(object) : this.defaultTimestampFormatter.formatUtilDate((java.util.Date)object);
        } else if (this.defaultTimestampFormatter != null && WbDateFormatter.isTimestampValue(object)) {
            string = this.defaultTimestampFormatter.formatDateTimeValue(object);
        } else if (object instanceof Time && this.defaultTimeFormatter != null) {
            string = this.defaultTimeFormatter.format(object);
        } else if (object instanceof LocalTime && this.defaultTimeFormatter != null) {
            string = this.defaultTimeFormatter.format((LocalTime)object);
        } else if (this.defaultDateFormatter != null && WbDateFormatter.isDateValue(object)) {
            string = this.defaultDateFormatter.formatDateTimeValue(object);
        } else if (object instanceof Number && this.getFormatter(object) != null) {
            WbNumberFormatter wbNumberFormatter = this.getFormatter(object);
            string = wbNumberFormatter.format((Number)object);
        } else {
            if (object instanceof Clob) {
                try {
                    Clob clob = (Clob)object;
                    long l = clob.length();
                    return clob.getSubString(1L, (int)l);
                }
                catch (SQLException sQLException) {
                    return "";
                }
            }
            if (this.blobFormatter != null && (object instanceof Blob || object instanceof byte[] || object instanceof InputStream)) {
                try {
                    string = this.blobFormatter.getBlobLiteral(object).toString();
                }
                catch (SQLException sQLException) {
                    String string2 = "Error creating blob literal";
                    LogMgr.logError(new CallerInfo(){}, string2, sQLException);
                    throw new RuntimeException(string2, sQLException);
                }
            } else {
                string = object.toString();
            }
        }
        return string;
    }

    private WbNumberFormatter getFormatter(Object object) {
        if (object instanceof Integer || object instanceof BigInteger || object instanceof Long || object instanceof Short) {
            return this.defaultIntegerFormatter;
        }
        return this.defaultNumberFormatter;
    }

    protected void writeEscapedXML(StringBuilder stringBuilder, String string) {
        if (string == null) {
            return;
        }
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                stringBuilder.append("&#");
                stringBuilder.append(NumberStringCache.getNumberString(c));
                stringBuilder.append(';');
                continue;
            }
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block5;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
    }

    protected boolean hasOutputFileExtension(String string) {
        File file = this.getOutputFile();
        if (file == null) {
            return false;
        }
        WbFile wbFile = new WbFile(file);
        String string2 = wbFile.getExtension();
        if (StringUtil.isEmptyString(string2)) {
            return false;
        }
        return string2.equalsIgnoreCase(string);
    }

    protected boolean checkKeyColumns() {
        boolean bl = this.metaData.hasPkColumns();
        if (this.keyColumnsToUse != null && this.keyColumnsToUse.size() > 0) {
            this.metaData.resetPkColumns();
            for (String string : this.keyColumnsToUse) {
                this.metaData.setIsPkColumn(string, true);
            }
            bl = true;
        }
        if (!bl) {
            try {
                this.metaData.readPkDefinition(this.originalConnection);
                bl = this.metaData.hasPkColumns();
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Could not read PK columns for update table", sQLException);
            }
        }
        return bl;
    }
}

