/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.db.exporter.RowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataConverter;
import workbench.storage.RowData;
import workbench.storage.reader.RowDataReader;
import workbench.util.CharacterEscapeType;
import workbench.util.CharacterRange;
import workbench.util.QuoteEscapeType;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class TextRowDataConverter
extends RowDataConverter {
    private String delimiter = "\t";
    private String quoteCharacter;
    private boolean quoteAlways;
    private CharacterRange escapeRange = CharacterRange.RANGE_NONE;
    private String delimiterAndQuote;
    private String lineEnding = StringUtil.LINE_TERMINATOR;
    private boolean writeBlobFiles = true;
    private boolean writeClobFiles;
    private boolean quoteWarningAdded;
    private QuoteEscapeType quoteEscape = QuoteEscapeType.none;
    private String rowIndexColumnName;
    private DataConverter converter;
    private CharacterEscapeType escapeType;

    public void setWriteClobToFile(boolean bl) {
        this.writeClobFiles = bl;
    }

    public void setWriteBlobToFile(boolean bl) {
        this.writeBlobFiles = bl;
    }

    @Override
    public void setOriginalConnection(WbConnection wbConnection) {
        super.setOriginalConnection(wbConnection);
        this.converter = RowDataReader.getConverterInstance(wbConnection);
    }

    public void setRowIndexColName(String string) {
        this.rowIndexColumnName = StringUtil.isEmptyString(string) ? null : string;
    }

    @Override
    public StringBuilder getEnd(long l) {
        return null;
    }

    public void setQuoteEscaping(QuoteEscapeType quoteEscapeType) {
        if (quoteEscapeType != null) {
            this.quoteEscape = quoteEscapeType;
        }
    }

    public QuoteEscapeType getQuoteEscaping() {
        return this.quoteEscape;
    }

    @Override
    public StringBuilder convertRowData(RowData rowData, long l) {
        return this.convertRowData(rowData, l, null);
    }

    private boolean isConverted(int n, String string) {
        if (this.converter == null) {
            return false;
        }
        return this.converter.convertsType(n, string);
    }

    /*
     * Unable to fully structure code
     */
    public StringBuilder convertRowData(RowData var1_1, long var2_2, int[] var4_3) {
        var5_4 = this.metaData.getColumnCount();
        var6_5 = new StringBuilder(var5_4 * 30);
        var7_6 = this.quoteCharacter != null;
        var8_7 = this.originalConnection != null ? this.originalConnection.getDbSettings() : null;
        var9_8 = new CallerInfo(){};
        var10_9 = 0;
        if (this.rowIndexColumnName != null) {
            var6_5.append(Long.toString(var2_2 + 1L));
            var6_5.append(this.delimiter);
        }
        for (var11_10 = 0; var11_10 < var5_4; ++var11_10) {
            var12_11 = this.getRealIndex(var11_10, var4_3);
            if (!this.includeColumnInExport(var12_11)) continue;
            if (var10_9 > 0) {
                var6_5.append(this.delimiter);
            }
            var13_12 = this.metaData.getColumnType(var12_11);
            var14_13 = this.metaData.getDbmsTypeName(var12_11);
            var15_14 = null;
            var16_15 = this.quoteAlways;
            var17_16 = false;
            if (this.converter != null) {
                var17_16 = this.isConverted(var13_12, var14_13);
            }
            if (!var17_16 && this.writeBlobFiles && SqlUtil.isBlobType(var13_12)) {
                try {
                    var18_17 = this.createBlobFile(var1_1, var12_11, var2_2);
                    var15_14 = this.getBlobFileValue(var18_17);
                    var19_22 = this.writeBlobFile(var1_1.getValue(var12_11), var18_17);
                    if (var19_22 > 0L) ** GOTO lbl50
                    var15_14 = null;
                }
                catch (Exception var18_18) {
                    LogMgr.logError(var9_8, "Error writing BLOB file", var18_18);
                    throw new RuntimeException("Error writing BLOB file", var18_18);
                }
            } else if (!var17_16 && this.writeClobFiles && this.isClob(var14_13, var13_12, var8_7)) {
                var18_19 = var1_1.getValue(var12_11);
                if (var18_19 != null) {
                    try {
                        var19_23 = this.createBlobFile(var1_1, var12_11, var2_2);
                        var15_14 = this.getBlobFileValue(var19_23);
                        var20_25 = var18_19.toString();
                        this.writeClobFile(var20_25, var19_23, this.encoding);
                    }
                    catch (Exception var19_24) {
                        LogMgr.logError(var9_8, "Error writing CLOB file", var19_24);
                        throw new RuntimeException("Error writing CLOB file", var19_24);
                    }
                }
            } else {
                var15_14 = this.getValueAsFormattedString(var1_1, var12_11);
            }
lbl50:
            // 5 sources

            if (var15_14 == null) {
                var15_14 = this.getNullDisplay();
                var18_20 = this.exporter == null ? false : this.exporter.getQuoteNulls();
                var16_15 = var15_14.isEmpty() != false ? var18_20 : this.quoteAlways;
            } else if (this.needsQuoting(var13_12, var14_13)) {
                var16_15 = this.needsQuotes(var15_14);
                if (this.escapeRange != CharacterRange.RANGE_NONE) {
                    var15_14 = var16_15 != false ? StringUtil.escapeText(var15_14, this.escapeRange, this.quoteCharacter, this.getEscapeType()) : StringUtil.escapeText(var15_14, this.escapeRange, this.delimiterAndQuote, this.getEscapeType());
                }
                if (this.quoteEscape != QuoteEscapeType.none && var7_6 && var15_14.contains(this.quoteCharacter)) {
                    switch (2.$SwitchMap$workbench$util$QuoteEscapeType[this.quoteEscape.ordinal()]) {
                        case 1: {
                            var15_14 = StringUtil.replace(var15_14, this.quoteCharacter, this.quoteCharacter + this.quoteCharacter);
                            break;
                        }
                        case 2: {
                            var15_14 = StringUtil.replace(var15_14, this.quoteCharacter, "\\" + this.quoteCharacter);
                        }
                    }
                }
            }
            if (var16_15 && !var7_6 && !this.quoteWarningAdded) {
                var18_21 = ResourceMgr.getString("ErrExportNoQuoteChar");
                if (this.exporter.getContinueOnError() || !Settings.getInstance().getAbortExportWithMissingQuoteChar()) {
                    this.quoteWarningAdded = true;
                    this.exporter.addWarning(var18_21);
                } else if (Settings.getInstance().getAbortExportWithMissingQuoteChar()) {
                    throw new IllegalStateException(var18_21);
                }
            }
            if (var16_15 && var7_6) {
                var6_5.append(this.quoteCharacter);
            }
            var6_5.append(var15_14);
            if (var16_15 && var7_6) {
                var6_5.append(this.quoteCharacter);
            }
            ++var10_9;
        }
        var6_5.append(this.lineEnding);
        return var6_5;
    }

    private boolean needsQuoting(int n, String string) {
        if (SqlUtil.isCharacterType(n)) {
            return true;
        }
        return this.typesNeedingQuotes.contains(string);
    }

    private boolean isClob(String string, int n, DbSettings dbSettings) {
        boolean bl;
        if (SqlUtil.isClobType(n, string, dbSettings)) {
            return true;
        }
        boolean bl2 = bl = dbSettings != null && dbSettings.exportXMLAsClob();
        return bl && SqlUtil.isXMLType(n, string);
    }

    private boolean needsQuotes(String string) {
        if (this.quoteAlways) {
            return true;
        }
        if (string == null) {
            return false;
        }
        boolean bl = string.contains(this.delimiter);
        boolean bl2 = this.lineEnding != null && string.contains(this.lineEnding);
        return bl || bl2;
    }

    public void setLineEnding(String string) {
        if (string != null) {
            this.lineEnding = string;
        }
    }

    @Override
    public StringBuilder getStart() {
        return this.getStart(null);
    }

    public StringBuilder getStart(int[] nArray) {
        this.setAdditionalEncodeCharacters();
        if (!this.writeHeader) {
            return null;
        }
        boolean bl = this.exporter != null ? this.exporter.getQuoteHeader() : false;
        int n = this.metaData.getColumnCount();
        StringBuilder stringBuilder = new StringBuilder(n * 10);
        boolean bl2 = true;
        if (this.rowIndexColumnName != null) {
            stringBuilder.append(this.rowIndexColumnName);
            bl2 = false;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.getRealIndex(i, nArray);
            if (!this.includeColumnInExport(n2)) continue;
            String string = SqlUtil.removeObjectQuotes(this.metaData.getColumnDisplayName(n2));
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(this.delimiter);
            }
            boolean bl3 = false;
            if (bl) {
                bl3 = this.needsQuotes(string);
            }
            if (bl3) {
                stringBuilder.append(this.quoteCharacter);
            }
            stringBuilder.append(string);
            if (!bl3) continue;
            stringBuilder.append(this.quoteCharacter);
        }
        stringBuilder.append(this.lineEnding);
        return stringBuilder;
    }

    private int getRealIndex(int n, int[] nArray) {
        if (nArray == null) {
            return n;
        }
        if (n >= nArray.length) {
            return -1;
        }
        return nArray[n];
    }

    public void setDelimiter(String string) {
        if (StringUtil.isBlank(string)) {
            return;
        }
        this.delimiter = string.contains("\\t") ? string.replace("\\t", "\t") : string;
        this.setAdditionalEncodeCharacters();
    }

    private void setAdditionalEncodeCharacters() {
        if (this.escapeRange == CharacterRange.RANGE_NONE) {
            return;
        }
        if (this.quoteCharacter == null && this.delimiter == null) {
            return;
        }
        this.delimiterAndQuote = this.delimiter;
        if (this.quoteAlways && this.quoteCharacter == null) {
            this.quoteCharacter = "\"";
        }
        if (this.quoteCharacter != null) {
            this.delimiterAndQuote = this.delimiterAndQuote + this.quoteCharacter;
        }
    }

    public void setQuoteCharacter(String string) {
        if (StringUtil.isNonBlank(string)) {
            this.quoteCharacter = string;
            this.setAdditionalEncodeCharacters();
        }
    }

    public void setQuoteAlways(boolean bl) {
        this.quoteAlways = bl;
    }

    public void setEscapeRange(CharacterRange characterRange) {
        if (characterRange != null) {
            this.escapeRange = characterRange;
        }
    }

    public void setEscapeType(CharacterEscapeType characterEscapeType) {
        this.escapeType = characterEscapeType;
    }

    public CharacterEscapeType getEscapeType() {
        if (this.escapeType == null && this.exporter != null) {
            return this.exporter.getEscapeType();
        }
        return this.escapeType;
    }
}

