/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firebird;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.DbObject;
import workbench.db.DomainIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.gui.dbobjects.objecttree.DbObjectSorter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class FirebirdDependencyReader
implements DependencyReader {
    private final Set<String> supportedTypes = CollectionUtil.caseInsensitiveSet("table", "view");
    private static final String TYPE_CASE = "when 0 then 'TABLE' when 1 then 'VIEW' end as type_name";
    private final String searchUsed = "select distinct rdb$depended_on_name, case rdb$depended_on_type when 0 then 'TABLE' when 1 then 'VIEW' end as type_name \nfrom rdb$dependencies \nwhere rdb$dependent_name = ?";
    private final String searchUsedBy = "select distinct rdb$dependent_name, case rdb$dependent_type when 0 then 'TABLE' when 1 then 'VIEW' end as type_name \nfrom rdb$dependencies\nwhere rdb$depended_on_name = ?";
    private final String usedDomains = "select distinct rdb$field_source, 'DOMAIN'\nfrom rdb$relation_fields\nwhere rdb$relation_name = ?";
    private final String domainUsage = "select distinct rdb$relation_name, 'TABLE'\nfrom rdb$relation_fields\nwhere rdb$field_source = ?";

    @Override
    public List<DbObject> getUsedObjects(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null || wbConnection == null) {
            return Collections.emptyList();
        }
        List<DbObject> list = this.retrieveObjects(wbConnection, dbObject, "select distinct rdb$depended_on_name, case rdb$depended_on_type when 0 then 'TABLE' when 1 then 'VIEW' end as type_name \nfrom rdb$dependencies \nwhere rdb$dependent_name = ?");
        list.addAll(this.retrieveObjects(wbConnection, dbObject, "select distinct rdb$field_source, 'DOMAIN'\nfrom rdb$relation_fields\nwhere rdb$relation_name = ?"));
        DbObjectSorter.sort(list, true);
        return list;
    }

    @Override
    public List<DbObject> getUsedBy(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null || wbConnection == null) {
            return Collections.emptyList();
        }
        List<DbObject> list = this.retrieveObjects(wbConnection, dbObject, "select distinct rdb$dependent_name, case rdb$dependent_type when 0 then 'TABLE' when 1 then 'VIEW' end as type_name \nfrom rdb$dependencies\nwhere rdb$depended_on_name = ?");
        list.addAll(this.retrieveObjects(wbConnection, dbObject, "select distinct rdb$relation_name, 'TABLE'\nfrom rdb$relation_fields\nwhere rdb$field_source = ?"));
        DbObjectSorter.sort(list, true);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DbObject> retrieveObjects(WbConnection wbConnection, DbObject dbObject, String string) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
        String string2 = SqlUtil.replaceParameters(string, dbObject.getObjectName());
        LogMgr.logMetadataSql(new CallerInfo(){}, "dependent objects", string2, new Object[0]);
        Savepoint savepoint = null;
        try {
            wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, dbObject.getObjectName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DbObject dbObject2;
                String string3 = StringUtil.trim(resultSet.getString(1));
                String string4 = resultSet.getString(2);
                if ("DOMAIN".equals(string4)) {
                    dbObject2 = new DomainIdentifier(null, null, string3);
                    arrayList.add(dbObject2);
                    continue;
                }
                dbObject2 = new TableIdentifier(string3);
                ((TableIdentifier)dbObject2).setNeverAdjustCase(true);
                ((TableIdentifier)dbObject2).setType(string4);
                arrayList.add(dbObject2);
            }
            wbConnection.rollback(savepoint);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "dependent objects", string2, exception);
                wbConnection.rollback(savepoint);
            }
            catch (Throwable throwable) {
                wbConnection.rollback(savepoint);
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        DbObjectSorter.sort(arrayList, true, true);
        return arrayList;
    }

    @Override
    public boolean supportsUsedByDependency(String string) {
        return this.supportedTypes.contains(string) || "domain".equalsIgnoreCase(string);
    }

    @Override
    public boolean supportsIsUsingDependency(String string) {
        return this.supportedTypes.contains(string);
    }
}

