/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.h2database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import workbench.db.JdbcUtils;
import workbench.db.SequenceAdjuster;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class H2SequenceAdjuster
implements SequenceAdjuster {
    @Override
    public int adjustTableSequences(WbConnection wbConnection, TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        Map<String, String> map = this.getColumnSequences(wbConnection, tableIdentifier);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.syncSingleSequence(wbConnection, tableIdentifier, entry.getKey(), entry.getValue());
        }
        if (bl && !wbConnection.getAutoCommit()) {
            wbConnection.commit();
        }
        return map.size();
    }

    private void syncSingleSequence(WbConnection wbConnection, TableIdentifier tableIdentifier, String string, String string2) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = null;
        try {
            statement = wbConnection.createStatement();
            long l = -1L;
            resultSet = statement.executeQuery("select max(" + string + ") from " + tableIdentifier.getTableExpression(wbConnection));
            if (resultSet.next()) {
                l = resultSet.getLong(1) + 1L;
                JdbcUtils.closeResult(resultSet);
            }
            if (l > 0L) {
                string3 = "alter sequence " + string2 + " restart with " + Long.toString(l);
                LogMgr.logDebug(new CallerInfo(){}, "Syncing sequence using: " + string3);
                statement.execute(string3);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could adjust sequence using:\n" + string3, sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getColumnSequences(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select column_name,  \n       column_default \nfrom information_schema.columns \nwhere table_name = ? \n and table_schema = ? \n and column_default like '(NEXT VALUE FOR%'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawTableName());
            preparedStatement.setString(2, tableIdentifier.getRawSchema());
            LogMgr.logMetadataSql(new CallerInfo(){}, "column sequences", string, tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                if ((string3 = string3.replace("NEXT VALUE FOR", "")).startsWith("(") && string3.endsWith(")")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                hashMap.put(string2, string3);
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "column sequences", string, tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        return hashMap;
    }
}

