/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.DbMetadata;
import workbench.db.IndexColumn;
import workbench.db.IndexDefinition;
import workbench.db.JdbcIndexReader;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class Db2IndexReader
extends JdbcIndexReader {
    public Db2IndexReader(DbMetadata dbMetadata) {
        super(dbMetadata);
    }

    @Override
    public void processIndexList(Collection<IndexDefinition> collection) {
        if (JdbcUtils.hasMinimumServerVersion(this.metaData.getSqlConnection(), "10.5")) {
            this.readExpressionIndex(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readExpressionIndex(Collection<IndexDefinition> collection) {
        ResultSet resultSet;
        String string = "select indschema, indname, colname, text \nfrom syscat.indexcoluse \nwhere text is not null \n   and (";
        int n = 0;
        for (IndexDefinition object2 : collection) {
            if (!this.mightHaveExpression(object2)) continue;
            if (n > 0) {
                string = string + " or\n        ";
            }
            string = string + " (indschema, indname) = (";
            string = string + "'" + object2.getSchema() + "', '" + object2.getName() + "')";
            ++n;
        }
        string = string + ")\norder by indschema, indname, colseq \nfor read only ";
        if (n == 0) {
            return;
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "index expressions", string, new Object[0]);
        Object object3 = null;
        ResultSet resultSet2 = null;
        try {
            object3 = this.metaData.getWbConnection().createStatementForQuery();
            resultSet = object3.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                String string5 = resultSet.getString(4);
                IndexDefinition indexDefinition = IndexDefinition.findIndex(collection, string3, string2);
                this.updateIndexColumn(indexDefinition, string4, string5);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "index expressions", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet2, object3);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet2, (Statement)object3);
        }
        JdbcUtils.closeAll(resultSet, (Statement)object3);
    }

    private boolean mightHaveExpression(IndexDefinition indexDefinition) {
        String string = this.metaData.getDbSettings().getProperty("expression_index.colname.pattern", null);
        if (string == null) {
            return true;
        }
        try {
            Pattern pattern = Pattern.compile(string);
            for (IndexColumn indexColumn : indexDefinition.getColumns()) {
                Matcher matcher = pattern.matcher(indexColumn.getColumn());
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private void updateIndexColumn(IndexDefinition indexDefinition, String string, String string2) {
        if (indexDefinition == null) {
            return;
        }
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        if (StringUtil.isBlank(string2)) {
            return;
        }
        for (IndexColumn indexColumn : indexDefinition.getColumns()) {
            if (!indexColumn.getColumn().equalsIgnoreCase(string)) continue;
            indexColumn.setColumn(SqlUtil.removeObjectQuotes(string2));
        }
    }

    @Override
    public String getIndexOptions(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        String string;
        String string2 = indexDefinition.getIndexType();
        if ("CLUSTERED".equals(string2)) {
            return " CLUSTER";
        }
        if (!indexDefinition.getSourceOptions().isInitialized()) {
            this.readIndexOptions(tableIdentifier, indexDefinition);
        }
        if ((string = indexDefinition.getSourceOptions().getConfigSettings().get("include_columns")) != null) {
            return " INCLUDE (" + string + ")";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexOptions(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block8: {
            String string = "select colcount, unique_colcount, remarks \nfrom syscat.indexes \nwhere indschema = ? \n  and indname = ? \n  and tabname = ? \n  and tabschema = ? \nfor read only";
            preparedStatement = null;
            resultSet = null;
            LogMgr.logMetadataSql(new CallerInfo(){}, "index information", string, indexDefinition.getSchema(), indexDefinition.getName(), tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
            try {
                preparedStatement = this.metaData.getSqlConnection().prepareStatement(string);
                preparedStatement.setString(1, indexDefinition.getSchema());
                preparedStatement.setString(2, indexDefinition.getName());
                preparedStatement.setString(3, tableIdentifier.getRawTableName());
                preparedStatement.setString(4, tableIdentifier.getRawSchema());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block8;
                int n = resultSet.getInt(1);
                int n2 = resultSet.getInt(2);
                if (n2 > -1 && n2 < n) {
                    int n3;
                    List<IndexColumn> list = indexDefinition.getColumns();
                    String string2 = "";
                    for (n3 = n2; n3 < list.size(); ++n3) {
                        if (n3 > n2) {
                            string2 = string2 + ",";
                        }
                        string2 = string2 + list.get(n3).getColumn();
                    }
                    for (n3 = list.size() - 1; n3 > n2 - 1; --n3) {
                        list.remove(n3);
                    }
                    indexDefinition.getSourceOptions().addConfigSetting("include_columns", string2);
                    indexDefinition.getSourceOptions().setInitialized();
                }
                indexDefinition.setComment(resultSet.getString(3));
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, exception, "index information", string, indexDefinition.getSchema(), indexDefinition.getName(), tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }
}

