/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.io.Serializable;
import java.sql.SQLException;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class Db2Variable
implements DbObject,
Serializable {
    private String catalog;
    private String schema;
    private String variable;
    private String dataType;
    private String defaultValue;
    private int ccsid = -1;
    private String remarks;

    public Db2Variable(String string, String string2, String string3) {
        this.schema = string;
        this.variable = string2;
        this.dataType = string3;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    public void setVariableName(String string) {
        this.variable = string;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getCcsid() {
        return this.ccsid;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public void setCcsid(int n) {
        this.ccsid = n;
    }

    @Override
    public String getObjectType() {
        return "VARIABLE";
    }

    @Override
    public String getObjectName() {
        return this.variable;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return this.variable;
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return SqlUtil.buildExpression(wbConnection, this);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        String string = "CREATE OR REPLACE VARIABLE " + this.getObjectExpression(wbConnection) + " " + this.dataType;
        if (this.ccsid > -1) {
            string = string + " CCSID " + this.ccsid;
        }
        if (StringUtil.isNonBlank(this.defaultValue)) {
            string = string + "\n  DEFAULT " + this.defaultValue;
        }
        string = string + ";";
        return string;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getComment() {
        return this.remarks;
    }

    @Override
    public void setComment(String string) {
        this.remarks = string;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return "DROP VARIABLE " + this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

