/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SynonymReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class InformixSynonymReader
implements SynonymReader {
    @Override
    public List<TableIdentifier> getSynonymList(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        return Collections.emptyList();
    }

    @Override
    public TableIdentifier getSynonymTable(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        TableIdentifier tableIdentifier;
        block5: {
            String string4 = wbConnection.getDbSettings().getProperty("systemschema", "informix");
            TableIdentifier tableIdentifier2 = new TableIdentifier(string, string4, "systables");
            TableIdentifier tableIdentifier3 = new TableIdentifier(string, string4, "syssyntable");
            String string5 = tableIdentifier2.getFullyQualifiedName(wbConnection);
            String string6 = tableIdentifier3.getFullyQualifiedName(wbConnection);
            String string7 = "select bt.owner as table_schema, \n       bt.tabname as table_name \nfrom " + string5 + " syn \n  join " + string6 + " lnk on lnk.tabid = syn.tabid \n  join " + string5 + " bt on bt.tabid = lnk.btabid \nand syn.tabname = ? \nand syn.owner = ?";
            LogMgr.logMetadataSql(new CallerInfo(){}, "synonym table", string7, string3, string2);
            tableIdentifier = null;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = wbConnection.getSqlConnection().prepareStatement(string7);
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                String string8 = null;
                String string9 = null;
                if (!resultSet.next()) break block5;
                string9 = resultSet.getString(1);
                string8 = resultSet.getString(2);
                if (string8 != null) {
                    tableIdentifier = new TableIdentifier(null, string9, string8, false);
                    tableIdentifier.setNeverAdjustCase(true);
                }
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "synonym table", string7, string3, string2);
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return tableIdentifier;
    }
}

