/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.ObjectSourceOptions;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class InformixTableSourceBuilder
extends TableSourceBuilder {
    public InformixTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        ObjectSourceOptions objectSourceOptions;
        if (Settings.getInstance().getBoolProperty("workbench.db.informix_dynamic_server.tablesource.lockmode", true) && !(objectSourceOptions = tableIdentifier.getSourceOptions()).isInitialized()) {
            this.readLockMode(tableIdentifier);
            objectSourceOptions.setInitialized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLockMode(TableIdentifier tableIdentifier) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block16: {
            boolean bl = Settings.getInstance().getBoolProperty("workbench.db.informix_dynamic_server.showextentinfo", true);
            String string = Settings.getInstance().getProperty("workbench.db.informix_dynamic_server.systemschema", "informix");
            TableIdentifier tableIdentifier2 = new TableIdentifier(tableIdentifier.getRawCatalog(), string, "systables");
            String string2 = tableIdentifier2.getFullyQualifiedName(this.dbConnection);
            String string3 = "select locklevel ";
            if (bl) {
                string3 = string3 + ",\n       fextsize, \n       nextsize \n";
            }
            string3 = string3 + "from " + string2 + " \nwhere tabname = ? \n  and owner = ? \n";
            LogMgr.logMetadataSql(new CallerInfo(){}, "lock mode", string3, tableIdentifier.getTableName(), tableIdentifier.getSchema());
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string3);
                preparedStatement.setString(1, tableIdentifier.getRawTableName());
                preparedStatement.setString(2, tableIdentifier.getRawSchema());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block16;
                ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
                String string4 = resultSet.getString(1);
                int n = -1;
                int n2 = -1;
                if (bl) {
                    n = resultSet.getInt(2);
                    if (resultSet.wasNull()) {
                        n = -1;
                    }
                    n2 = resultSet.getInt(3);
                    if (resultSet.wasNull()) {
                        n2 = -1;
                    }
                }
                String string5 = "";
                if (n > -1 && n2 > -1) {
                    tableIdentifier.getSourceOptions().addConfigSetting("extent", Integer.toString(n));
                    tableIdentifier.getSourceOptions().addConfigSetting("next_extent", Integer.toString(n2));
                    string5 = "EXTENT SIZE " + Integer.toString(n) + "\nNEXT SIZE " + Integer.toString(n2);
                }
                if (StringUtil.isNonEmpty(string4)) {
                    switch (string4.charAt(0)) {
                        case 'B': 
                        case 'P': {
                            if (string5.length() > 0) {
                                string5 = string5 + "\n";
                            }
                            string5 = string5 + "LOCK MODE PAGE";
                            tableIdentifier.getSourceOptions().addConfigSetting("lock_mode", "page");
                            break;
                        }
                        case 'R': {
                            if (string5.length() > 0) {
                                string5 = string5 + "\n";
                            }
                            tableIdentifier.getSourceOptions().addConfigSetting("lock_mode", "row");
                            string5 = string5 + "LOCK MODE ROW";
                        }
                    }
                }
                objectSourceOptions.setTableOption(string5);
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, exception, "lock mode", string3, tableIdentifier.getTableName(), tableIdentifier.getSchema());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }
}

