/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.BufferedReader;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObjectFinder;
import workbench.db.TableIdentifier;
import workbench.db.importer.AbstractXmlDataFileParser;
import workbench.db.importer.GenericXMLColumnDetector;
import workbench.db.importer.ImportFileColumn;
import workbench.db.importer.ParsingConverterException;
import workbench.db.importer.ParsingInterruptedException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.MessageBuffer;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class GenericXmlFileParser
extends AbstractXmlDataFileParser {
    private boolean ignoreCurrentRow;
    private StringBuilder chars;
    private String rowTag;
    private boolean attributesAreColumns = true;
    private Map<String, String> columnMap;
    private DefaultHandler handler = new SaxHandler();

    public GenericXmlFileParser() {
    }

    public GenericXmlFileParser(File file) {
    }

    public void setRowAttributeMap(String string, Map<String, String> map) {
        this.rowTag = string;
        this.attributesAreColumns = true;
        this.columnMap = this.createColMap();
        if (map != null) {
            this.columnMap.putAll(map);
        }
    }

    public void setRowAndColumnTags(String string, Map<String, String> map) {
        this.rowTag = string;
        this.attributesAreColumns = false;
        this.columnMap = this.createColMap();
        if (map != null) {
            this.columnMap.putAll(map);
        }
    }

    private Map<String, String> createColMap() {
        return new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
    }

    private List<ColumnIdentifier> getMappedColumns() throws SQLException {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        if (CollectionUtil.isEmpty(this.columnMap)) {
            return arrayList;
        }
        List<ColumnIdentifier> list = this.getTargetTable().getColumns();
        for (String string : this.columnMap.values()) {
            ColumnIdentifier columnIdentifier = ColumnIdentifier.findColumnInList(list, string);
            if (columnIdentifier == null) continue;
            arrayList.add(columnIdentifier);
        }
        return arrayList;
    }

    protected void initializeColumns() throws Exception {
        if (this.importColumns != null) {
            this.checkTargetColumns(this.createTargetTableId());
        } else if (CollectionUtil.isNonEmpty(this.columnMap)) {
            this.setColumns(this.getMappedColumns());
        } else if (this.attributesAreColumns) {
            this.setColumns(this.getColumnsFromFile());
        } else {
            this.setColumns(this.getTargetTable().getColumns());
        }
        if (CollectionUtil.isEmpty(this.columnMap) && CollectionUtil.isNonEmpty(this.importColumns)) {
            this.columnMap = this.createColMap();
            for (ImportFileColumn importFileColumn : this.importColumns) {
                if (importFileColumn.getTargetIndex() <= -1) continue;
                String string = importFileColumn.getColumn().getColumnName();
                this.columnMap.put(string, string);
            }
        }
    }

    protected void checkTargetColumns(TableIdentifier tableIdentifier) throws SQLException {
        if (this.connection == null) {
            return;
        }
        if (tableIdentifier == null) {
            return;
        }
        DbObjectFinder dbObjectFinder = new DbObjectFinder(this.connection);
        if (!dbObjectFinder.tableExists(tableIdentifier)) {
            if (this.receiver.getCreateTarget()) {
                LogMgr.logDebug(new CallerInfo(){}, "Table " + tableIdentifier.getTableName() + " not found, but receiver will create it. Skipping column check...");
                return;
            }
            String string = ResourceMgr.getFormattedString("ErrTargetTableNotFound", tableIdentifier.getTableName());
            this.messages.append(string);
            this.messages.appendNewLine();
            throw new SQLException("Table '" + tableIdentifier.getTableName() + "' not found!");
        }
        List<ColumnIdentifier> list = this.connection.getMetadata().getTableColumns(tableIdentifier);
        List<ImportFileColumn> list2 = ImportFileColumn.createList();
        this.missingColumns.clear();
        int n = 0;
        for (ColumnIdentifier columnIdentifier : this.getTargetColumns()) {
            Object object;
            Object object2;
            int n2 = list.indexOf(columnIdentifier);
            if (n2 != -1) {
                object2 = list.get(n2);
                object = new ImportFileColumn((ColumnIdentifier)object2);
                ((ImportFileColumn)object).setTargetIndex(n);
                list2.add((ImportFileColumn)object);
                ++n;
                continue;
            }
            object2 = columnIdentifier.getColumnName();
            this.missingColumns.add(object2);
            object = ResourceMgr.getFormattedString("ErrImportColumnNotFound", object2, this.getSourceFilename(), tableIdentifier.getTableExpression());
            this.messages.append((CharSequence)object);
            this.messages.appendNewLine();
            if (this.abortOnError) {
                this.hasErrors = true;
                throw new SQLException("Column " + (String)object2 + " not found in target table");
            }
            this.hasWarnings = true;
            LogMgr.logWarning(new CallerInfo(){}, (CharSequence)object);
        }
        this.importColumns = list2;
    }

    @Override
    public List<ColumnIdentifier> getColumnsFromFile() {
        try {
            this.fileHandler.setMainFile(this.inputFile, this.getEncoding());
            GenericXMLColumnDetector genericXMLColumnDetector = new GenericXMLColumnDetector(this.fileHandler.getMainFileReader(), this.rowTag, this.attributesAreColumns);
            List<ColumnIdentifier> list = this.getColumnsFromFile(genericXMLColumnDetector);
            return list;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not detect columns from xml file for row tag <" + this.rowTag + ">", exception);
        }
        finally {
            FileUtil.closeQuietely(this.fileHandler);
        }
        return null;
    }

    private List<ColumnIdentifier> getColumnsFromFile(GenericXMLColumnDetector genericXMLColumnDetector) throws Exception {
        boolean bl = CollectionUtil.isNonEmpty(this.columnMap);
        ArrayList<ColumnIdentifier> arrayList = new ArrayList(0);
        if (!bl) {
            arrayList = this.getTargetTable().getColumns();
        }
        List<String> list = genericXMLColumnDetector.getColumns();
        ArrayList<ColumnIdentifier> arrayList2 = new ArrayList<ColumnIdentifier>(list.size());
        for (String string : list) {
            Object object;
            if (bl) {
                object = this.columnMap.get(string);
                if (StringUtil.isBlank((CharSequence)object)) {
                    arrayList2.add(new ColumnIdentifier(string));
                    continue;
                }
                arrayList2.add(new ColumnIdentifier((String)object));
                continue;
            }
            object = ColumnIdentifier.findColumnInList(arrayList, string);
            if (object != null) {
                arrayList2.add((ColumnIdentifier)object);
            }
            this.columnMap.put(string, ((ColumnIdentifier)object).getColumnName());
        }
        return arrayList2;
    }

    @Override
    public String getEncoding() {
        return StringUtil.isEmptyString(this.encoding) ? "UTF-8" : this.encoding;
    }

    @Override
    protected void processOneFile() throws Exception {
        this.fileHandler.setMainFile(this.inputFile, this.getEncoding());
        this.blobDecoder.setBaseDir(this.inputFile.getParentFile());
        if (!this.sharedMessages) {
            this.messages = new MessageBuffer();
        }
        this.initializeColumns();
        this.sendTableDefinition();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.fileHandler.getMainFileReader();
            InputSource inputSource = new InputSource(bufferedReader);
            this.saxParser.parse(inputSource, this.handler);
            this.filesProcessed.add(this.inputFile);
            this.receiver.tableImportFinished();
        }
        catch (ParsingInterruptedException parsingInterruptedException) {
            if (this.regularStop) {
                this.receiver.tableImportFinished();
            } else {
                this.hasErrors = true;
            }
        }
        catch (ParsingConverterException parsingConverterException) {
            this.receiver.tableImportError();
            this.hasErrors = true;
            throw parsingConverterException;
        }
        catch (Exception exception) {
            String string = "Error during parsing of data row: " + this.currentRowNumber + ", message: " + ExceptionUtil.getDisplay(exception);
            LogMgr.logWarning(new CallerInfo(){}, string);
            this.hasErrors = true;
            this.messages.append(string);
            this.messages.appendNewLine();
            this.receiver.tableImportError();
            throw exception;
        }
        finally {
            FileUtil.closeQuietely(bufferedReader);
        }
    }

    @Override
    protected void resetForFile() {
        super.resetForFile();
        this.ignoreCurrentRow = false;
        this.importColumns = null;
        this.targetTable = null;
    }

    @Override
    protected void clearRowData() {
        super.clearRowData();
        this.chars = null;
    }

    private void buildColumnData(String string, String string2) throws ParsingConverterException {
        int n = this.getColumnIndex(string);
        this.currentRow[n] = null;
        if (!this.receiver.shouldProcessNextRow()) {
            return;
        }
        ColumnIdentifier columnIdentifier = ((ImportFileColumn)this.importColumns.get(n)).getColumn();
        int n2 = columnIdentifier.getDataType();
        if (this.trimValues && !SqlUtil.isBlobType(n2)) {
            string2 = string2.trim();
        }
        if (this.nullString != null && this.nullString.equals(string2)) {
            string2 = null;
        }
        if (this.valueModifier != null) {
            string2 = this.valueModifier.modifyValue(columnIdentifier, string2);
        }
        try {
            this.currentRow[n] = SqlUtil.isBlobType(n2) ? this.blobDecoder.decodeBlob(string2, this.getBlobMode(columnIdentifier.getColumnName())) : this.converter.convertValue(string2, n2);
        }
        catch (Exception exception) {
            String string3 = ResourceMgr.getString("ErrConvertError");
            string3 = StringUtil.replace(string3, "%type%", SqlUtil.getTypeName(columnIdentifier.getDataType()));
            string3 = StringUtil.replace(string3, "%column%", columnIdentifier.getColumnName());
            string3 = StringUtil.replace(string3, "%error%", exception.getMessage());
            string3 = StringUtil.replace(string3, "%value%", string2);
            string3 = StringUtil.replace(string3, "%row%", Integer.toString(this.currentRowNumber));
            this.messages.append(string3);
            this.messages.appendNewLine();
            if (this.abortOnError) {
                LogMgr.logError(new CallerInfo(){}, string3, exception);
                this.hasErrors = true;
                throw new ParsingConverterException();
            }
            this.messages.append(ResourceMgr.getString("ErrConvertWarning"));
            this.hasWarnings = true;
            LogMgr.logWarning(new CallerInfo(){}, string3, null);
        }
    }

    private List<ColumnIdentifier> getTargetColumns() {
        if (this.importColumns == null) {
            return new ArrayList<ColumnIdentifier>();
        }
        return this.importColumns.stream().filter(importFileColumn -> importFileColumn.getTargetIndex() > -1).map(importFileColumn -> importFileColumn.getColumn()).collect(Collectors.toList());
    }

    private void sendTableDefinition() throws SQLException {
        try {
            TableIdentifier tableIdentifier = this.createTargetTableId();
            List<ColumnIdentifier> list = this.getTargetColumns();
            this.receiver.setTargetTable(tableIdentifier, list, this.inputFile);
            this.currentRow = new Object[list.size()];
        }
        catch (SQLException sQLException) {
            this.currentRow = null;
            this.hasErrors = true;
            throw sQLException;
        }
    }

    private void parseAttributes(Attributes attributes) throws ParsingConverterException {
        for (Map.Entry<String, String> entry : this.columnMap.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            String string3 = attributes.getValue(string);
            this.buildColumnData(string2, string3);
        }
    }

    private class SaxHandler
    extends DefaultHandler {
        private SaxHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            Thread.yield();
            if (GenericXmlFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            Thread.yield();
            if (GenericXmlFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Thread.yield();
            if (GenericXmlFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
            if (string3.equals(GenericXmlFileParser.this.rowTag)) {
                GenericXmlFileParser.this.clearRowData();
                if (GenericXmlFileParser.this.attributesAreColumns) {
                    GenericXmlFileParser.this.parseAttributes(attributes);
                }
            } else if (GenericXmlFileParser.this.columnMap.containsKey(string3)) {
                GenericXmlFileParser.this.chars = new StringBuilder();
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (GenericXmlFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
            if (string3.equals(GenericXmlFileParser.this.rowTag)) {
                block9: {
                    if (!GenericXmlFileParser.this.receiver.shouldProcessNextRow()) {
                        GenericXmlFileParser.this.receiver.nextRowSkipped();
                    } else if (!GenericXmlFileParser.this.ignoreCurrentRow) {
                        try {
                            GenericXmlFileParser.this.sendRowData();
                        }
                        catch (Exception exception) {
                            if (!GenericXmlFileParser.this.abortOnError) break block9;
                            throw new ParsingInterruptedException();
                        }
                    }
                }
                GenericXmlFileParser.this.ignoreCurrentRow = false;
                ++GenericXmlFileParser.this.currentRowNumber;
            } else if (GenericXmlFileParser.this.columnMap.containsKey(string3)) {
                GenericXmlFileParser.this.buildColumnData((String)GenericXmlFileParser.this.columnMap.get(string3), GenericXmlFileParser.this.chars.toString());
                GenericXmlFileParser.this.chars = null;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            Thread.yield();
            if (GenericXmlFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
            if (GenericXmlFileParser.this.chars != null) {
                GenericXmlFileParser.this.chars.append(cArray, n, n2);
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            Thread.yield();
            if (GenericXmlFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            Thread.yield();
            if (GenericXmlFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            String string = "XML Parse error in line=" + sAXParseException.getLineNumber() + ", row number: " + GenericXmlFileParser.this.currentRowNumber;
            LogMgr.logError(new CallerInfo(){}, string, sAXParseException);
            GenericXmlFileParser.this.ignoreCurrentRow = true;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            String string = "Fatal XML parse error in line=" + sAXParseException.getLineNumber() + ", row number: " + GenericXmlFileParser.this.currentRowNumber + "\nRest of file will be ignored!";
            LogMgr.logError(new CallerInfo(){}, string, sAXParseException);
            GenericXmlFileParser.this.ignoreCurrentRow = true;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            GenericXmlFileParser.this.messages.append(ExceptionUtil.getDisplay(sAXParseException));
            GenericXmlFileParser.this.messages.appendNewLine();
            if (GenericXmlFileParser.this.cancelImport) {
                throw sAXParseException;
            }
        }
    }
}

