/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import workbench.db.ColumnIdentifier;
import workbench.util.SqlUtil;

public class ImportFileColumn {
    private ColumnIdentifier tableColumn;
    private int targetIndex = -1;
    private int dataWidth = -1;
    private Pattern columnFilter;
    public static final ImportFileColumn SKIP_COLUMN = new ImportFileColumn(new ColumnIdentifier("$wb_skip$"));

    public ImportFileColumn(ColumnIdentifier columnIdentifier) {
        if (columnIdentifier == null) {
            throw new NullPointerException("Column may not be null");
        }
        this.tableColumn = columnIdentifier;
    }

    public ColumnIdentifier getColumn() {
        return this.tableColumn;
    }

    public Pattern getColumnFilter() {
        return this.columnFilter;
    }

    public void setColumnFilter(Pattern pattern) {
        this.columnFilter = pattern;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public void setTargetIndex(int n) {
        this.targetIndex = n;
    }

    public int getDataWidth() {
        return this.dataWidth;
    }

    public void setDataWidth(int n) {
        this.dataWidth = n;
    }

    public boolean equals(Object object) {
        if (object instanceof ImportFileColumn) {
            ImportFileColumn importFileColumn = (ImportFileColumn)object;
            return this.tableColumn.equals(importFileColumn.tableColumn);
        }
        if (object instanceof ColumnIdentifier) {
            return this.tableColumn.equals(object);
        }
        if (object instanceof String) {
            String string = SqlUtil.removeObjectQuotes(this.tableColumn.getColumnName());
            return string.equalsIgnoreCase(SqlUtil.removeObjectQuotes((String)object));
        }
        return false;
    }

    public int hashCode() {
        return this.tableColumn.hashCode();
    }

    public static List<ImportFileColumn> createList() {
        return new ArrayList<ImportFileColumn>(){

            @Override
            public int indexOf(Object object) {
                if (object == null) {
                    return -1;
                }
                int n = this.size();
                for (int i = 0; i < n; ++i) {
                    if (!((ImportFileColumn)this.get(i)).equals(object)) continue;
                    return i;
                }
                return -1;
            }
        };
    }

    public String toString() {
        return this.tableColumn.getColumnName() + "@" + this.targetIndex;
    }
}

