/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.ClipboardFile;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.WbFile;
import workbench.util.ZipUtil;

public class ImportFileHandler
implements Closeable {
    private File baseFile;
    private File baseDir;
    private String encoding;
    private boolean isZip;
    private ZipFile mainArchive;
    private ZipFile attachments;
    private BufferedReader mainReader;
    private String usedZipEntry;

    public void setMainFile(File file, String string) throws IOException {
        this.done();
        this.encoding = string;
        this.baseFile = file;
        this.baseDir = this.baseFile.getParentFile();
        if (this.baseDir == null) {
            this.baseDir = new File(".");
        }
        this.isZip = ZipUtil.isZipFile(this.baseFile);
        this.initAttachements();
    }

    boolean isZip() {
        return this.isZip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BufferedReader getMainFileReader() throws IOException {
        FileUtil.closeQuietely(this.mainReader);
        Reader reader = null;
        if (this.baseFile instanceof ClipboardFile) {
            ClipboardFile clipboardFile = (ClipboardFile)this.baseFile;
            reader = new StringReader(clipboardFile.getContents());
        } else if (this.isZip) {
            Enumeration<? extends ZipEntry> enumeration;
            if (this.mainArchive == null) {
                this.mainArchive = new ZipFile(this.baseFile);
            }
            if (!(enumeration = this.mainArchive.entries()).hasMoreElements()) throw new FileNotFoundException("Zipfile " + this.baseFile.getAbsolutePath() + " does not contain any entries!");
            ZipEntry zipEntry = enumeration.nextElement();
            LogMgr.logInfo(new CallerInfo(){}, "Using ZIP entry " + zipEntry.getName() + " from input file " + this.baseFile.getAbsolutePath());
            this.usedZipEntry = zipEntry.getName();
            InputStream inputStream = this.mainArchive.getInputStream(zipEntry);
            reader = EncodingUtil.createReader(inputStream, this.encoding);
        } else {
            reader = EncodingUtil.createReader(this.baseFile, this.encoding);
        }
        this.mainReader = new BufferedReader(reader, this.getFileBufferSize());
        return this.mainReader;
    }

    public String getInputFilename() {
        if (this.baseFile == null) {
            return "";
        }
        String string = this.baseFile.getAbsolutePath();
        if (this.isZip && this.usedZipEntry != null) {
            string = string + ":" + this.usedZipEntry;
        }
        return string;
    }

    private int getFileBufferSize() {
        return Settings.getInstance().getIntProperty("workbench.import.file.buffsize", 0x100000);
    }

    private void initAttachements() throws IOException {
        if (this.baseFile instanceof ClipboardFile) {
            return;
        }
        WbFile wbFile = new WbFile(this.baseFile);
        String string = wbFile.getFileName();
        String string2 = string + "_lobs" + ".zip";
        File file = new File(this.baseDir, string2);
        if (file.exists()) {
            this.attachments = new ZipFile(file);
        }
    }

    protected ZipEntry findEntry(File file) throws IOException {
        ZipEntry zipEntry = this.attachments.getEntry(file.getName());
        if (zipEntry != null) {
            return zipEntry;
        }
        throw new FileNotFoundException("Attachment file " + file.getName() + " not found in archive " + this.attachments.getName());
    }

    public InputStream getAttachedFileStream(File file) throws IOException {
        if (this.baseFile instanceof ClipboardFile) {
            throw new IOException("Attachments not supported for Clipboard");
        }
        if (this.isZip) {
            ZipEntry zipEntry = this.findEntry(file);
            return this.attachments.getInputStream(zipEntry);
        }
        File file2 = this.getRealFile(file);
        return new BufferedInputStream(new FileInputStream(file2), this.getFileBufferSize());
    }

    private File getRealFile(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        File file2 = file.getParentFile();
        File file3 = null;
        file3 = file2 != null ? new File(this.baseDir, file2.getName()) : this.baseDir;
        File file4 = new File(file3, file.getName());
        return file4;
    }

    public long getCharacterLength(File file) throws IOException {
        if (this.isZip) {
            return this.getLength(file);
        }
        File file2 = this.getRealFile(file);
        return FileUtil.getCharacterLength(file2, this.encoding);
    }

    public long getLength(File file) throws IOException {
        if (this.isZip) {
            ZipEntry zipEntry = this.findEntry(file);
            return zipEntry.getSize();
        }
        File file2 = this.getRealFile(file);
        return file2.length();
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void close() throws IOException {
        this.done();
    }

    public void done() {
        FileUtil.closeQuietely(this.mainReader);
        ZipUtil.closeQuitely(this.mainArchive);
        ZipUtil.closeQuitely(this.attachments);
        this.mainReader = null;
        this.mainArchive = null;
        this.attachments = null;
        this.usedZipEntry = null;
    }
}

