/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import workbench.db.DbObjectFinder;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.TableDependencySorter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.MessageBuffer;

class ImportTableDeleter {
    private RowActionMonitor rowMonitor;
    private boolean checkDependencies = false;
    private WbConnection dbConn;
    private boolean cancel = false;
    private MessageBuffer messages = new MessageBuffer();

    ImportTableDeleter(WbConnection wbConnection, boolean bl) {
        this.dbConn = wbConnection;
        this.checkDependencies = bl;
    }

    private List<TableIdentifier> sortTables(List<TableIdentifier> list) {
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(7);
            this.rowMonitor.setCurrentObject(ResourceMgr.getString("MsgFkDeps"), -1L, -1L);
        }
        TableDependencySorter tableDependencySorter = new TableDependencySorter(this.dbConn);
        List<TableIdentifier> list2 = tableDependencySorter.sortForDelete(list, false);
        if (this.rowMonitor != null) {
            this.rowMonitor.jobFinished();
        }
        return list2;
    }

    MessageBuffer getMessages() {
        return this.messages;
    }

    void cancel() {
        this.cancel = true;
    }

    void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.rowMonitor = rowActionMonitor;
    }

    void deleteRows(List<TableIdentifier> list, boolean bl) throws SQLException {
        if (this.checkDependencies) {
            list = this.sortTables(list);
        }
        boolean bl2 = !this.dbConn.getAutoCommit();
        Statement statement = null;
        try {
            if (this.rowMonitor != null) {
                this.rowMonitor.setMonitorType(8);
            }
            statement = this.dbConn.createStatement();
            int n = 1;
            for (TableIdentifier tableIdentifier : list) {
                if (this.cancel) {
                    if (!bl2) break;
                    this.dbConn.rollbackSilently();
                    break;
                }
                DbObjectFinder dbObjectFinder = new DbObjectFinder(this.dbConn);
                TableIdentifier tableIdentifier2 = dbObjectFinder.findTable(new TableIdentifier(tableIdentifier.getTableName()), false);
                if (this.rowMonitor != null) {
                    this.rowMonitor.setCurrentObject(tableIdentifier2.getTableName(), n, list.size());
                }
                String string = "DELETE FROM " + tableIdentifier2.getTableExpression(this.dbConn);
                LogMgr.logInfo(new CallerInfo(){}, "Running: " + string);
                long l = statement.executeUpdate(string);
                this.messages.append(l + " " + ResourceMgr.getString("MsgImporterRowsDeleted") + " " + tableIdentifier2.getTableExpression(this.dbConn) + "\n");
                if (bl2 && bl) {
                    this.dbConn.commit();
                }
                ++n;
            }
            if (bl2 && !bl) {
                this.dbConn.commit();
            }
        }
        catch (SQLException sQLException) {
            if (bl2) {
                this.dbConn.rollbackSilently();
            }
            throw sQLException;
        }
        finally {
            this.dbConn.setBusy(false);
            JdbcUtils.closeStatement(statement);
            if (this.rowMonitor != null) {
                this.rowMonitor.jobFinished();
            }
        }
    }
}

