/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer.detector;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.QuoteHandler;
import workbench.db.TableIdentifier;
import workbench.db.TypeMapper;
import workbench.db.WbConnection;
import workbench.db.importer.detector.ColType;
import workbench.db.importer.detector.ColumnStatistics;
import workbench.resource.ResourceMgr;
import workbench.sql.formatter.FormatterUtil;
import workbench.sql.syntax.SqlKeywordHelper;
import workbench.util.CollectionUtil;
import workbench.util.MessageBuffer;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.ValueConverter;
import workbench.util.WbFile;

public abstract class TableDetector {
    public static final int DEFAULT_SAMPLE_SIZE = 1000;
    protected List<ColumnStatistics> columns;
    protected WbFile inputFile;
    protected boolean withHeader;
    protected int sampleSize = 1000;
    protected ValueConverter converter;
    protected MessageBuffer messages = new MessageBuffer();
    private SqlKeywordHelper helper;
    private boolean alwaysUseVarchar;
    private String tableName;

    public MessageBuffer getMessages() {
        return this.messages;
    }

    public void setTableName(String string) {
        if (StringUtil.isNonBlank(string)) {
            this.tableName = string.trim();
        }
    }

    public boolean hasMessages() {
        return this.messages.getLength() > 0;
    }

    public void setAlwaysUseVarchar(boolean bl) {
        this.alwaysUseVarchar = bl;
    }

    public void setSampleSize(int n) {
        this.sampleSize = n <= 0 ? Integer.MAX_VALUE : n;
    }

    protected String getDisplayFilename() {
        if (this.inputFile == null) {
            return "";
        }
        return this.inputFile.getName();
    }

    protected String getTableNameToUse() {
        if (StringUtil.isNonBlank(this.tableName)) {
            return this.tableName.trim();
        }
        if (this.inputFile == null) {
            return "import_table";
        }
        return SqlUtil.cleanupIdentifier(this.inputFile.getFileName());
    }

    public String getCreateTable(WbConnection wbConnection) throws SQLException {
        return this.getCreateTable(wbConnection, this.columns);
    }

    public String getCreateTable(WbConnection wbConnection, List<ColumnStatistics> list) throws SQLException {
        return this.getCreateTable(wbConnection, list, this.getTableNameToUse());
    }

    public String getCreateTable(WbConnection wbConnection, List<ColumnStatistics> list, String string) throws SQLException {
        int n;
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        TableIdentifier tableIdentifier = new TableIdentifier(string);
        List<ColumnIdentifier> list2 = this.getDBColumns(list);
        String string2 = FormatterUtil.getKeyword("CREATE TABLE ");
        string2 = string2 + FormatterUtil.getIdentifier(tableIdentifier.getTableExpression(wbConnection));
        string2 = string2 + "\n(\n";
        TypeMapper typeMapper = new TypeMapper(wbConnection);
        String string3 = wbConnection == null ? null : wbConnection.getDbSettings().getUnboundedVarcharType();
        int n2 = Short.MAX_VALUE;
        int n3 = n = wbConnection == null ? n2 : wbConnection.getDbSettings().getMaxVarcharLength();
        if (n < 0) {
            n = n2;
        }
        int n4 = this.getMaxColumNameLength(wbConnection, list2) + 3;
        for (int i = 0; i < list2.size(); ++i) {
            int n5;
            ColumnIdentifier columnIdentifier = list2.get(i);
            int n6 = columnIdentifier.getColumnSize();
            int n7 = n5 = this.alwaysUseVarchar ? 12 : columnIdentifier.getDataType();
            if (SqlUtil.isCharacterType(n5)) {
                if (n6 <= n) {
                    n6 = n;
                } else {
                    n5 = 2005;
                }
            }
            if (i > 0) {
                string2 = string2 + ",\n";
            }
            string2 = string2 + "  " + StringUtil.padRight(this.getColumnName(wbConnection, columnIdentifier), n4);
            String string4 = null;
            string4 = SqlUtil.isCharacterType(n5) && string3 != null ? string3 : typeMapper.getTypeName(n5, n6, columnIdentifier.getDecimalDigits());
            string2 = string2 + FormatterUtil.getDataType(string4);
        }
        string2 = string2 + "\n);";
        return string2;
    }

    public List<ColumnIdentifier> getDBColumns() {
        return this.getDBColumns(this.columns);
    }

    public List<ColumnIdentifier> getDBColumns(List<ColumnStatistics> list) {
        if (CollectionUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(list.size());
        int n = 0;
        for (ColumnStatistics columnStatistics : list) {
            ColType colType = columnStatistics.getBestType();
            String string = FormatterUtil.getIdentifier(columnStatistics.getName());
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(string, colType.getJDBCType());
            columnIdentifier.setPosition(n);
            if (colType == ColType.Integer && columnStatistics.getMaxLength() > 9) {
                columnIdentifier.setDataType(-5);
            }
            columnIdentifier.setColumnSize(columnStatistics.getMaxLength());
            if (colType == ColType.Decimal) {
                columnIdentifier.setDecimalDigits(columnStatistics.getMaxDigits());
            }
            arrayList.add(columnIdentifier);
            ++n;
        }
        return arrayList;
    }

    protected void checkResults(List<ColumnStatistics> list, String string) {
        for (ColumnStatistics columnStatistics : list) {
            String string2;
            List<ColType> list2 = columnStatistics.getDetectedTypes();
            if (list2.isEmpty()) {
                string2 = columnStatistics.getName();
                if (string != null) {
                    string2 = string + "." + string2;
                }
                this.messages.append(ResourceMgr.getFormattedString("MsgImpTblNoType", string2));
                this.messages.appendNewLine();
                continue;
            }
            if (columnStatistics.getDetectedTypes().size() <= 1) continue;
            string2 = "";
            for (int i = 0; i < list2.size(); ++i) {
                if (i > 0) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + list2.get(i).toString();
            }
            this.messages.append(this.getDisplayFilename() + ": " + ResourceMgr.getFormattedString("MsgImpTblMultipleTypes", columnStatistics.getName(), string2));
            this.messages.appendNewLine();
        }
    }

    protected void checkResults() {
        this.checkResults(this.columns, null);
    }

    public void analyzeFile() {
        this.processFile();
        this.checkResults();
    }

    protected abstract void processFile();

    protected void analyzeValues(List<? extends Object> list, List<ColumnStatistics> list2) {
        if (list.size() != list2.size()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if (object == null || object.toString().isEmpty()) continue;
            ColumnStatistics columnStatistics = list2.get(i);
            ColType colType = columnStatistics.getMostFrequentType();
            int n = object.toString().length();
            if (this.alwaysUseVarchar) {
                columnStatistics.addValidType(ColType.String, n, 0);
                continue;
            }
            if (colType == null) {
                this.checkOneValue(object, columnStatistics);
                continue;
            }
            boolean bl = false;
            switch (colType) {
                case Date: {
                    if (!this.isDate(object)) break;
                    columnStatistics.addValidType(colType, 0, 0);
                    bl = true;
                    break;
                }
                case Timestamp: {
                    if (!this.isTimestamp(object)) break;
                    columnStatistics.addValidType(colType, 0, 0);
                    bl = true;
                    break;
                }
                case Integer: {
                    if (!this.isInteger(object)) break;
                    columnStatistics.addValidType(colType, n, 0);
                    bl = true;
                    break;
                }
                case Decimal: {
                    if (!this.isDecimal(object)) break;
                    columnStatistics.addValidType(colType, n, 0);
                    bl = true;
                    break;
                }
                case String: {
                    columnStatistics.addValidType(colType, n, 0);
                    bl = true;
                }
            }
            if (bl) continue;
            this.checkOneValue(object, columnStatistics);
        }
    }

    protected void checkOneValue(Object object, ColumnStatistics columnStatistics) {
        if (object == null) {
            return;
        }
        int n = 0;
        ColType colType = null;
        if (this.alwaysUseVarchar) {
            colType = ColType.String;
        } else {
            colType = this.getType(object);
            if (colType == ColType.Decimal) {
                n = this.getDigits(object);
            }
        }
        columnStatistics.addValidType(colType, object.toString().length(), n);
    }

    protected int getDigits(Object object) {
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return bigDecimal.scale();
        }
        try {
            BigDecimal bigDecimal = this.converter.getBigDecimal(object.toString(), 3);
            return bigDecimal.scale();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected ColType getType(Object object) {
        if (this.isInteger(object)) {
            return ColType.Integer;
        }
        if (this.isDecimal(object)) {
            return ColType.Decimal;
        }
        if (this.isTimestamp(object)) {
            return ColType.Timestamp;
        }
        if (this.isDate(object)) {
            return ColType.Date;
        }
        return ColType.String;
    }

    private boolean isTimestamp(Object object) {
        if (object instanceof Timestamp) {
            return true;
        }
        if (object instanceof java.util.Date) {
            return true;
        }
        try {
            this.converter.parseTimestamp(object.toString());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isDate(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof java.util.Date) {
            return true;
        }
        if (object instanceof Date) {
            return true;
        }
        try {
            this.converter.parseDate(object.toString());
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean isDecimal(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof BigDecimal) {
            return true;
        }
        if (object instanceof Number) {
            return true;
        }
        try {
            this.converter.getBigDecimal(object.toString(), 3);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isInteger(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Integer) {
            return true;
        }
        if (object instanceof Long) {
            return true;
        }
        try {
            this.converter.getLong(object.toString());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getColumnName(WbConnection wbConnection, ColumnIdentifier columnIdentifier) {
        String string;
        QuoteHandler quoteHandler = wbConnection == null ? QuoteHandler.STANDARD_HANDLER : wbConnection.getMetadata();
        if (!quoteHandler.isLegalIdentifier(string = columnIdentifier.getColumnName()) || this.isReservedWord(wbConnection, string)) {
            string = quoteHandler.getIdentifierQuoteCharacter() + string + quoteHandler.getIdentifierQuoteCharacter();
        }
        return FormatterUtil.getIdentifier(string);
    }

    private boolean isReservedWord(WbConnection wbConnection, String string) {
        if (wbConnection == null) {
            return this.getKeyWordHelper().getReservedWords().contains(string);
        }
        return wbConnection.getMetadata().isReservedWord(string);
    }

    private SqlKeywordHelper getKeyWordHelper() {
        if (this.helper == null) {
            this.helper = new SqlKeywordHelper();
        }
        return this.helper;
    }

    private int getMaxColumNameLength(WbConnection wbConnection, List<ColumnIdentifier> list) {
        int n = 0;
        for (ColumnIdentifier columnIdentifier : list) {
            String string = this.getColumnName(wbConnection, columnIdentifier);
            if (string.length() <= n) continue;
            n = string.length();
        }
        return n;
    }
}

