/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.monetdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class MonetDbSequenceReader
implements SequenceReader {
    private WbConnection dbConn;
    private String dbName;
    private String baseQuery = "SELECT sh.name as sequence_schema, \n       sq.name as sequence_name, \n       sq.\"start\", \n       sq.\"minvalue\", \n       sq.\"maxvalue\", \n       sq.\"increment\", \n       sq.\"cycle\", \n       sq.cacheinc \nFROM sys.sequences sq \n  JOIN sys.schemas sh on sh.id = sq.schema_id";

    public MonetDbSequenceReader(WbConnection wbConnection) {
        this.dbConn = wbConnection;
        this.dbName = wbConnection.getCurrentCatalog();
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        CharSequence charSequence = this.getSequenceSource(sequenceDefinition.getCatalog(), sequenceDefinition.getSequenceOwner(), sequenceDefinition.getSequenceName());
        sequenceDefinition.setSource(charSequence);
    }

    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(this.baseQuery.length() + 20);
        stringBuilder.append(this.baseQuery);
        boolean bl = false;
        if (StringUtil.isNonBlank(string3)) {
            bl = true;
            stringBuilder.append(" WHERE ");
            SqlUtil.appendExpression(stringBuilder, "sq.name", StringUtil.trimQuotes(string3), this.dbConn);
        }
        if (StringUtil.isNonBlank(string2)) {
            if (!bl) {
                stringBuilder.append(" WHERE ");
            } else {
                stringBuilder.append(" AND ");
            }
            SqlUtil.appendExpression(stringBuilder, "sh.name", StringUtil.trimQuotes(string2), null);
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequences", stringBuilder, new Object[0]);
        DataStore dataStore = null;
        try {
            dataStore = SqlUtil.getResultData(this.dbConn, stringBuilder.toString(), true);
        }
        catch (Throwable throwable) {
            LogMgr.logMetadataError(new CallerInfo(){}, throwable, "sequences", stringBuilder, new Object[0]);
        }
        return dataStore;
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createSequenceDefinition(dataStore, i));
        }
        return arrayList;
    }

    private SequenceDefinition createSequenceDefinition(DataStore dataStore, int n) {
        SequenceDefinition sequenceDefinition = null;
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        String string = dataStore.getValueAsString(n, "sequence_name");
        String string2 = dataStore.getValueAsString(n, "sequence_schema");
        sequenceDefinition = new SequenceDefinition(string2, string);
        sequenceDefinition.setCatalog(this.dbName);
        sequenceDefinition.setSequenceProperty("START_WITH", dataStore.getValue(n, "start"));
        sequenceDefinition.setSequenceProperty("MAXIMUM_VALUE", dataStore.getValue(n, "maxvalue"));
        sequenceDefinition.setSequenceProperty("MINIMUM_VALUE", dataStore.getValue(n, "minvalue"));
        sequenceDefinition.setSequenceProperty("INCREMENT", dataStore.getValue(n, "increment"));
        sequenceDefinition.setSequenceProperty("CYCLE_OPTION", dataStore.getValue(n, "cycle"));
        sequenceDefinition.setSequenceProperty("DATA_TYPE", "integer");
        sequenceDefinition.setSource(this.buildSource(sequenceDefinition));
        return sequenceDefinition;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return null;
        }
        return this.createSequenceDefinition(dataStore, 0);
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        return this.buildSource(sequenceDefinition);
    }

    protected CharSequence buildSource(SequenceDefinition sequenceDefinition) {
        Boolean bl;
        Number number;
        Number number2;
        Number number3;
        if (sequenceDefinition == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("CREATE SEQUENCE ");
        String string = Settings.getInstance().getInternalEditorLineEnding();
        stringBuilder.append(sequenceDefinition.getSequenceName());
        String string2 = (String)sequenceDefinition.getSequenceProperty("DATA_TYPE");
        if (!"INTEGER".equals(string2)) {
            stringBuilder.append(" AS ");
            stringBuilder.append(string2);
        }
        if ((number3 = (Number)sequenceDefinition.getSequenceProperty("START_WITH")) != null && number3.longValue() > 1L) {
            stringBuilder.append(string);
            stringBuilder.append("       START WITH ");
            stringBuilder.append(number3);
        }
        if ((number2 = (Number)sequenceDefinition.getSequenceProperty("INCREMENT")) != null && number2.longValue() != 1L) {
            stringBuilder.append(string);
            stringBuilder.append("       INCREMENT BY ");
            stringBuilder.append(number2);
        }
        if ((number = (Number)sequenceDefinition.getSequenceProperty("CACHE")) != null && number.longValue() > 0L) {
            stringBuilder.append(string);
            stringBuilder.append("       CACHE ");
            stringBuilder.append(number.toString());
        }
        if ((bl = (Boolean)sequenceDefinition.getSequenceProperty("CYCLE")) != null && bl.booleanValue()) {
            stringBuilder.append(string);
            stringBuilder.append("       CYCLE");
        }
        stringBuilder.append(string);
        stringBuilder.append(';');
        stringBuilder.append(string);
        return stringBuilder;
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

