/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.io.Serializable;
import java.sql.SQLException;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.db.mssql.SpHelpTextRunner;
import workbench.util.SqlUtil;

public class NamedDefault
implements DbObject,
Serializable {
    private String database;
    private String schema;
    private String constraintName;
    private String definition;

    public NamedDefault(String string, String string2, String string3) {
        this.database = string;
        this.schema = string2;
        this.constraintName = string3;
    }

    @Override
    public String getCatalog() {
        return this.database;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getObjectType() {
        return "DEFAULT";
    }

    @Override
    public String getObjectName() {
        return this.constraintName;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return this.constraintName;
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return SqlUtil.buildExpression(wbConnection, this.database, this.schema, this.constraintName);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        NamedDefault namedDefault = this;
        synchronized (namedDefault) {
            if (this.definition == null) {
                this.readSource(wbConnection);
            }
            return this.definition;
        }
    }

    private void readSource(WbConnection wbConnection) {
        SpHelpTextRunner spHelpTextRunner = new SpHelpTextRunner();
        CharSequence charSequence = spHelpTextRunner.getSource(wbConnection, this.database, this.schema, this.constraintName);
        if (charSequence != null) {
            this.definition = SqlUtil.addSemicolon(charSequence.toString());
        }
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public void setComment(String string) {
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return "DROP DEFAULT " + this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

