/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.SQLException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import workbench.db.DbObject;
import workbench.db.WbConnection;

public class PartitionScheme
implements DbObject {
    public static final String TYPE_NAME = "PARTITION SCHEME";
    private String catalog;
    private String name;
    private String function;
    private SortedSet<String> fileGroups = new TreeSet<String>();

    public PartitionScheme() {
    }

    public PartitionScheme(String string, String string2) {
        this.name = string;
        this.function = string2;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public String getObjectType() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectName() {
        return this.getName();
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        if (wbConnection == null) {
            return this.getName();
        }
        return wbConnection.getMetadata().quoteObjectname(this.name);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.getName();
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.getObjectName(wbConnection);
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return this.getSource();
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getName();
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public void setComment(String string) {
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String getFunctionName() {
        return this.function;
    }

    public void setFunctionName(String string) {
        this.function = string;
    }

    public void addFileGroup(String string) {
        if (string.equalsIgnoreCase("primary")) {
            string = "[PRIMARY]";
        }
        this.fileGroups.add(string);
    }

    public SortedSet<String> getFileGroups() {
        return this.fileGroups;
    }

    public String getGroupString() {
        return this.fileGroups.stream().collect(Collectors.joining(","));
    }

    public String getSource() {
        String string = "CREATE PARTITION SCHEME " + this.name + "\n  AS PARTITION " + this.function + "\n";
        if (this.fileGroups.size() == 1) {
            string = string + "  ALL";
        }
        string = string + " TO (" + this.getGroupString() + ");";
        return string;
    }
}

