/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import workbench.db.AbstractConstraintReader;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerUtil;

public class SqlServerConstraintReader
extends AbstractConstraintReader {
    private boolean is2000;
    private final String OLD_TABLE_SQL = "select cons.name, c.text \nfrom sysobjects cons, \n     syscomments c, \n     sysobjects tab \nwhere cons.xtype = 'C' \nand   cons.id = c.id \nand   cons.parent_obj = tab.id \nand   tab.name = ? \n";
    private final String TABLE_SQL = "select cons.name, cons.definition \nfrom sys.check_constraints cons with (nolock) \n  join sys.tables tab with (nolock) on cons.parent_object_id = tab.object_id \n  join sys.schemas s with (nolock) on s.schema_id = tab.schema_id \nwhere tab.name = ?  \n  and s.name = ?";
    private final String DEFAULT_CONSTRAINTS_SQL = "select col.name, \n       case  \n          when is_system_named = 1 then 'DEFAULT ' + cons.definition \n          else 'CONSTRAINT ' + cons.name + ' DEFAULT ' + cons.definition \n       end as value \nfrom sys.default_constraints cons with (nolock) \n  join sys.columns col with (nolock) on cons.object_id = col.default_object_id and cons.parent_column_id = col.column_id \n  join sys.tables tab with (nolock) on cons.parent_object_id = tab.object_id \n  join sys.schemas s with (nolock) on s.schema_id = tab.schema_id \nwhere cons.type = 'D' \n  and tab.name = ? \n  and s.name = ? ";

    public SqlServerConstraintReader(WbConnection wbConnection) {
        super(wbConnection.getDbId());
        if (!SqlServerUtil.isSqlServer2005(wbConnection)) {
            this.is2000 = true;
        }
    }

    @Override
    public String getColumnConstraintSql() {
        if (this.is2000) {
            return null;
        }
        return "select col.name, \n       case  \n          when is_system_named = 1 then 'DEFAULT ' + cons.definition \n          else 'CONSTRAINT ' + cons.name + ' DEFAULT ' + cons.definition \n       end as value \nfrom sys.default_constraints cons with (nolock) \n  join sys.columns col with (nolock) on cons.object_id = col.default_object_id and cons.parent_column_id = col.column_id \n  join sys.tables tab with (nolock) on cons.parent_object_id = tab.object_id \n  join sys.schemas s with (nolock) on s.schema_id = tab.schema_id \nwhere cons.type = 'D' \n  and tab.name = ? \n  and s.name = ? ";
    }

    @Override
    public String getTableConstraintSql() {
        if (this.is2000) {
            return "select cons.name, c.text \nfrom sysobjects cons, \n     syscomments c, \n     sysobjects tab \nwhere cons.xtype = 'C' \nand   cons.id = c.id \nand   cons.parent_obj = tab.id \nand   tab.name = ? \n";
        }
        return "select cons.name, cons.definition \nfrom sys.check_constraints cons with (nolock) \n  join sys.tables tab with (nolock) on cons.parent_object_id = tab.object_id \n  join sys.schemas s with (nolock) on s.schema_id = tab.schema_id \nwhere tab.name = ?  \n  and s.name = ?";
    }

    @Override
    public int getIndexForTableNameParameter() {
        return 1;
    }

    @Override
    public int getIndexForSchemaParameter() {
        if (this.is2000) {
            return -1;
        }
        return 2;
    }
}

