/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.CatalogChanger;
import workbench.db.DbObject;
import workbench.db.DomainIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.ProcedureDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TriggerDefinition;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.db.mssql.NamedDefault;
import workbench.db.mssql.PartitionFunction;
import workbench.db.mssql.SqlServerPartitionReader;
import workbench.db.mssql.SqlServerUtil;
import workbench.gui.dbobjects.objecttree.DbObjectSorter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class SqlServerDependencyReader
implements DependencyReader {
    private final Set<String> supportedTypes = CollectionUtil.caseInsensitiveSet("table", "view", "procedure", "function", "trigger");
    private final String typeDesc = "       case ao.type_desc \n          when 'USER_TABLE' then 'TABLE'\n          when 'SYSTEM_TABLE' then 'SYSTEM TABLE'\n          when 'INTERNAL_TABLE' then 'SYSTEM TABLE'\n          when 'SQL_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'CLR_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'EXTENDED_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'SQL_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'CLR_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'SQL_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_INLINE_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_TRIGGER' then 'TRIGGER'\n          when 'CLR_TRIGGER' then 'TRIGGER'\n          else type_desc \n        end as type";
    private final String searchUsedByInfSchema = "SELECT vtu.TABLE_CATALOG, vtu.TABLE_SCHEMA, vtu.TABLE_NAME,\n       case ao.type_desc \n          when 'USER_TABLE' then 'TABLE'\n          when 'SYSTEM_TABLE' then 'SYSTEM TABLE'\n          when 'INTERNAL_TABLE' then 'SYSTEM TABLE'\n          when 'SQL_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'CLR_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'EXTENDED_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'SQL_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'CLR_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'SQL_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_INLINE_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_TRIGGER' then 'TRIGGER'\n          when 'CLR_TRIGGER' then 'TRIGGER'\n          else type_desc \n        end as type\nFROM INFORMATION_SCHEMA.VIEW_TABLE_USAGE vtu \n  JOIN sys.all_objects ao ON ao.name = vtu.TABLE_NAME and schema_name(ao.schema_id) = vtu.TABLE_SCHEMA\nWHERE VIEW_CATALOG = ? \n  AND VIEW_SCHEMA = ? \n  AND VIEW_NAME = ?";
    private final String searchUsedSqlInfSchema = "SELECT vtu.VIEW_CATALOG, vtu.VIEW_SCHEMA, vtu.VIEW_NAME,\n       case ao.type_desc \n          when 'USER_TABLE' then 'TABLE'\n          when 'SYSTEM_TABLE' then 'SYSTEM TABLE'\n          when 'INTERNAL_TABLE' then 'SYSTEM TABLE'\n          when 'SQL_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'CLR_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'EXTENDED_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'SQL_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'CLR_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'SQL_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_INLINE_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_TRIGGER' then 'TRIGGER'\n          when 'CLR_TRIGGER' then 'TRIGGER'\n          else type_desc \n        end as type\nFROM INFORMATION_SCHEMA.VIEW_TABLE_USAGE vtu \n  JOIN sys.all_objects ao ON ao.name = vtu.VIEW_NAME and schema_name(ao.schema_id) = vtu.VIEW_SCHEMA\nWHERE TABLE_CATALOG = ? \n  AND TABLE_SCHEMA = ? \n  AND TABLE_NAME = ?";
    private final String searchUsedByDMView = "SELECT distinct db_name() as catalog_name,  \n       coalesce(re.referenced_schema_name, schema_name()) as schema_name,  \n       re.referenced_entity_name,  \n       case ao.type_desc \n          when 'USER_TABLE' then 'TABLE'\n          when 'SYSTEM_TABLE' then 'SYSTEM TABLE'\n          when 'INTERNAL_TABLE' then 'SYSTEM TABLE'\n          when 'SQL_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'CLR_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'EXTENDED_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'SQL_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'CLR_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'SQL_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_INLINE_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_TRIGGER' then 'TRIGGER'\n          when 'CLR_TRIGGER' then 'TRIGGER'\n          else type_desc \n        end as type\nFROM sys.dm_sql_referenced_entities(?, 'OBJECT') re \n  JOIN sys.all_objects ao on ao.object_id = re.referenced_id";
    private final String searchDefaultConstraints = "SELECT db_name() as catalog_name, \n       schema_name(ao.schema_id) as schema_name,\n       ao.name as constraint_name, \n       'DEFAULT' as type \nfrom sys.columns c \n  join sys.all_objects ao on ao.object_id = c.default_object_id \nwhere c.object_id = object_id(?)\n  and ao.type = 'D'\n  and coalesce(ao.parent_object_id,0) = 0;";
    private final String searchColumnTypes = "select distinct db_name() as catalog_name, \n       schema_name(t.schema_id) as schema_name,\n       t.name as type_name, \n       'TYPE' as type\nfrom sys.types t \n  join sys.columns c on c.user_type_id = t.user_type_id \nwhere c.object_id = object_id(?)\nand t.is_user_defined = 1";
    private final String searchUsedSqlDMView = "SELECT db_name() as catalog,  \n       coalesce(re.referencing_schema_name,schema_name()) as schema_name,  \n       re.referencing_entity_name, \n       case ao.type_desc \n          when 'USER_TABLE' then 'TABLE'\n          when 'SYSTEM_TABLE' then 'SYSTEM TABLE'\n          when 'INTERNAL_TABLE' then 'SYSTEM TABLE'\n          when 'SQL_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'CLR_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'EXTENDED_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'SQL_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'CLR_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'SQL_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_INLINE_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_TRIGGER' then 'TRIGGER'\n          when 'CLR_TRIGGER' then 'TRIGGER'\n          else type_desc \n        end as type, \n        case \n          when ao.type_desc like '%TRIGGER%' then\n             case\n                when ObjectProperty(ao.object_id, 'ExecIsUpdateTrigger') = 1 then 'UPDATE'\n                when ObjectProperty(ao.object_id, 'ExecIsDeleteTrigger') = 1 then 'DELETE'\n                when ObjectProperty(ao.object_id, 'ExecIsInsertTrigger') = 1 then 'INSERT'\n             end\n        end as trigger_event,\n        case \n          when ao.type_desc like '%TRIGGER%' then\n             case\n                when ObjectProperty(ao.object_id, 'ExecIsAfterTrigger') = 1 then 'AFTER'\n                when ObjectProperty(ao.object_id, 'ExecIsInsteadOfTrigger') = 1 then 'INSTEAD OF'\n                else 'BEFORE'\n             end \n         end as trigger_type \nFROM sys.dm_sql_referencing_entities(?, 'OBJECT') re \n  JOIN sys.all_objects ao on ao.object_id = re.referencing_id";
    private final CatalogChanger catalogChanger = new CatalogChanger();

    public SqlServerDependencyReader() {
        this.catalogChanger.setFireEvents(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbObject> getUsedObjects(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null || wbConnection == null) {
            return Collections.emptyList();
        }
        String string = this.changeDatabase(wbConnection, dbObject.getCatalog());
        List<DbObject> list = null;
        try {
            Object object;
            Object object2;
            list = wbConnection.getDbSettings().getBoolProperty("dependency.use.infoschema", false) ? this.retrieveObjects(wbConnection, dbObject, "SELECT vtu.TABLE_CATALOG, vtu.TABLE_SCHEMA, vtu.TABLE_NAME,\n       case ao.type_desc \n          when 'USER_TABLE' then 'TABLE'\n          when 'SYSTEM_TABLE' then 'SYSTEM TABLE'\n          when 'INTERNAL_TABLE' then 'SYSTEM TABLE'\n          when 'SQL_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'CLR_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'EXTENDED_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'SQL_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'CLR_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'SQL_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_INLINE_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_TRIGGER' then 'TRIGGER'\n          when 'CLR_TRIGGER' then 'TRIGGER'\n          else type_desc \n        end as type\nFROM INFORMATION_SCHEMA.VIEW_TABLE_USAGE vtu \n  JOIN sys.all_objects ao ON ao.name = vtu.TABLE_NAME and schema_name(ao.schema_id) = vtu.TABLE_SCHEMA\nWHERE VIEW_CATALOG = ? \n  AND VIEW_SCHEMA = ? \n  AND VIEW_NAME = ?", false) : this.retrieveObjects(wbConnection, dbObject, "SELECT distinct db_name() as catalog_name,  \n       coalesce(re.referenced_schema_name, schema_name()) as schema_name,  \n       re.referenced_entity_name,  \n       case ao.type_desc \n          when 'USER_TABLE' then 'TABLE'\n          when 'SYSTEM_TABLE' then 'SYSTEM TABLE'\n          when 'INTERNAL_TABLE' then 'SYSTEM TABLE'\n          when 'SQL_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'CLR_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'EXTENDED_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'SQL_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'CLR_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'SQL_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_INLINE_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_TRIGGER' then 'TRIGGER'\n          when 'CLR_TRIGGER' then 'TRIGGER'\n          else type_desc \n        end as type\nFROM sys.dm_sql_referenced_entities(?, 'OBJECT') re \n  JOIN sys.all_objects ao on ao.object_id = re.referenced_id", true);
            if (wbConnection.getMetadata().isTableType(dbObject.getObjectType())) {
                object2 = this.retrieveObjects(wbConnection, dbObject, "SELECT db_name() as catalog_name, \n       schema_name(ao.schema_id) as schema_name,\n       ao.name as constraint_name, \n       'DEFAULT' as type \nfrom sys.columns c \n  join sys.all_objects ao on ao.object_id = c.default_object_id \nwhere c.object_id = object_id(?)\n  and ao.type = 'D'\n  and coalesce(ao.parent_object_id,0) = 0;", true);
                list.addAll((Collection<DbObject>)object2);
                object = this.retrieveObjects(wbConnection, dbObject, "select distinct db_name() as catalog_name, \n       schema_name(t.schema_id) as schema_name,\n       t.name as type_name, \n       'TYPE' as type\nfrom sys.types t \n  join sys.columns c on c.user_type_id = t.user_type_id \nwhere c.object_id = object_id(?)\nand t.is_user_defined = 1", true);
                list.addAll((Collection<DbObject>)object);
            }
            if (SqlServerUtil.supportsPartitioning(wbConnection) && dbObject instanceof TableIdentifier && (object = ((SqlServerPartitionReader)(object2 = new SqlServerPartitionReader(wbConnection))).getSchemeForTable((TableIdentifier)dbObject)) != null) {
                list.add((DbObject)object);
                PartitionFunction partitionFunction = ((SqlServerPartitionReader)object2).getFunctionForTable((TableIdentifier)dbObject);
                list.add(partitionFunction);
            }
        }
        finally {
            this.changeDatabase(wbConnection, string);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbObject> getUsedBy(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null || wbConnection == null) {
            return Collections.emptyList();
        }
        String string = this.changeDatabase(wbConnection, dbObject.getCatalog());
        try {
            if (wbConnection.getDbSettings().getBoolProperty("dependency.use.infoschema", false)) {
                List<DbObject> list = this.retrieveObjects(wbConnection, dbObject, "SELECT vtu.VIEW_CATALOG, vtu.VIEW_SCHEMA, vtu.VIEW_NAME,\n       case ao.type_desc \n          when 'USER_TABLE' then 'TABLE'\n          when 'SYSTEM_TABLE' then 'SYSTEM TABLE'\n          when 'INTERNAL_TABLE' then 'SYSTEM TABLE'\n          when 'SQL_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'CLR_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'EXTENDED_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'SQL_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'CLR_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'SQL_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_INLINE_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_TRIGGER' then 'TRIGGER'\n          when 'CLR_TRIGGER' then 'TRIGGER'\n          else type_desc \n        end as type\nFROM INFORMATION_SCHEMA.VIEW_TABLE_USAGE vtu \n  JOIN sys.all_objects ao ON ao.name = vtu.VIEW_NAME and schema_name(ao.schema_id) = vtu.VIEW_SCHEMA\nWHERE TABLE_CATALOG = ? \n  AND TABLE_SCHEMA = ? \n  AND TABLE_NAME = ?", false);
                return list;
            }
            List<DbObject> list = this.retrieveObjects(wbConnection, dbObject, "SELECT db_name() as catalog,  \n       coalesce(re.referencing_schema_name,schema_name()) as schema_name,  \n       re.referencing_entity_name, \n       case ao.type_desc \n          when 'USER_TABLE' then 'TABLE'\n          when 'SYSTEM_TABLE' then 'SYSTEM TABLE'\n          when 'INTERNAL_TABLE' then 'SYSTEM TABLE'\n          when 'SQL_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'CLR_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'EXTENDED_STORED_PROCEDURE' then 'PROCEDURE'\n          when 'SQL_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'CLR_SCALAR_FUNCTION' then 'FUNCTION'\n          when 'SQL_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_INLINE_TABLE_VALUED_FUNCTION' then 'FUNCTION'\n          when 'SQL_TRIGGER' then 'TRIGGER'\n          when 'CLR_TRIGGER' then 'TRIGGER'\n          else type_desc \n        end as type, \n        case \n          when ao.type_desc like '%TRIGGER%' then\n             case\n                when ObjectProperty(ao.object_id, 'ExecIsUpdateTrigger') = 1 then 'UPDATE'\n                when ObjectProperty(ao.object_id, 'ExecIsDeleteTrigger') = 1 then 'DELETE'\n                when ObjectProperty(ao.object_id, 'ExecIsInsertTrigger') = 1 then 'INSERT'\n             end\n        end as trigger_event,\n        case \n          when ao.type_desc like '%TRIGGER%' then\n             case\n                when ObjectProperty(ao.object_id, 'ExecIsAfterTrigger') = 1 then 'AFTER'\n                when ObjectProperty(ao.object_id, 'ExecIsInsteadOfTrigger') = 1 then 'INSTEAD OF'\n                else 'BEFORE'\n             end \n         end as trigger_type \nFROM sys.dm_sql_referencing_entities(?, 'OBJECT') re \n  JOIN sys.all_objects ao on ao.object_id = re.referencing_id", true);
            return list;
        }
        finally {
            this.changeDatabase(wbConnection, string);
        }
    }

    private String changeDatabase(WbConnection wbConnection, String string) {
        if (string == null || wbConnection == null) {
            return string;
        }
        String string2 = wbConnection.getCurrentCatalog();
        try {
            if (StringUtil.stringsAreNotEqual(string, string2)) {
                this.catalogChanger.setCurrentCatalog(wbConnection, string);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not change database", exception);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DbObject> retrieveObjects(WbConnection wbConnection, DbObject dbObject, String string, boolean bl) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
        String string2 = this.buildFQName(wbConnection, dbObject);
        if (bl) {
            LogMgr.logMetadataSql(new CallerInfo(){}, "dependent objects", string, string2);
        } else {
            LogMgr.logMetadataSql(new CallerInfo(){}, "dependent objects", string, dbObject.getCatalog(), dbObject.getSchema(), dbObject.getObjectName(), dbObject.getObjectType());
        }
        try {
            boolean bl2;
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            if (bl) {
                preparedStatement.setString(1, string2);
            } else {
                preparedStatement.setString(1, dbObject.getCatalog());
                preparedStatement.setString(2, dbObject.getSchema());
                preparedStatement.setString(3, dbObject.getObjectName());
            }
            resultSet = preparedStatement.executeQuery();
            boolean bl3 = bl2 = resultSet.getMetaData().getColumnCount() > 4;
            while (resultSet.next()) {
                DbObject dbObject2;
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                DbObject dbObject3 = null;
                if (string6.equals("PROCEDURE")) {
                    dbObject3 = new ProcedureDefinition(string3, string4, string5);
                } else if (string6.equals("FUNCTION")) {
                    dbObject3 = new ProcedureDefinition(string3, string4, string5, 2);
                } else if (string6.equals("TRIGGER")) {
                    dbObject2 = new TriggerDefinition(string3, string4, string5);
                    if (bl2) {
                        String string7 = resultSet.getString("trigger_event");
                        String string8 = resultSet.getString("trigger_type");
                        ((TriggerDefinition)dbObject2).setTriggerEvent(string7);
                        ((TriggerDefinition)dbObject2).setTriggerType(string8);
                    }
                    dbObject3 = dbObject2;
                } else if (string6.equals("DEFAULT")) {
                    dbObject3 = new NamedDefault(string3, string4, string5);
                } else if (string6.equals("TYPE")) {
                    dbObject2 = new DomainIdentifier(string3, string4, string5);
                    ((DomainIdentifier)dbObject2).setObjectType("TYPE");
                    dbObject3 = dbObject2;
                } else {
                    dbObject2 = new TableIdentifier(string3, string4, string5);
                    ((TableIdentifier)dbObject2).setNeverAdjustCase(true);
                    ((TableIdentifier)dbObject2).setType(string6);
                    dbObject3 = dbObject2;
                }
                arrayList.add(dbObject3);
            }
        }
        catch (Exception exception) {
            block21: {
                try {
                    if (bl) {
                        LogMgr.logMetadataError(new CallerInfo(){}, exception, "dependent objects", string, string2);
                        break block21;
                    }
                    LogMgr.logMetadataError(new CallerInfo(){}, exception, "dependent objects", string, dbObject.getCatalog(), dbObject.getSchema(), dbObject.getObjectName(), dbObject.getObjectType());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        DbObjectSorter dbObjectSorter = new DbObjectSorter(true);
        dbObjectSorter.setIncludeType(true);
        Collections.sort(arrayList, dbObjectSorter);
        return arrayList;
    }

    private String buildFQName(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        String string = wbConnection.getMetadata().quoteObjectname(dbObject.getSchema());
        String string2 = wbConnection.getMetadata().quoteObjectname(dbObject.getObjectName());
        if (StringUtil.isEmptyString(string)) {
            string = wbConnection.getMetadata().quoteObjectname(wbConnection.getCurrentSchema());
        }
        return string + "." + string2;
    }

    @Override
    public boolean supportsUsedByDependency(String string) {
        return this.supportedTypes.contains(string);
    }

    @Override
    public boolean supportsIsUsingDependency(String string) {
        return this.supportedTypes.contains(string);
    }
}

