/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.DbMetadata;
import workbench.db.DbObjectFinder;
import workbench.db.JdbcUtils;
import workbench.db.SynonymReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class SqlServerSynonymReader
implements SynonymReader {
    private DbMetadata meta;
    private final String baseSql = "SELECT db_name(), \n       sc.name as schema_name, \n       syn.name as synonym_name, \n       syn.base_object_name \nFROM sys.synonyms syn with (nolock) \n  JOIN sys.schemas sc with (nolock) ON syn.schema_id = sc.schema_id \n";

    public SqlServerSynonymReader(DbMetadata dbMetadata) {
        this.meta = dbMetadata;
    }

    public static boolean supportsSynonyms(WbConnection wbConnection) {
        return SqlServerUtil.isSqlServer2005(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableIdentifier> getSynonymList(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        StringBuilder stringBuilder = new StringBuilder("SELECT db_name(), \n       sc.name as schema_name, \n       syn.name as synonym_name, \n       syn.base_object_name \nFROM sys.synonyms syn with (nolock) \n  JOIN sys.schemas sc with (nolock) ON syn.schema_id = sc.schema_id \n".length() + 50);
        stringBuilder.append("SELECT db_name(), \n       sc.name as schema_name, \n       syn.name as synonym_name, \n       syn.base_object_name \nFROM sys.synonyms syn with (nolock) \n  JOIN sys.schemas sc with (nolock) ON syn.schema_id = sc.schema_id \n");
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append("WHERE sc.name = ?");
            bl = true;
            n = 1;
        }
        if (StringUtil.isNonBlank(string3)) {
            if (bl) {
                stringBuilder.append(" AND ");
            } else {
                stringBuilder.append("WHERE ");
            }
            if (string3.indexOf(37) > -1) {
                stringBuilder.append(" syn.name LIKE ? ");
                string3 = SqlUtil.escapeUnderscore(string3, wbConnection);
                SqlUtil.appendEscapeClause(stringBuilder, wbConnection, string3);
            } else {
                stringBuilder.append(" syn.name = ? ");
            }
            n2 = n == 1 ? 2 : 1;
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "synonym list", stringBuilder, string2, string3);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(stringBuilder.toString());
            if (n != -1) {
                preparedStatement.setString(n, string2);
            }
            if (n2 != -1) {
                preparedStatement.setString(n2, string3);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                if (string6 == null) continue;
                TableIdentifier tableIdentifier = new TableIdentifier(string4, string5, string6, false);
                tableIdentifier.setType("SYNONYM");
                tableIdentifier.setNeverAdjustCase(true);
                arrayList.add(tableIdentifier);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "synonym list", stringBuilder, string2, string3);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableIdentifier getSynonymTable(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        Object object;
        Object object2;
        String string4 = "SELECT db_name(), \n       sc.name as schema_name, \n       syn.name as synonym_name, \n       syn.base_object_name \nFROM sys.synonyms syn with (nolock) \n  JOIN sys.schemas sc with (nolock) ON syn.schema_id = sc.schema_id \nWHERE syn.name = ? \n  AND sc.name = ?";
        LogMgr.logMetadataSql(new CallerInfo(){}, "synonym table", string4, new Object[0]);
        PreparedStatement preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        TableIdentifier tableIdentifier = null;
        try {
            if (resultSet.next()) {
                object2 = resultSet.getString(1);
                object = resultSet.getString(2);
                String string5 = resultSet.getString(4);
                if (string5 != null) {
                    tableIdentifier = new TableIdentifier((String)object2, (String)object, this.meta.removeQuotes(string5), false);
                    tableIdentifier.setNeverAdjustCase(false);
                }
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "synonym table", string4, new Object[0]);
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        if (tableIdentifier == null) {
            return null;
        }
        tableIdentifier.setSchema(string2);
        object2 = new DbObjectFinder(this.meta);
        object = ((DbObjectFinder)object2).findObject(tableIdentifier);
        return object;
    }
}

