/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mysql;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListEnhancer;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.StringUtil;

public class MySQLTableCommentReader
implements ObjectListEnhancer {
    public static boolean retrieveComments() {
        return Settings.getInstance().getBoolProperty("workbench.db.mysql.tablecomments.retrieve", false);
    }

    @Override
    public void updateObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (MySQLTableCommentReader.retrieveComments()) {
            this.updateObjectRemarks(wbConnection, dataStore, string, string2, string3, stringArray);
        }
    }

    protected void updateObjectRemarks(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (dataStore == null) {
            return;
        }
        if (dataStore.getRowCount() == 0) {
            return;
        }
        String string4 = null;
        if (dataStore.getRowCount() == 1) {
            string4 = dataStore.getValueAsString(0, 0);
        }
        Map<String, String> map = this.readRemarks(wbConnection, string, string4, stringArray);
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string5 = dataStore.getValueAsString(i, 0);
            String string6 = dataStore.getValueAsString(i, 2);
            String string7 = map.get(this.getNameKey(string6, string5));
            if (string7 == null || string7.equals("VIEW")) continue;
            dataStore.setValue(i, 4, (Object)string7);
        }
    }

    private String getNameKey(String string, String string2) {
        if (string != null && string2 != null) {
            return string.trim() + "." + string2.trim();
        }
        if (string2 != null) {
            return string2.trim();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> readRemarks(WbConnection wbConnection, String string, String string2, String[] stringArray) {
        String string3 = "select table_schema, table_name, table_comment from information_schema.tables";
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            string3 = string3 + " WHERE table_name = '" + string2 + "'";
            bl = true;
        }
        if (StringUtil.isNonBlank(string)) {
            string3 = bl ? string3 + " AND " : string3 + " WHERE ";
            string3 = string3 + " table_schema = '" + string + "'";
            bl = true;
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "remarks", string3, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        TreeMap<String, String> treeMap = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
        try {
            statement = wbConnection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                if (string5 == null || !StringUtil.isNonBlank(string6)) continue;
                treeMap.put(this.getNameKey(string4, string5), string6);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "remarks", string3, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return treeMap;
    }
}

