/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.nuodb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DomainIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class NuoDBDomainReader
implements ObjectListExtender {
    final String baseSql = "SELECT dom.schema, \n       dom.domainname, \n       dom.collationsequence, \n       dt.name as datatype, \n       dt.jdbctype as jdbctype, \n       dom.scale, \n       dom.precision, \n       dom.length, \n       case when FLAGS = 1 then false else true end as nullable, \n       dom.defaultvalue, \n       dom.remarks \nfrom system.domains dom \n join system.datatypes dt on dt.id = dom.datatype";

    private String getSql(WbConnection wbConnection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("SELECT dom.schema, \n       dom.domainname, \n       dom.collationsequence, \n       dt.name as datatype, \n       dt.jdbctype as jdbctype, \n       dom.scale, \n       dom.precision, \n       dom.length, \n       case when FLAGS = 1 then false else true end as nullable, \n       dom.defaultvalue, \n       dom.remarks \nfrom system.domains dom \n join system.datatypes dt on dt.id = dom.datatype".length() + 40);
        stringBuilder.append("SELECT dom.schema, \n       dom.domainname, \n       dom.collationsequence, \n       dt.name as datatype, \n       dt.jdbctype as jdbctype, \n       dom.scale, \n       dom.precision, \n       dom.length, \n       case when FLAGS = 1 then false else true end as nullable, \n       dom.defaultvalue, \n       dom.remarks \nfrom system.domains dom \n join system.datatypes dt on dt.id = dom.datatype");
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append(" WHERE dom.domainname like '");
            stringBuilder.append(wbConnection.getMetadata().quoteObjectname(string2));
            stringBuilder.append("%' ");
            bl = true;
        }
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append(bl ? " AND " : " WHERE ");
            stringBuilder.append(" dom.schema = '");
            stringBuilder.append(wbConnection.getMetadata().quoteObjectname(string));
            stringBuilder.append("'");
        }
        stringBuilder.append(" ORDER BY dom.schema, dom.domainname ");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DomainIdentifier> getDomainList(WbConnection wbConnection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<DomainIdentifier> arrayList = new ArrayList<DomainIdentifier>();
        String string3 = this.getSql(wbConnection, string, string2);
        LogMgr.logMetadataSql(new CallerInfo(){}, "domains", string3, new Object[0]);
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("schema");
                String string5 = resultSet.getString("domainname");
                DomainIdentifier domainIdentifier = new DomainIdentifier(null, string4, string5);
                String string6 = resultSet.getString("datatype");
                int n = resultSet.getInt("jdbctype");
                int n2 = resultSet.getInt("precision");
                int n3 = 0;
                n3 = SqlUtil.isCharacterType(n) ? resultSet.getInt("length") : resultSet.getInt("scale");
                String string7 = SqlUtil.getSqlTypeDisplay(string6, n, n3, n2);
                domainIdentifier.setDataType(string7);
                boolean bl = resultSet.getBoolean("nullable");
                domainIdentifier.setNullable(bl);
                domainIdentifier.setDefaultValue(resultSet.getString("defaultvalue"));
                domainIdentifier.setComment(resultSet.getString("remarks"));
                arrayList.add(domainIdentifier);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "domains", string3, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public DomainIdentifier getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<DomainIdentifier> list = this.getDomainList(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public String getDomainSource(DomainIdentifier domainIdentifier) {
        if (domainIdentifier == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("CREATE DOMAIN ");
        stringBuilder.append(domainIdentifier.getObjectName());
        stringBuilder.append(" AS ");
        stringBuilder.append(domainIdentifier.getDataType());
        if (StringUtil.isNonBlank(domainIdentifier.getDefaultValue())) {
            stringBuilder.append(" DEFAULT ");
            stringBuilder.append(domainIdentifier.getDefaultValue());
        }
        if (!domainIdentifier.isNullable()) {
            stringBuilder.append(" NOT NULL");
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("DOMAIN", stringArray)) {
            return false;
        }
        List<DomainIdentifier> list = this.getDomainList(wbConnection, string2, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (DomainIdentifier domainIdentifier : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)domainIdentifier.getSchema());
            dataStore.setValue(n, 0, (Object)domainIdentifier.getObjectName());
            dataStore.setValue(n, 4, (Object)domainIdentifier.getComment());
            dataStore.setValue(n, 1, (Object)domainIdentifier.getObjectType());
            dataStore.getRow(n).setUserObject(domainIdentifier);
        }
        return true;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("DOMAIN", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        DomainIdentifier domainIdentifier = this.getObjectDefinition(wbConnection, dbObject);
        if (domainIdentifier == null) {
            return null;
        }
        String[] stringArray = new String[]{"DOMAIN", "DATA_TYPE", "NULLABLE", "CONSTRAINT", "REMARKS"};
        int[] nArray = new int[]{12, 12, 16, 12, 12};
        int[] nArray2 = new int[]{20, 10, 5, 30, 30};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        dataStore.addRow();
        dataStore.setValue(0, 0, (Object)domainIdentifier.getObjectName());
        dataStore.setValue(0, 1, (Object)domainIdentifier.getDataType());
        dataStore.setValue(0, 2, (Object)domainIdentifier.isNullable());
        dataStore.setValue(0, 3, (Object)domainIdentifier.getCheckConstraint());
        dataStore.setValue(0, 4, (Object)domainIdentifier.getComment());
        return dataStore;
    }

    @Override
    public List<String> supportedTypes() {
        return Collections.singletonList("DOMAIN");
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        return this.getDomainSource(this.getObjectDefinition(wbConnection, dbObject));
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

