/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleDDLCleaner;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DbmsMetadata {
    private static final String ENABLE_TRANSFORM = "{call dbms_metadata.set_transform_param(dbms_metadata.session_transform, ?, true)}";
    private static final String DISABLE_TRANSFORM = "{call dbms_metadata.set_transform_param(dbms_metadata.session_transform, ?, false)}";

    public static String getDependentDDL(WbConnection wbConnection, String string, String string2, String string3) {
        try {
            return DbmsMetadata.getDDL(wbConnection, string, string2, string3, true);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String getDDL(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        return DbmsMetadata.getDDL(wbConnection, string, string2, string3, false);
    }

    public static String getTableDDL(WbConnection wbConnection, String string, String string2, boolean bl, boolean bl2) throws SQLException {
        if (!bl2) {
            DbmsMetadata.disableTransformParam(wbConnection, "REF_CONSTRAINTS");
        }
        if (!bl) {
            DbmsMetadata.disableTransformParam(wbConnection, "CONSTRAINTS");
        }
        return DbmsMetadata.getDDL(wbConnection, "TABLE", string, string2, false);
    }

    private static String getDDL(WbConnection wbConnection, String string, String string2, String string3, boolean bl) throws SQLException {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String string4 = null;
        long l = System.currentTimeMillis();
        String string5 = null;
        string5 = bl ? "select dbms_metadata.get_dependent_ddl(?, ?, ?) from dual" : "select dbms_metadata.get_ddl(?, ?, ?) from dual";
        try {
            DbmsMetadata.initTransforms(wbConnection);
            LogMgr.logMetadataSql(new CallerInfo(){}, "dbms_metadata for " + string, string5, string, string2, string3);
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string5, 1003, 1007);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, SqlUtil.removeObjectQuotes(string2));
            preparedStatement.setString(3, SqlUtil.removeObjectQuotes(string3));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string4 = StringUtil.trim(resultSet.getString(1));
            }
            if (OracleUtils.cleanupDDLQuotedIdentifiers()) {
                string4 = OracleDDLCleaner.cleanupQuotedIdentifiers(string4);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "dbms_metadata for " + string, string5, string, string2, string3);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                DbmsMetadata.resetSessionTransforms(wbConnection);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        DbmsMetadata.resetSessionTransforms(wbConnection);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving DDL using dbms_metadata for " + string + " " + string3 + "." + string2 + " took: " + l2 + "ms");
        return string4;
    }

    private static void initTransforms(WbConnection wbConnection) {
        CallableStatement callableStatement = null;
        try {
            callableStatement = wbConnection.getSqlConnection().prepareCall(ENABLE_TRANSFORM);
            callableStatement.setString(1, "SQLTERMINATOR");
            callableStatement.execute();
            callableStatement.setString(1, "PRETTY");
            callableStatement.execute();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(callableStatement);
            LogMgr.logDebug(new CallerInfo(){}, "Could not set transform parameter", throwable);
        }
    }

    private static void resetSessionTransforms(WbConnection wbConnection) {
        CallableStatement callableStatement = null;
        try {
            callableStatement = wbConnection.getSqlConnection().prepareCall(ENABLE_TRANSFORM);
            callableStatement.setString(1, "DEFAULT");
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(callableStatement);
            LogMgr.logDebug(new CallerInfo(){}, "Could not reset transform parameters", throwable);
        }
    }

    private static void disableTransformParam(WbConnection wbConnection, String string) {
        CallableStatement callableStatement = null;
        try {
            callableStatement = wbConnection.getSqlConnection().prepareCall(DISABLE_TRANSFORM);
            callableStatement.setString(1, string);
            callableStatement.execute();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(callableStatement);
            LogMgr.logDebug(new CallerInfo(){}, "Could not disable transform parameter: " + string, throwable);
        }
    }
}

