/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.CallableStatement;
import java.util.Set;
import workbench.db.JdbcUtils;
import workbench.db.RegexErrorPositionReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.ErrorDescriptor;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OracleErrorPositionReader
extends RegexErrorPositionReader {
    private final Set<String> verbs = CollectionUtil.caseInsensitiveSet("SELECT", "INSERT", "UPDATE", "DELETE", "MERGE", "WITH");

    public OracleErrorPositionReader() {
        this(Settings.getInstance().getBoolProperty("workbench.db.oracle.errorposition.check_create", true), Settings.getInstance().getBoolProperty("workbench.db.oracle.errorposition.check_drop", false));
    }

    public OracleErrorPositionReader(boolean bl, boolean bl2) {
        super("(?i)\\s(line|zeile)\\s[0-9]+", "(?i)\\s(column|spalte)\\s[0-9]+");
        if (bl) {
            this.verbs.add("CREATE");
        }
        if (bl2) {
            this.verbs.add("DROP");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorDescriptor getErrorPosition(WbConnection wbConnection, String string, Exception exception) {
        String string2 = wbConnection.getParsingUtil().getSqlVerb(string);
        if (!this.verbs.contains(string2)) {
            ErrorDescriptor errorDescriptor = super.getErrorPosition(wbConnection, string, exception);
            if (errorDescriptor != null) {
                errorDescriptor.setMessageIncludesPosition(true);
            }
            return errorDescriptor;
        }
        String string3 = "-- SQL Workbench \nDECLARE \n  l_cursor NUMBER; \n  l_result NUMBER; \nBEGIN \n  l_result := -1; \n  BEGIN \n    l_cursor := DBMS_SQL.OPEN_CURSOR; \n    DBMS_SQL.PARSE(l_cursor, :1, DBMS_SQL.NATIVE); \n  EXCEPTION \n    WHEN OTHERS THEN\n     l_result := DBMS_SQL.LAST_ERROR_POSITION; \n  END; \n  DBMS_SQL.CLOSE_CURSOR(l_cursor); \n  :2 := l_result;\nEND;";
        CallableStatement callableStatement = null;
        int n = -1;
        try {
            callableStatement = wbConnection.getSqlConnection().prepareCall(string3);
            callableStatement.registerOutParameter(2, 4);
            callableStatement.setString(1, string);
            callableStatement.execute();
            n = callableStatement.getInt(2);
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logDebug(new CallerInfo(){}, "Could not retrieve error offset", throwable);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeStatement(callableStatement);
                throw throwable2;
            }
            JdbcUtils.closeStatement(callableStatement);
        }
        JdbcUtils.closeStatement(callableStatement);
        if (n > -1) {
            LogMgr.logDebug(new CallerInfo(){}, "Error at position: " + n + " reported by Oracle");
            ErrorDescriptor errorDescriptor = new ErrorDescriptor();
            errorDescriptor.setErrorOffset(n);
            errorDescriptor.setErrorMessage(exception.getMessage());
            return errorDescriptor;
        }
        return null;
    }

    @Override
    public String enhanceErrorMessage(String string, String string2, ErrorDescriptor errorDescriptor) {
        String string3;
        if (errorDescriptor == null) {
            return string2;
        }
        if (!errorDescriptor.hasError()) {
            return string2;
        }
        if (!errorDescriptor.getMessageIncludesPosition()) {
            SqlUtil.calculateErrorLine(string, errorDescriptor);
            if (errorDescriptor.getErrorColumn() > -1 && errorDescriptor.getErrorLine() > -1) {
                if (StringUtil.isNonEmpty(string2)) {
                    string2 = string2 + "\n";
                }
                string2 = "Error at line " + (errorDescriptor.getErrorLine() + 1) + ":\n" + string2.trim();
            } else {
                int n = errorDescriptor.getErrorPosition();
                string2 = string2.trim() + " (position: " + n + ")";
            }
        }
        if ((string3 = SqlUtil.getErrorIndicator(string, errorDescriptor)) != null) {
            if (StringUtil.isNonEmpty(string2)) {
                string2 = string2 + "\n";
            }
            string2 = string2 + string3;
        }
        return string2;
    }
}

